/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.indirect;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.backend.compile.ContextShader;
import com.zurrtum.create.client.flywheel.backend.compile.IndirectPrograms;
import com.zurrtum.create.client.flywheel.backend.compile.PipelineCompiler;
import com.zurrtum.create.client.flywheel.backend.engine.InstancerKey;
import com.zurrtum.create.client.flywheel.backend.engine.MaterialRenderState;
import com.zurrtum.create.client.flywheel.backend.engine.MeshPool;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.IndirectBuffers;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.IndirectDraw;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.IndirectInstancer;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.StagingBuffer;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.Uniforms;
import com.zurrtum.create.client.flywheel.backend.gl.GlCompat;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlProgram;
import com.zurrtum.create.client.flywheel.lib.math.MoreMath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GL43;

@Environment(value=EnvType.CLIENT)
public class IndirectCullingGroup<I extends Instance> {
    private static final Comparator<IndirectDraw> DRAW_COMPARATOR = Comparator.comparing(IndirectDraw::isEmbedded).thenComparingInt(IndirectDraw::bias).thenComparingInt(IndirectDraw::indexOfMeshInModel).thenComparing(IndirectDraw::material, MaterialRenderState.COMPARATOR);
    private final InstanceType<I> instanceType;
    private final long instanceStride;
    private final IndirectBuffers buffers;
    private final List<IndirectInstancer<I>> instancers = new ArrayList<IndirectInstancer<I>>();
    private final List<IndirectDraw> indirectDraws = new ArrayList<IndirectDraw>();
    private final List<MultiDraw> multiDraws = new ArrayList<MultiDraw>();
    private final List<MultiDraw> oitDraws = new ArrayList<MultiDraw>();
    private final IndirectPrograms programs;
    private final GlProgram cullProgram;
    private boolean needsDrawBarrier;
    private boolean needsDrawSort;
    private int instanceCountThisFrame;

    IndirectCullingGroup(InstanceType<I> instanceType, IndirectPrograms programs) {
        this.instanceType = instanceType;
        this.instanceStride = MoreMath.align4(instanceType.layout().byteSize());
        this.buffers = new IndirectBuffers(this.instanceStride);
        this.programs = programs;
        this.cullProgram = programs.getCullingProgram(instanceType);
    }

    public boolean flushInstancers() {
        boolean out;
        this.instanceCountThisFrame = 0;
        int modelIndex = 0;
        Iterator<IndirectInstancer<I>> iterator = this.instancers.iterator();
        while (iterator.hasNext()) {
            IndirectInstancer<I> instancer = iterator.next();
            int instanceCount = instancer.instanceCount();
            if (instanceCount == 0) {
                iterator.remove();
                instancer.delete();
                continue;
            }
            instancer.update(modelIndex, this.instanceCountThisFrame);
            this.instanceCountThisFrame += instanceCount;
            ++modelIndex;
        }
        if (this.indirectDraws.removeIf(IndirectDraw::deleted)) {
            this.needsDrawSort = true;
        }
        if (out = this.indirectDraws.isEmpty()) {
            this.delete();
        }
        return out;
    }

    public void upload(StagingBuffer stagingBuffer) {
        this.buffers.updateCounts(this.instanceCountThisFrame, this.instancers.size(), this.indirectDraws.size());
        this.uploadInstances(stagingBuffer);
        this.buffers.objectStorage.uploadDescriptors(stagingBuffer);
        this.uploadModels(stagingBuffer);
        if (this.needsDrawSort) {
            this.sortDraws();
            this.needsDrawSort = false;
        }
        this.uploadDraws(stagingBuffer);
        this.needsDrawBarrier = true;
    }

    public void dispatchCull() {
        Uniforms.bindAll();
        this.cullProgram.bind();
        this.buffers.bindForCull();
        GL43.glDispatchCompute((int)this.buffers.objectStorage.capacity(), (int)1, (int)1);
    }

    public void dispatchApply() {
        this.buffers.bindForApply();
        GL43.glDispatchCompute((int)GlCompat.getComputeGroupCount(this.indirectDraws.size()), (int)1, (int)1);
    }

    public boolean hasOitDraws() {
        return !this.oitDraws.isEmpty();
    }

    private void sortDraws() {
        this.multiDraws.clear();
        this.oitDraws.clear();
        this.indirectDraws.sort(DRAW_COMPARATOR);
        int start = 0;
        for (int i = 0; i < this.indirectDraws.size(); ++i) {
            IndirectDraw draw1 = this.indirectDraws.get(i);
            if (i != this.indirectDraws.size() - 1 && !this.incompatibleDraws(draw1, this.indirectDraws.get(i + 1))) continue;
            List<MultiDraw> dst = draw1.material().transparency() == Transparency.ORDER_INDEPENDENT ? this.oitDraws : this.multiDraws;
            dst.add(new MultiDraw(draw1.material(), draw1.isEmbedded(), start, i + 1));
            start = i + 1;
        }
    }

    private boolean incompatibleDraws(IndirectDraw draw1, IndirectDraw draw2) {
        if (draw1.isEmbedded() != draw2.isEmbedded()) {
            return true;
        }
        return !MaterialRenderState.materialEquals(draw1.material(), draw2.material());
    }

    public void add(IndirectInstancer<I> instancer, InstancerKey<I> key, MeshPool meshPool) {
        instancer.mapping = this.buffers.objectStorage.createMapping();
        instancer.update(this.instancers.size(), -1);
        this.instancers.add(instancer);
        List<Model.ConfiguredMesh> meshes = key.model().meshes();
        for (int i = 0; i < meshes.size(); ++i) {
            Model.ConfiguredMesh entry = meshes.get(i);
            MeshPool.PooledMesh mesh = meshPool.alloc(entry.mesh());
            IndirectDraw draw = new IndirectDraw(instancer, entry.material(), mesh, key.bias(), i);
            this.indirectDraws.add(draw);
            instancer.addDraw(draw);
        }
        this.needsDrawSort = true;
    }

    public void submitSolid() {
        if (this.multiDraws.isEmpty()) {
            return;
        }
        this.buffers.bindForDraw();
        this.drawBarrier();
        GlProgram lastProgram = null;
        for (MultiDraw multiDraw : this.multiDraws) {
            GlProgram drawProgram = this.programs.getIndirectProgram(this.instanceType, multiDraw.embedded ? ContextShader.EMBEDDED : ContextShader.DEFAULT, multiDraw.material, PipelineCompiler.OitMode.OFF);
            if (drawProgram != lastProgram) {
                lastProgram = drawProgram;
                drawProgram.bind();
            }
            MaterialRenderState.setup(multiDraw.material);
            multiDraw.submit(drawProgram);
        }
    }

    public void submitTransparent(PipelineCompiler.OitMode oit) {
        if (this.oitDraws.isEmpty()) {
            return;
        }
        this.buffers.bindForDraw();
        this.drawBarrier();
        GlProgram lastProgram = null;
        for (MultiDraw multiDraw : this.oitDraws) {
            GlProgram drawProgram = this.programs.getIndirectProgram(this.instanceType, multiDraw.embedded ? ContextShader.EMBEDDED : ContextShader.DEFAULT, multiDraw.material, oit);
            if (drawProgram != lastProgram) {
                lastProgram = drawProgram;
                drawProgram.bind();
                drawProgram.setFloat("_flw_blueNoiseFactor", 0.07f);
            }
            MaterialRenderState.setupOit(multiDraw.material);
            multiDraw.submit(drawProgram);
        }
    }

    public void bindForCrumbling(Material material) {
        GlProgram program = this.programs.getIndirectProgram(this.instanceType, ContextShader.CRUMBLING, material, PipelineCompiler.OitMode.OFF);
        program.bind();
        this.buffers.bindForCrumbling();
        this.drawBarrier();
        program.setUInt("_flw_baseDraw", 0);
    }

    private void drawBarrier() {
        if (this.needsDrawBarrier) {
            GL42.glMemoryBarrier((int)64);
            this.needsDrawBarrier = false;
        }
    }

    private void uploadInstances(StagingBuffer stagingBuffer) {
        for (IndirectInstancer<I> instancer : this.instancers) {
            instancer.uploadInstances(stagingBuffer, this.buffers.objectStorage.objectBuffer.handle());
        }
    }

    private void uploadModels(StagingBuffer stagingBuffer) {
        long totalSize = (long)this.instancers.size() * 28L;
        int handle = this.buffers.model.handle();
        stagingBuffer.enqueueCopy(totalSize, handle, 0L, this::writeModels);
    }

    private void uploadDraws(StagingBuffer stagingBuffer) {
        long totalSize = (long)this.indirectDraws.size() * 36L;
        int handle = this.buffers.draw.handle();
        stagingBuffer.enqueueCopy(totalSize, handle, 0L, this::writeCommands);
    }

    private void writeModels(long writePtr) {
        for (IndirectInstancer<I> model : this.instancers) {
            model.writeModel(writePtr);
            writePtr += 28L;
        }
    }

    private void writeCommands(long writePtr) {
        for (IndirectDraw draw : this.indirectDraws) {
            draw.write(writePtr);
            writePtr += 36L;
        }
    }

    public void delete() {
        this.buffers.delete();
    }

    @Environment(value=EnvType.CLIENT)
    private record MultiDraw(Material material, boolean embedded, int start, int end) {
        private void submit(GlProgram drawProgram) {
            GlCompat.safeMultiDrawElementsIndirect(drawProgram, 4, 5125, this.start, this.end, 36L);
        }
    }
}

