/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visual;

import com.zurrtum.create.client.flywheel.api.visual.EntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractVisual;
import com.zurrtum.create.client.flywheel.lib.visual.EntityVisibilityTester;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1536;
import net.minecraft.class_1538;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_765;
import net.minecraft.class_8113;
import org.joml.FrustumIntersection;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractEntityVisual<T extends class_1297>
extends AbstractVisual
implements EntityVisual<T> {
    protected final T entity;
    protected final EntityVisibilityTester visibilityTester;

    public AbstractEntityVisual(VisualizationContext ctx, T entity, float partialTick) {
        super(ctx, entity.method_73183(), partialTick);
        this.entity = entity;
        this.visibilityTester = new EntityVisibilityTester((class_1297)entity, ctx.renderOrigin(), 1.5f);
    }

    public double distanceSquared(double x, double y, double z) {
        return this.entity.method_5649(x, y, z);
    }

    public Vector3f getVisualPosition() {
        class_243 pos = this.entity.method_73189();
        class_2382 renderOrigin = this.renderOrigin();
        return new Vector3f((float)(pos.field_1352 - (double)renderOrigin.method_10263()), (float)(pos.field_1351 - (double)renderOrigin.method_10264()), (float)(pos.field_1350 - (double)renderOrigin.method_10260()));
    }

    public Vector3f getVisualPosition(float partialTick) {
        class_243 pos = this.entity.method_73189();
        class_2382 renderOrigin = this.renderOrigin();
        return new Vector3f((float)(class_3532.method_16436((double)partialTick, (double)((class_1297)this.entity).field_6038, (double)pos.field_1352) - (double)renderOrigin.method_10263()), (float)(class_3532.method_16436((double)partialTick, (double)((class_1297)this.entity).field_5971, (double)pos.field_1351) - (double)renderOrigin.method_10264()), (float)(class_3532.method_16436((double)partialTick, (double)((class_1297)this.entity).field_5989, (double)pos.field_1350) - (double)renderOrigin.method_10260()));
    }

    public boolean isVisible(FrustumIntersection frustum) {
        return !this.canBeCulled(this.entity) || this.visibilityTester.check(frustum);
    }

    public boolean canBeCulled(T entity) {
        if (entity instanceof class_8113) {
            class_8113 displayEntity = (class_8113)entity;
            return displayEntity.method_61402();
        }
        return !(entity instanceof class_1510) && !(entity instanceof class_1536) && !(entity instanceof class_1538);
    }

    protected int computePackedLight(float partialTick) {
        class_2338 pos = class_2338.method_49638((class_2374)this.entity.method_31166(partialTick));
        int blockLight = this.entity.method_5809() ? 15 : this.level.method_8314(class_1944.field_9282, pos);
        int skyLight = this.level.method_8314(class_1944.field_9284, pos);
        return class_765.method_23687((int)blockLight, (int)skyLight);
    }

    protected void relight(float partialTick, FlatLit ... instances) {
        FlatLit.relight(this.computePackedLight(partialTick), instances);
    }
}

