/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.audio;

import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.decoration.steamWhistle.WhistleSoundInstance;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.audio.AudioBehaviour;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlockEntity;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class WhistleAudioBehaviour
extends AudioBehaviour<WhistleBlockEntity> {
    protected WhistleSoundInstance soundInstance;

    public WhistleAudioBehaviour(WhistleBlockEntity be) {
        super(be);
    }

    @Override
    public void tickAudio() {
        boolean powered;
        FluidTankBlockEntity tank = ((WhistleBlockEntity)this.blockEntity).getTank();
        boolean bl = powered = ((WhistleBlockEntity)this.blockEntity).isPowered() && (tank != null && tank.boiler.isActive() && (tank.boiler.passiveHeat || tank.boiler.activeHeat > 0) || ((WhistleBlockEntity)this.blockEntity).isVirtual());
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.fadeOut();
                this.soundInstance = null;
            }
            return;
        }
        class_1937 world = ((WhistleBlockEntity)this.blockEntity).method_10997();
        class_2338 pos = ((WhistleBlockEntity)this.blockEntity).method_11016();
        float f = (float)Math.pow(2.0, (double)(-((WhistleBlockEntity)this.blockEntity).pitch) / 12.0);
        boolean particle = world.method_8510() % 8L == 0L;
        class_310 mc = class_310.method_1551();
        class_243 eyePosition = mc.method_1560().method_33571();
        float maxVolume = (float)class_3532.method_15350((double)((64.0 - eyePosition.method_1022(class_243.method_24953((class_2382)pos))) / 64.0), (double)0.0, (double)1.0);
        WhistleBlock.WhistleSize size = ((WhistleBlockEntity)this.blockEntity).getOctave();
        if (this.soundInstance == null || this.soundInstance.method_4793() || this.soundInstance.getOctave() != size) {
            this.soundInstance = new WhistleSoundInstance(size, pos);
            mc.method_1483().method_4873((class_1113)this.soundInstance);
            AllSoundEvents.WHISTLE_CHIFF.playAt(world, (class_2382)pos, maxVolume * 0.175f, size == WhistleBlock.WhistleSize.SMALL ? f + 0.75f : f, false);
            particle = true;
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(f);
        if (!particle) {
            return;
        }
        class_2350 facing = ((WhistleBlockEntity)this.blockEntity).method_11010().method_28500(WhistleBlock.FACING).orElse(class_2350.field_11035);
        float angle = 180.0f + AngleHelper.horizontalAngle(facing);
        class_243 sizeOffset = VecHelper.rotate(new class_243(0.0, (double)-0.4f, (double)(0.0625f * (float)size.ordinal())), angle, class_2350.class_2351.field_11052);
        class_243 offset = VecHelper.rotate(new class_243(0.0, 1.0, 0.75), angle, class_2350.class_2351.field_11052);
        class_243 v = offset.method_1021((double)0.45f).method_1019(sizeOffset).method_1019(class_243.method_24953((class_2382)pos));
        class_243 m = offset.method_1020(class_243.method_24954((class_2382)facing.method_62675()).method_1021(0.75));
        world.method_8406((class_2394)AllParticleTypes.STEAM_JET, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
    }
}

