/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.catnip.lang.LangBuilder;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.GaugeTooltipBehaviour;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class SpeedGaugeTooltipBehaviour
extends GaugeTooltipBehaviour<SpeedGaugeBlockEntity> {
    public SpeedGaugeTooltipBehaviour(SpeedGaugeBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        CreateLang.translate("gui.speedometer.title", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        SpeedGaugeTooltipBehaviour.getFormattedSpeedText(((SpeedGaugeBlockEntity)this.blockEntity).getSpeed(), ((SpeedGaugeBlockEntity)this.blockEntity).isOverStressed()).forGoggles(tooltip);
        return true;
    }

    public static LangBuilder getFormattedSpeedText(float speed, boolean overstressed) {
        IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of(speed);
        LangBuilder builder = CreateLang.text(TooltipHelper.makeProgressBar(3, speedLevel.ordinal()));
        builder.translate("tooltip.speedRequirement." + Lang.asId(speedLevel.name()), new Object[0]).space().text("(").add(CreateLang.number(Math.abs(speed))).space().translate("generic.unit.rpm", new Object[0]).text(")").space();
        if (overstressed) {
            builder.style(class_124.field_1063).style(class_124.field_1055);
        } else {
            builder.style(speedLevel.getTextColor());
        }
        return builder;
    }
}

