/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.ContraptionHandler;
import com.zurrtum.create.infrastructure.fluids.FlowableFluid;
import java.lang.ref.Reference;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4048;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1297.class})
public abstract class EntityMixin {
    @Shadow
    private class_1937 field_6002;
    @Shadow
    private class_243 field_22467;
    @Shadow
    private float field_6003;
    @Shadow
    @Final
    protected class_5819 field_5974;
    @Shadow
    private class_4048 field_18065;
    @Unique
    private boolean inModFluid;

    @Shadow
    protected abstract void method_5712(class_2338 var1, class_2680 var2);

    @Shadow
    protected abstract float method_5867();

    @Inject(method={"method_5692(Lnet/minecraft/class_6862;D)Z"}, at={@At(value="HEAD")})
    private void clear(class_6862<class_3611> tag, double speed, CallbackInfoReturnable<Boolean> cir) {
        this.inModFluid = false;
    }

    @Inject(method={"method_5692(Lnet/minecraft/class_6862;D)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3610;method_15763(Lnet/minecraft/class_1922;Lnet/minecraft/class_2338;)F")})
    private void checkFluid(class_6862<class_3611> tag, double speed, CallbackInfoReturnable<Boolean> cir, @Local class_3610 state) {
        if (!this.inModFluid) {
            this.inModFluid = state.method_15772() instanceof FlowableFluid;
        }
    }

    @Inject(method={"method_5746()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1937;method_8406(Lnet/minecraft/class_2394;DDDDDD)V")}, cancellable=true)
    private void cancelEffect(CallbackInfo ci) {
        if (this.inModFluid) {
            ci.cancel();
        }
    }

    @Unique
    private Stream<AbstractContraptionEntity> create$getIntersectionContraptionsStream() {
        return (this.field_6002.method_8608() ? ContraptionHandlerClient.loadedContraptions : ContraptionHandler.loadedContraptions).get((class_1936)this.field_6002).values().stream().map(Reference::get).filter(cEntity -> cEntity != null && cEntity.collidingEntities.containsKey((class_1297)this));
    }

    @Unique
    private Set<AbstractContraptionEntity> create$getIntersectingContraptions() {
        Set<AbstractContraptionEntity> contraptions = this.create$getIntersectionContraptionsStream().collect(Collectors.toSet());
        contraptions.addAll(this.field_6002.method_18467(AbstractContraptionEntity.class, ((class_1297)this).method_5829().method_1014(1.0)));
        return contraptions;
    }

    @Unique
    private void create$forCollision(class_243 worldPos, TriConsumer<Contraption, class_2680, class_2338> action) {
        this.create$getIntersectingContraptions().forEach(cEntity -> {
            class_243 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);
            class_2338 blockPos = class_2338.method_49638((class_2374)localPos);
            Contraption contraption = cEntity.getContraption();
            class_3499.class_3501 info = contraption.getBlocks().get(blockPos);
            if (info != null) {
                class_2680 blockstate = info.comp_1342();
                action.accept((Object)contraption, (Object)blockstate, (Object)blockPos);
            }
        });
    }

    @Inject(method={"method_61407(Lnet/minecraft/class_1297$class_5799;Lnet/minecraft/class_243;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2680;method_26215()Z", ordinal=0)})
    private void create$contraptionStepSounds(class_1297.class_5799 moveEffect, class_243 movement, class_2338 landingPos, class_2680 landingState, CallbackInfo ci) {
        class_243 worldPos = this.field_22467.method_1031(0.0, -0.2, 0.0);
        MutableBoolean stepped = new MutableBoolean(false);
        this.create$forCollision(worldPos, (TriConsumer<Contraption, class_2680, class_2338>)((TriConsumer)(contraption, state, pos) -> {
            this.method_5712((class_2338)pos, (class_2680)state);
            stepped.setTrue();
        }));
        if (stepped.booleanValue()) {
            this.field_6003 = this.method_5867();
        }
    }

    @Inject(method={"method_5784(Lnet/minecraft/class_1313;Lnet/minecraft/class_243;)V"}, at={@At(value="TAIL")})
    private void create$onMove(class_1313 type, class_243 movement, CallbackInfo ci) {
        if (!this.field_6002.method_8608()) {
            return;
        }
        class_1297 self = (class_1297)this;
        if (self.method_24828()) {
            return;
        }
        if (self.method_5765()) {
            return;
        }
        class_243 worldPos = this.field_22467.method_1031(0.0, -0.2, 0.0);
        boolean onAtLeastOneContraption = this.create$getIntersectionContraptionsStream().anyMatch(cEntity -> {
            class_243 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);
            class_2338 blockPos = class_2338.method_49638((class_2374)localPos);
            Contraption contraption = cEntity.getContraption();
            class_3499.class_3501 info = contraption.getBlocks().get(blockPos);
            if (info == null) {
                return false;
            }
            cEntity.registerColliding(self);
            return true;
        });
        if (!onAtLeastOneContraption) {
            return;
        }
        self.method_24830(true);
        AllSynchedDatas.CONTRAPTION_GROUNDED.set(self, true);
    }

    @Inject(method={"method_5839()V"}, at={@At(value="TAIL")})
    private void create$onSpawnSprintParticle(CallbackInfo ci) {
        class_1297 self = (class_1297)this;
        class_243 worldPos = this.field_22467.method_1031(0.0, -0.2, 0.0);
        this.create$forCollision(worldPos, (TriConsumer<Contraption, class_2680, class_2338>)((TriConsumer)(contraption, state, pos) -> {
            if (state.method_26217() != class_2464.field_11455) {
                class_243 speed = self.method_18798();
                this.field_6002.method_8406((class_2394)new class_2388(class_2398.field_11217, state), self.method_23317() + ((double)this.field_5974.method_43057() - 0.5) * (double)this.field_18065.comp_2185(), self.method_23318() + 0.1, self.method_23321() + ((double)this.field_5974.method_43057() - 0.5) * (double)this.field_18065.comp_2186(), speed.field_1352 * -4.0, 1.5, speed.field_1350 * -4.0);
            }
        }));
    }
}

