/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.config;

import com.zurrtum.create.client.flywheel.lib.visualization.SimpleBlockEntityVisualizer;
import com.zurrtum.create.client.vanillin.config.Configurator;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BlockEntityVisualizerBuilder<T extends class_2586> {
    private final Configurator configurator;
    private final class_2591<T> type;
    @Nullable
    private SimpleBlockEntityVisualizer.Factory<T> visualFactory;
    @Nullable
    private Predicate<T> skipVanillaRender;

    public BlockEntityVisualizerBuilder(Configurator configurator, class_2591<T> type) {
        this.configurator = configurator;
        this.type = type;
    }

    public BlockEntityVisualizerBuilder<T> factory(SimpleBlockEntityVisualizer.Factory<T> visualFactory) {
        this.visualFactory = visualFactory;
        return this;
    }

    public BlockEntityVisualizerBuilder<T> skipVanillaRender(Predicate<T> skipVanillaRender) {
        this.skipVanillaRender = skipVanillaRender;
        return this;
    }

    public BlockEntityVisualizerBuilder<T> neverSkipVanillaRender() {
        this.skipVanillaRender = blockEntity -> false;
        return this;
    }

    public SimpleBlockEntityVisualizer<T> apply(boolean enabledByDefault) {
        Objects.requireNonNull(this.visualFactory, "Visual factory cannot be null!");
        if (this.skipVanillaRender == null) {
            this.skipVanillaRender = blockEntity -> true;
        }
        SimpleBlockEntityVisualizer<T> visualizer = new SimpleBlockEntityVisualizer<T>(this.visualFactory, this.skipVanillaRender);
        this.configurator.register(this.type, visualizer, enabledByDefault);
        return visualizer;
    }
}

