/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.component.ShadowComponent;
import com.zurrtum.create.client.vanillin.item.ItemModels;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4590;
import net.minecraft.class_8113;

@Environment(value=EnvType.CLIENT)
public class ItemDisplayVisual
extends AbstractEntityVisual<class_8113.class_8122>
implements SimpleDynamicVisual {
    private final TransformedInstance instance;
    private class_1799 currentStack;
    private final ShadowComponent shadowComponent;

    public ItemDisplayVisual(VisualizationContext ctx, class_8113.class_8122 entity, float partialTick) {
        super(ctx, entity, partialTick);
        class_8113.class_8122.class_8226 itemRenderState = entity.method_49782();
        if (itemRenderState == null) {
            this.currentStack = class_1799.field_8037;
            this.instance = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block(class_2246.field_10124.method_9564())).createInstance();
        } else {
            this.currentStack = itemRenderState.comp_1322().method_7972();
            this.instance = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.currentStack, itemRenderState.comp_1323())).createInstance();
        }
        this.shadowComponent = new ShadowComponent(ctx, (class_1297)entity);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        class_8113.class_8229 renderState = ((class_8113.class_8122)this.entity).method_49777();
        if (renderState == null) {
            this.instance.handle().setVisible(false);
            return;
        }
        class_8113.class_8122.class_8226 object = ((class_8113.class_8122)this.entity).method_49782();
        if (object == null) {
            this.instance.handle().setVisible(false);
            return;
        }
        this.instance.handle().setVisible(true);
        class_1799 itemStack = object.comp_1322();
        if (!class_1799.method_7973((class_1799)itemStack, (class_1799)this.currentStack)) {
            this.currentStack = itemStack.method_7972();
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.currentStack, object.comp_1323())).stealInstance(this.instance);
        }
        float f = ((class_8113.class_8122)this.entity).method_48844(ctx.partialTick());
        this.shadowComponent.radius(renderState.comp_1331().method_48886(f));
        this.shadowComponent.strength(renderState.comp_1332().method_48886(f));
        this.shadowComponent.beginFrame(ctx);
        int i = renderState.comp_1330();
        int j = i != -1 ? i : this.computePackedLight(ctx.partialTick());
        class_4590 transformation = (class_4590)renderState.comp_1328().method_48888(f);
        class_243 pos = ((class_8113.class_8122)this.entity).method_73189();
        class_2382 renderOrigin = this.renderOrigin();
        this.instance.setIdentityTransform().translate((float)(pos.field_1352 - (double)renderOrigin.method_10263()), (float)(pos.field_1351 - (double)renderOrigin.method_10264()), (float)(pos.field_1350 - (double)renderOrigin.method_10260()));
        float partialTick = ctx.partialTick();
        class_4184 camera = ctx.camera();
        switch (renderState.comp_1329()) {
            case field_42406: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * ItemDisplayVisual.entityYRot(this.entity, partialTick), (float)Math.PI / 180 * ItemDisplayVisual.entityXRot(this.entity, partialTick), 0.0f);
                break;
            }
            case field_42408: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * ItemDisplayVisual.entityYRot(this.entity, partialTick), (float)Math.PI / 180 * ItemDisplayVisual.cameraXRot(camera), 0.0f);
                break;
            }
            case field_42407: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * ItemDisplayVisual.cameraYrot(camera), (float)Math.PI / 180 * ItemDisplayVisual.entityXRot(this.entity, partialTick), 0.0f);
                break;
            }
            case field_42409: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * ItemDisplayVisual.cameraYrot(camera), (float)Math.PI / 180 * ItemDisplayVisual.cameraXRot(camera), 0.0f);
            }
        }
        this.instance.mul(transformation.method_22936()).rotateY((float)Math.PI).light(j).setChanged();
    }

    private static float cameraYrot(class_4184 camera) {
        return camera.method_19330() - 180.0f;
    }

    private static float cameraXRot(class_4184 camera) {
        return -camera.method_19329();
    }

    private static float entityYRot(class_1297 entity, float partialTick) {
        return class_3532.method_17821((float)partialTick, (float)entity.field_5982, (float)entity.method_36454());
    }

    private static float entityXRot(class_1297 entity, float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)entity.field_6004, (float)entity.method_36455());
    }

    @Override
    protected void _delete() {
        this.instance.delete();
    }

    public static boolean shouldVisualize(class_8113.class_8122 itemDisplay) {
        class_8113.class_8122.class_8226 state = itemDisplay.method_49782();
        return state != null && ItemModels.isSupported(state.comp_1322(), state.comp_1323());
    }
}

