/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.glue;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.api.schematic.requirement.SpecialEntityItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.bearing.BearingBlock;
import com.zurrtum.create.content.contraptions.chassis.AbstractChassisBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.packet.s2c.SuperGlueSpawnPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4050;

public class SuperGlueEntity
extends class_1297
implements SpecialEntityItemRequirement {
    public static class_238 span(class_2338 startPos, class_2338 endPos) {
        return new class_238(class_243.method_24954((class_2382)startPos), class_243.method_24954((class_2382)endPos)).method_1012(1.0, 1.0, 1.0);
    }

    public static boolean isGlued(class_1936 level, class_2338 blockPos, class_2350 direction, Set<SuperGlueEntity> cached) {
        class_2338 targetPos = blockPos.method_10093(direction);
        if (cached != null) {
            for (SuperGlueEntity glueEntity : cached) {
                if (!glueEntity.contains(blockPos) || !glueEntity.contains(targetPos)) continue;
                return true;
            }
        }
        for (SuperGlueEntity glueEntity : level.method_18467(SuperGlueEntity.class, SuperGlueEntity.span(blockPos, targetPos).method_1014(16.0))) {
            if (!glueEntity.contains(blockPos) || !glueEntity.contains(targetPos)) continue;
            if (cached != null) {
                cached.add(glueEntity);
            }
            return true;
        }
        return false;
    }

    public static List<SuperGlueEntity> collectCropped(class_1937 level, class_238 bb) {
        ArrayList<SuperGlueEntity> glue = new ArrayList<SuperGlueEntity>();
        for (SuperGlueEntity glueEntity : level.method_18467(SuperGlueEntity.class, bb)) {
            class_238 glueBox = glueEntity.method_5829();
            class_238 intersect = bb.method_999(glueBox);
            if (intersect.method_17939() * intersect.method_17940() * intersect.method_17941() == 0.0 || class_3532.method_20390((double)intersect.method_995(), (double)1.0)) continue;
            glue.add(new SuperGlueEntity(level, intersect));
        }
        return glue;
    }

    public SuperGlueEntity(class_1299<? extends SuperGlueEntity> type, class_1937 world) {
        super(type, world);
    }

    public SuperGlueEntity(class_1937 world, class_238 boundingBox) {
        this(AllEntityTypes.SUPER_GLUE, world);
        this.method_5857(boundingBox);
        this.resetPositionToBB();
    }

    public void resetPositionToBB() {
        class_238 bb = this.method_5829();
        this.method_23327(bb.method_1005().field_1352, bb.field_1322, bb.method_1005().field_1350);
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public static boolean isValidFace(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2680 state = world.method_8320(pos);
        if (BlockMovementChecks.isBlockAttachedTowards(state, world, pos, direction)) {
            return true;
        }
        if (!BlockMovementChecks.isMovementNecessary(state, world, pos)) {
            return false;
        }
        return !BlockMovementChecks.isNotSupportive(state, direction);
    }

    public static boolean isSideSticky(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2680 state = world.method_8320(pos);
        if (state.method_27852((class_2248)AllBlocks.STICKY_MECHANICAL_PISTON)) {
            return state.method_11654(DirectionalKineticBlock.FACING) == direction;
        }
        if (state.method_27852((class_2248)AllBlocks.STICKER)) {
            return state.method_11654((class_2769)class_2318.field_10927) == direction;
        }
        if (state.method_26204() == class_2246.field_10030) {
            return true;
        }
        if (state.method_26204() == class_2246.field_21211) {
            return true;
        }
        if (state.method_27852((class_2248)AllBlocks.CART_ASSEMBLER)) {
            return class_2350.field_11036 == direction;
        }
        if (state.method_27852((class_2248)AllBlocks.GANTRY_CARRIAGE)) {
            return state.method_11654(DirectionalKineticBlock.FACING) == direction;
        }
        if (state.method_26204() instanceof BearingBlock) {
            return state.method_11654(DirectionalKineticBlock.FACING) == direction;
        }
        if (state.method_26204() instanceof AbstractChassisBlock) {
            class_2746 glueableSide = ((AbstractChassisBlock)state.method_26204()).getGlueableSide(state, direction);
            if (glueableSide == null) {
                return false;
            }
            return (Boolean)state.method_11654((class_2769)glueableSide);
        }
        return false;
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }

    public void method_5773() {
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        if (this.method_5829().method_17939() == 0.0) {
            this.method_31472();
        }
    }

    public void method_5814(double x, double y, double z) {
        class_238 bb = this.method_5829();
        this.method_23327(x, y, z);
        class_243 center = bb.method_1005();
        this.method_5857(bb.method_989(-center.field_1352, -bb.field_1322, -center.field_1350).method_989(x, y, z));
    }

    public void method_5784(class_1313 typeIn, class_243 pos) {
        if (!this.method_73183().method_8608() && this.method_5805() && pos.method_1027() > 0.0) {
            this.method_31472();
        }
    }

    public void method_5762(double x, double y, double z) {
        if (!this.method_73183().method_8608() && this.method_5805() && x * x + y * y + z * z > 0.0) {
            this.method_31472();
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        return super.method_18377(pose).method_55685(0.0f);
    }

    public void playPlaceSound() {
        AllSoundEvents.SLIME_ADDED.playFrom(this, 0.5f, 0.75f);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        return class_1269.field_5811;
    }

    public void method_5652(class_11372 view) {
        class_238 box = this.method_5829().method_997(this.method_73189().method_1021(-1.0));
        view.method_71468("Box", CreateCodecs.BOX_CODEC, (Object)box);
    }

    public void method_5749(class_11368 view) {
        class_238 box = ((class_238)view.method_71426("Box", CreateCodecs.BOX_CODEC).orElseThrow()).method_997(this.method_73189());
        this.method_5857(box);
    }

    public static void writeBoundingBox(class_2487 compound, class_238 bb) {
        compound.method_10566("From", (class_2520)VecHelper.writeNBT(new class_243(bb.field_1323, bb.field_1322, bb.field_1321)));
        compound.method_10566("To", (class_2520)VecHelper.writeNBT(new class_243(bb.field_1320, bb.field_1325, bb.field_1324)));
    }

    public static class_238 readBoundingBox(class_2487 compound) {
        class_243 from = VecHelper.readNBT(compound.method_68569("From"));
        class_243 to = VecHelper.readNBT(compound.method_68569("To"));
        return new class_238(from, to);
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new SuperGlueSpawnPacket(this, entityTrackerEntry);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.method_5857(((SuperGlueSpawnPacket)packet).getBox());
    }

    protected boolean method_5638() {
        return false;
    }

    public float method_5832(class_2470 transformRotation) {
        class_238 bb = this.method_5829().method_997(this.method_73189().method_1021(-1.0));
        if (transformRotation == class_2470.field_11463 || transformRotation == class_2470.field_11465) {
            this.method_5857(new class_238(bb.field_1321, bb.field_1322, bb.field_1323, bb.field_1324, bb.field_1325, bb.field_1320).method_997(this.method_73189()));
        }
        return super.method_5832(transformRotation);
    }

    public void method_5800(class_3218 world, class_1538 lightningBolt) {
    }

    public void method_18382() {
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return new ItemRequirement(ItemRequirement.ItemUseType.DAMAGE, AllItems.SUPER_GLUE);
    }

    public boolean method_5696() {
        return true;
    }

    public boolean contains(class_2338 pos) {
        return this.method_5829().method_1006(class_243.method_24953((class_2382)pos));
    }

    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    public void spawnParticles() {
        class_238 bb = this.method_5829();
        class_243 origin = new class_243(bb.field_1323, bb.field_1322, bb.field_1321);
        class_243 extents = new class_243(bb.method_17939(), bb.method_17940(), bb.method_17941());
        class_2350.class_2351[] class_2351Array = this.method_73183();
        if (!(class_2351Array instanceof class_3218)) {
            return;
        }
        class_3218 slevel = (class_3218)class_2351Array;
        block0: for (class_2350.class_2351 axis : Iterate.axes) {
            class_2350.class_2352 positive = class_2350.class_2352.field_11056;
            double max = axis.method_10172(extents.field_1352, extents.field_1351, extents.field_1350);
            class_243 normal = class_243.method_24954((class_2382)class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)positive).method_62675());
            for (class_2350.class_2351 axis2 : Iterate.axes) {
                if (axis2 == axis) continue;
                double max2 = axis2.method_10172(extents.field_1352, extents.field_1351, extents.field_1350);
                class_243 normal2 = class_243.method_24954((class_2382)class_2350.method_10169((class_2350.class_2351)axis2, (class_2350.class_2352)positive).method_62675());
                for (class_2350.class_2351 axis3 : Iterate.axes) {
                    if (axis3 == axis2 || axis3 == axis) continue;
                    double max3 = axis3.method_10172(extents.field_1352, extents.field_1351, extents.field_1350);
                    class_243 normal3 = class_243.method_24954((class_2382)class_2350.method_10169((class_2350.class_2351)axis3, (class_2350.class_2352)positive).method_62675());
                    int i = 0;
                    while ((double)i <= max * 2.0) {
                        for (int o1 : Iterate.zeroAndOne) {
                            for (int o2 : Iterate.zeroAndOne) {
                                class_243 v = origin.method_1019(normal.method_1021((double)((float)i / 2.0f))).method_1019(normal2.method_1021(max2 * (double)o1)).method_1019(normal3.method_1021(max3 * (double)o2));
                                slevel.method_65096((class_2394)class_2398.field_11246, v.field_1352, v.field_1351, v.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                        ++i;
                    }
                    continue block0;
                }
                continue block0;
            }
        }
    }
}

