/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.schematics.cannon;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.belt.item.BeltConnectorItem;
import com.zurrtum.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_8942;

public abstract class LaunchedItem {
    public int totalTicks;
    public int ticksRemaining;
    public class_2338 target;
    public class_1799 stack;

    private LaunchedItem(class_2338 start, class_2338 target, class_1799 stack) {
        this(target, stack, LaunchedItem.ticksForDistance(start, target), LaunchedItem.ticksForDistance(start, target));
    }

    private static int ticksForDistance(class_2338 start, class_2338 target) {
        return (int)Math.max(10.0, Math.sqrt(Math.sqrt(target.method_10262((class_2382)start))) * 4.0);
    }

    LaunchedItem() {
    }

    private LaunchedItem(class_2338 target, class_1799 stack, int ticksLeft, int total) {
        this.target = target;
        this.stack = stack;
        this.totalTicks = total;
        this.ticksRemaining = ticksLeft;
    }

    public boolean update(class_1937 world) {
        if (this.ticksRemaining > 0) {
            --this.ticksRemaining;
            return false;
        }
        if (world.method_8608()) {
            return false;
        }
        this.place(world);
        return true;
    }

    public void write(class_11372 view) {
        view.method_71465("TotalTicks", this.totalTicks);
        view.method_71465("TicksLeft", this.ticksRemaining);
        if (!this.stack.method_7960()) {
            view.method_71468("Stack", class_1799.field_24671, (Object)this.stack);
        }
        view.method_71468("Target", class_2338.field_25064, (Object)this.target);
    }

    public static LaunchedItem from(class_11368 view, class_7871<class_2248> holderGetter) {
        LaunchedItem item = ForBelt.from(view, holderGetter);
        if (item != null) {
            return item;
        }
        item = ForBlockState.from(view, holderGetter);
        if (item != null) {
            return item;
        }
        item = new ForEntity();
        item.read(view, holderGetter);
        return item;
    }

    abstract void place(class_1937 var1);

    void read(class_11368 view, class_7871<class_2248> holderGetter) {
        this.target = view.method_71426("Target", class_2338.field_25064).orElse(class_2338.field_10980);
        this.ticksRemaining = view.method_71424("TicksLeft", 0);
        this.totalTicks = view.method_71424("TotalTicks", 0);
        this.stack = view.method_71426("Stack", class_1799.field_24671).orElse(class_1799.field_8037);
    }

    public static class ForBelt
    extends ForBlockState {
        public int length;
        public BeltBlockEntity.CasingType[] casings;

        public ForBelt() {
        }

        @Override
        public void write(class_11372 view) {
            super.write(view);
            view.method_71468("Length", (Codec)Codec.INT, (Object)this.length);
            view.method_71473("Casing", Arrays.stream(this.casings).mapToInt(Enum::ordinal).toArray());
        }

        public static LaunchedItem from(class_11368 view, class_7871<class_2248> holderGetter) {
            return view.method_71426("Length", (Codec)Codec.INT).map(length -> {
                ForBelt result = new ForBelt();
                result.read(view, holderGetter, (int)length);
                return result;
            }).orElse(null);
        }

        @Override
        void read(class_11368 view, class_7871<class_2248> holderGetter) {
            this.read(view, holderGetter, view.method_71426("Length", (Codec)Codec.INT).orElse(0));
        }

        private void read(class_11368 view, class_7871<class_2248> holderGetter, int length) {
            this.length = length;
            int[] intArray = view.method_71442("Casing").orElseGet(() -> new int[0]);
            this.casings = new BeltBlockEntity.CasingType[length];
            for (int i = 0; i < this.casings.length; ++i) {
                this.casings[i] = i >= intArray.length ? BeltBlockEntity.CasingType.NONE : BeltBlockEntity.CasingType.values()[class_3532.method_15340((int)intArray[i], (int)0, (int)(BeltBlockEntity.CasingType.values().length - 1))];
            }
            super.read(view, holderGetter);
        }

        public ForBelt(class_2338 start, class_2338 target, class_1799 stack, class_2680 state, BeltBlockEntity.CasingType[] casings) {
            super(start, target, stack, state, null);
            this.casings = casings;
            this.length = casings.length;
        }

        @Override
        void place(class_1937 world) {
            boolean isStart = this.state.method_11654(BeltBlock.PART) == BeltPart.START;
            class_2338 offset = BeltBlock.nextSegmentPosition(this.state, class_2338.field_10980, isStart);
            int i = this.length - 1;
            class_2350.class_2351 axis = this.state.method_11654(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS ? class_2350.class_2351.field_11052 : ((class_2350)this.state.method_11654((class_2769)BeltBlock.HORIZONTAL_FACING)).method_10170().method_10166();
            world.method_8501(this.target, (class_2680)AllBlocks.SHAFT.method_9564().method_11657((class_2769)AbstractSimpleShaftBlock.AXIS, (Comparable)axis));
            BeltConnectorItem.createBelts(world, this.target, this.target.method_10069(offset.method_10263() * i, offset.method_10264() * i, offset.method_10260() * i));
            for (int segment = 0; segment < this.length; ++segment) {
                class_2338 casingTarget;
                class_2586 class_25862;
                if (this.casings[segment] == BeltBlockEntity.CasingType.NONE || !((class_25862 = world.method_8321(casingTarget = this.target.method_10069(offset.method_10263() * segment, offset.method_10264() * segment, offset.method_10260() * segment))) instanceof BeltBlockEntity)) continue;
                BeltBlockEntity bbe = (BeltBlockEntity)class_25862;
                bbe.setCasingType(this.casings[segment]);
            }
        }
    }

    public static class ForBlockState
    extends LaunchedItem {
        public class_2680 state;
        public class_2487 data;

        ForBlockState() {
        }

        public ForBlockState(class_2338 start, class_2338 target, class_1799 stack, class_2680 state, class_2487 data) {
            super(start, target, stack);
            this.state = state;
            this.data = data;
        }

        @Override
        public void write(class_11372 view) {
            super.write(view);
            view.method_71468("BlockState", class_2680.field_24734, (Object)this.state);
            if (this.data != null) {
                this.data.method_10551("x");
                this.data.method_10551("y");
                this.data.method_10551("z");
                this.data.method_10551("id");
                view.method_71468("Data", class_2487.field_25128, (Object)this.data);
            }
        }

        public static LaunchedItem from(class_11368 view, class_7871<class_2248> holderGetter) {
            return view.method_71426("BlockState", class_2680.field_24734).map(state -> {
                ForBlockState result = new ForBlockState();
                result.read(view, holderGetter, (class_2680)state);
                return result;
            }).orElse(null);
        }

        @Override
        void read(class_11368 view, class_7871<class_2248> holderGetter) {
            this.read(view, holderGetter, view.method_71426("BlockState", class_2680.field_24734).orElseGet(() -> ((class_2248)class_2246.field_10124).method_9564()));
        }

        private void read(class_11368 view, class_7871<class_2248> holderGetter, class_2680 state) {
            super.read(view, holderGetter);
            this.state = state;
            view.method_71426("Data", class_2487.field_25128).ifPresent(nbt -> {
                this.data = nbt;
            });
        }

        @Override
        void place(class_1937 world) {
            BlockHelper.placeSchematicBlock(world, this.state, this.target, this.stack, this.data);
        }
    }

    public static class ForEntity
    extends LaunchedItem {
        public class_1297 entity;
        private class_2487 deferredTag;

        ForEntity() {
        }

        public ForEntity(class_2338 start, class_2338 target, class_1799 stack, class_1297 entity) {
            super(start, target, stack);
            this.entity = entity;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean update(class_1937 world) {
            if (this.deferredTag == null) return super.update(world);
            if (this.entity != null) return super.update(world);
            try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "LaunchedItem.ForEntity", Create.LOGGER);){
                class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)world.method_30349(), (class_2487)this.deferredTag);
                Optional loadEntityUnchecked = class_1299.method_5892((class_11368)view, (class_1937)world, (class_3730)class_3730.field_52444);
                if (loadEntityUnchecked.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                this.entity = (class_1297)loadEntityUnchecked.get();
            }
            catch (Exception var3) {
                return true;
            }
            this.deferredTag = null;
            return super.update(world);
        }

        @Override
        public void write(class_11372 view) {
            super.write(view);
            if (this.entity != null) {
                class_11372 data = view.method_71461("Entity");
                class_1299 entityType = this.entity.method_5864();
                class_2960 id = class_1299.method_5890((class_1299)entityType);
                if (id != null && entityType.method_5893()) {
                    data.method_71469("id", id.toString());
                }
                this.entity.method_5647(data);
            }
        }

        @Override
        void read(class_11368 view, class_7871<class_2248> holderGetter) {
            super.read(view, holderGetter);
            view.method_71426("Entity", class_2487.field_25128).ifPresent(nbt -> {
                this.deferredTag = nbt;
            });
        }

        @Override
        void place(class_1937 world) {
            if (this.entity != null) {
                world.method_8649(this.entity);
            }
        }
    }
}

