/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2428;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499;
import net.minecraft.class_3709;
import org.jetbrains.annotations.Nullable;

public class ArrivalSoundQueue {
    public int offset;
    int min;
    int max;
    Multimap<Integer, class_2338> sources = Multimaps.newMultimap(new HashMap(), ArrayList::new);

    public ArrivalSoundQueue() {
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
    }

    @Nullable
    public Integer firstTick() {
        return this.sources.isEmpty() ? null : Integer.valueOf(this.min + this.offset);
    }

    @Nullable
    public Integer lastTick() {
        return this.sources.isEmpty() ? null : Integer.valueOf(this.max + this.offset);
    }

    public boolean tick(CarriageContraptionEntity entity, int tick, boolean backwards) {
        if (!this.sources.containsKey((Object)(tick -= this.offset))) {
            return backwards ? tick > this.min : tick < this.max;
        }
        Contraption contraption = entity.getContraption();
        for (class_2338 blockPos : this.sources.get((Object)tick)) {
            ArrivalSoundQueue.play(entity, contraption.getBlocks().get(blockPos));
        }
        return backwards ? tick > this.min : tick < this.max;
    }

    public Pair<Boolean, Integer> getFirstWhistle(CarriageContraptionEntity entity) {
        Integer firstTick = this.firstTick();
        Integer lastTick = this.lastTick();
        if (firstTick == null || lastTick == null || firstTick > lastTick) {
            return null;
        }
        for (int i = firstTick.intValue(); i <= lastTick; ++i) {
            if (!this.sources.containsKey((Object)(i - this.offset))) continue;
            Contraption contraption = entity.getContraption();
            for (class_2338 blockPos : this.sources.get((Object)(i - this.offset))) {
                class_2680 state;
                class_3499.class_3501 info = contraption.getBlocks().get(blockPos);
                if (info == null || !((state = info.comp_1342()).method_26204() instanceof WhistleBlock) || info.comp_1343() == null) continue;
                int pitch = info.comp_1343().method_68083("Pitch", 0);
                WhistleBlock.WhistleSize size = (WhistleBlock.WhistleSize)((Object)state.method_11654(WhistleBlock.SIZE));
                return Pair.of(size == WhistleBlock.WhistleSize.LARGE, (size == WhistleBlock.WhistleSize.SMALL ? 12 : 0) - pitch);
            }
        }
        return null;
    }

    public void write(class_11372 view) {
        class_11372 tag = view.method_71461("SoundQueue");
        tag.method_71465("Offset", this.offset);
        class_11372.class_11374 list = tag.method_71476("Sources");
        for (Map.Entry entry : this.sources.entries()) {
            class_11372 item = list.method_71480();
            item.method_71465("Tick", ((Integer)entry.getKey()).intValue());
            item.method_71468("Pos", class_2338.field_25064, (Object)((class_2338)entry.getValue()));
        }
    }

    public void read(class_11368 view) {
        class_11368 tag = view.method_71434("SoundQueue");
        this.offset = tag.method_71424("Offset", 0);
        class_11368.class_11370 list = tag.method_71438("Sources");
        list.forEach(item -> this.add(item.method_71424("Tick", 0), item.method_71426("Pos", class_2338.field_25064).orElse(class_2338.field_10980)));
    }

    public void add(int offset, class_2338 localPos) {
        this.sources.put((Object)offset, (Object)localPos);
        this.min = Math.min(offset, this.min);
        this.max = Math.max(offset, this.max);
    }

    public static boolean isPlayable(class_2680 state) {
        if (state.method_26204() instanceof class_3709) {
            return true;
        }
        if (state.method_26204() instanceof class_2428) {
            return true;
        }
        return state.method_26204() instanceof WhistleBlock;
    }

    public static void play(CarriageContraptionEntity entity, class_3499.class_3501 info) {
        class_2248 class_22482;
        if (info == null) {
            return;
        }
        class_2680 state = info.comp_1342();
        if (state.method_26204() instanceof class_3709) {
            if (state.method_27852((class_2248)AllBlocks.HAUNTED_BELL)) {
                ArrivalSoundQueue.playSimple(entity, AllSoundEvents.HAUNTED_BELL_USE.getMainEvent(), 1.0f, 1.0f);
            } else {
                ArrivalSoundQueue.playSimple(entity, class_3417.field_17265, 1.0f, 1.0f);
            }
        }
        if ((class_22482 = state.method_26204()) instanceof class_2428) {
            class_2428 nb = (class_2428)class_22482;
            float f = (float)Math.pow(2.0, (double)((Integer)state.method_11654((class_2769)class_2428.field_11324) - 12) / 12.0);
            ArrivalSoundQueue.playSimple(entity, (class_3414)((class_2766)state.method_11654((class_2769)class_2428.field_11325)).method_11886().comp_349(), 1.0f, f);
        }
        if (state.method_26204() instanceof WhistleBlock && info.comp_1343() != null) {
            int pitch = info.comp_1343().method_68083("Pitch", 0);
            WhistleBlock.WhistleSize size = (WhistleBlock.WhistleSize)((Object)state.method_11654(WhistleBlock.SIZE));
            float f = (float)Math.pow(2.0, (double)((size == WhistleBlock.WhistleSize.SMALL ? 12 : 0) - pitch) / 12.0);
            ArrivalSoundQueue.playSimple(entity, (size == WhistleBlock.WhistleSize.LARGE ? AllSoundEvents.WHISTLE_TRAIN_LOW : AllSoundEvents.WHISTLE_TRAIN).getMainEvent(), 1.0f, f);
        }
    }

    private static void playSimple(CarriageContraptionEntity entity, class_3414 event, float volume, float pitch) {
        entity.method_73183().method_43129(null, (class_1297)entity, event, class_3419.field_15254, 5.0f * volume, pitch);
    }
}

