/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.filter;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.ListFilterItem;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.infrastructure.component.AttributeFilterWhitelistMode;
import com.zurrtum.create.infrastructure.component.ItemAttributeEntry;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_9334;

public class FilterItemStack {
    public static final Codec<FilterItemStack> CODEC = class_1799.field_49266.xmap(FilterItemStack::of, FilterItemStack::item);
    private final class_1799 filterItemStack;
    private boolean fluidExtracted;
    private FluidStack filterFluidStack;

    public static FilterItemStack of(class_1799 filter) {
        class_1792 class_17922;
        if (!filter.method_57380().method_57848() && (class_17922 = filter.method_7909()) instanceof FilterItem) {
            FilterItem item = (FilterItem)class_17922;
            FilterItemStack.trimFilterComponents(filter);
            return item.makeStackWrapper(filter);
        }
        return new FilterItemStack(filter);
    }

    public static FilterItemStack empty() {
        return FilterItemStack.of(class_1799.field_8037);
    }

    private static void trimFilterComponents(class_1799 filter) {
        filter.method_57381(class_9334.field_49633);
        filter.method_57381(class_9334.field_49636);
    }

    public boolean isEmpty() {
        return this.filterItemStack.method_7960();
    }

    public class_1799 item() {
        return this.filterItemStack;
    }

    public FluidStack fluid(class_1937 level) {
        this.resolveFluid(level);
        return this.filterFluidStack;
    }

    public boolean isFilterItem() {
        return this.filterItemStack.method_7909() instanceof FilterItem;
    }

    public boolean test(class_1937 world, class_1799 stack) {
        return this.test(world, stack, false);
    }

    public boolean test(class_1937 world, FluidStack stack) {
        return this.test(world, stack, true);
    }

    public boolean test(class_1937 world, class_1799 stack, boolean matchNBT) {
        if (this.isEmpty()) {
            return true;
        }
        return FilterItem.testDirect(this.filterItemStack, stack, matchNBT);
    }

    public boolean test(class_1937 world, FluidStack stack, boolean matchNBT) {
        if (this.isEmpty()) {
            return true;
        }
        if (stack.isEmpty()) {
            return false;
        }
        this.resolveFluid(world);
        if (this.filterFluidStack.isEmpty()) {
            return false;
        }
        if (!matchNBT) {
            return this.filterFluidStack.getFluid().method_15780(stack.getFluid());
        }
        return FluidStack.areFluidsAndComponentsEqualIgnoreCapacity(this.filterFluidStack, stack);
    }

    private void resolveFluid(class_1937 world) {
        if (!this.fluidExtracted) {
            this.fluidExtracted = true;
            if (GenericItemEmptying.canItemBeEmptied(world, this.filterItemStack)) {
                this.filterFluidStack = GenericItemEmptying.emptyItem(world, this.filterItemStack, true).getFirst();
            }
        }
    }

    protected FilterItemStack(class_1799 filter) {
        this.filterItemStack = filter;
        this.filterFluidStack = FluidStack.EMPTY;
        this.fluidExtracted = false;
    }

    public static class PackageFilterItemStack
    extends FilterItemStack {
        public String filterString;

        public PackageFilterItemStack(class_1799 filter) {
            super(filter);
            this.filterString = PackageItem.getAddress(filter);
        }

        @Override
        public boolean test(class_1937 world, class_1799 stack, boolean matchNBT) {
            return this.filterString.isBlank() && super.test(world, stack, matchNBT) || PackageItem.isPackage(stack) && PackageItem.matchAddress(stack, this.filterString);
        }

        @Override
        public boolean test(class_1937 world, FluidStack stack, boolean matchNBT) {
            return false;
        }
    }

    public static class AttributeFilterItemStack
    extends FilterItemStack {
        public AttributeFilterWhitelistMode whitelistMode;
        public List<Pair<ItemAttribute, Boolean>> attributeTests;

        public AttributeFilterItemStack(class_1799 filter) {
            super(filter);
            boolean defaults = !filter.method_57826(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES);
            this.attributeTests = new ArrayList<Pair<ItemAttribute, Boolean>>();
            this.whitelistMode = (AttributeFilterWhitelistMode)((Object)filter.method_58695(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, (Object)AttributeFilterWhitelistMode.WHITELIST_DISJ));
            List attributes = defaults ? new ArrayList() : (List)filter.method_58694(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES);
            for (ItemAttributeEntry attributeEntry : attributes) {
                ItemAttribute attribute = attributeEntry.attribute();
                if (attribute == null) continue;
                this.attributeTests.add(Pair.of(attribute, attributeEntry.inverted()));
            }
        }

        @Override
        public boolean test(class_1937 world, FluidStack stack, boolean matchNBT) {
            return false;
        }

        @Override
        public boolean test(class_1937 world, class_1799 stack, boolean matchNBT) {
            if (this.attributeTests.isEmpty()) {
                return super.test(world, stack, matchNBT);
            }
            block13: for (Pair<ItemAttribute, Boolean> test : this.attributeTests) {
                boolean matches;
                ItemAttribute attribute = test.getFirst();
                boolean inverted = test.getSecond();
                boolean bl = matches = attribute.appliesTo(stack, world) != inverted;
                if (matches) {
                    switch (this.whitelistMode) {
                        case BLACKLIST: {
                            return false;
                        }
                        case WHITELIST_CONJ: {
                            continue block13;
                        }
                        case WHITELIST_DISJ: {
                            return true;
                        }
                    }
                    continue;
                }
                switch (this.whitelistMode) {
                    case BLACKLIST: 
                    case WHITELIST_DISJ: {
                        continue block13;
                    }
                    case WHITELIST_CONJ: {
                        return false;
                    }
                }
            }
            return switch (this.whitelistMode) {
                default -> throw new MatchException(null, null);
                case AttributeFilterWhitelistMode.BLACKLIST, AttributeFilterWhitelistMode.WHITELIST_CONJ -> true;
                case AttributeFilterWhitelistMode.WHITELIST_DISJ -> false;
            };
        }
    }

    public static class ListFilterItemStack
    extends FilterItemStack {
        public List<FilterItemStack> containedItems;
        public boolean shouldRespectNBT;
        public boolean isBlacklist;

        public ListFilterItemStack(class_1799 filter) {
            super(filter);
            boolean hasFilterItems = filter.method_57826(AllDataComponents.FILTER_ITEMS);
            this.containedItems = new ArrayList<FilterItemStack>();
            Iterator iterator = ((ListFilterItem)filter.method_7909()).getFilterItemHandler(filter).iterator();
            while (iterator.hasNext()) {
                class_1799 stack = (class_1799)iterator.next();
                if (stack.method_7960()) continue;
                this.containedItems.add(FilterItemStack.of(stack));
            }
            this.shouldRespectNBT = hasFilterItems && (Boolean)filter.method_58695(AllDataComponents.FILTER_ITEMS_RESPECT_NBT, (Object)false) != false;
            this.isBlacklist = hasFilterItems && (Boolean)filter.method_58695(AllDataComponents.FILTER_ITEMS_BLACKLIST, (Object)false) != false;
        }

        @Override
        public boolean test(class_1937 world, class_1799 stack, boolean matchNBT) {
            for (FilterItemStack filterItemStack : this.containedItems) {
                if (!filterItemStack.test(world, stack, this.shouldRespectNBT)) continue;
                return !this.isBlacklist;
            }
            return this.isBlacklist;
        }

        @Override
        public boolean test(class_1937 world, FluidStack stack, boolean matchNBT) {
            for (FilterItemStack filterItemStack : this.containedItems) {
                if (!filterItemStack.test(world, stack, this.shouldRespectNBT)) continue;
                return !this.isBlacklist;
            }
            return this.isBlacklist;
        }
    }
}

