/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packager;

import com.google.common.base.Predicate;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.AllUnpackingHandlers;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.packager.unpacking.UnpackingHandler;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.crate.BottomlessItemHandler;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packager.PackagerBlock;
import com.zurrtum.create.content.logistics.packager.PackagerItemHandler;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlock;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.s2c.WiFiEffectPacket;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_8242;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class PackagerBlockEntity
extends SmartBlockEntity {
    private static final Codec<List<BigItemStack>> EXITING_CODEC = BigItemStack.CODEC.listOf();
    public boolean redstonePowered;
    public int buttonCooldown;
    public String signBasedAddress;
    public InvManipulationBehaviour targetInventory;
    public class_1799 heldBox;
    public class_1799 previouslyUnwrapped;
    public List<BigItemStack> queuedExitingPackages;
    public final PackagerItemHandler inventory;
    public static final int CYCLE = 20;
    public int animationTicks;
    public boolean animationInward;
    public Boolean hasCustomComputerAddress;
    public String customComputerAddress;
    private InventorySummary availableItems;
    private VersionedInventoryTrackerBehaviour invVersionTracker;

    public PackagerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.redstonePowered = (Boolean)state.method_61767((class_2769)PackagerBlock.POWERED, (Comparable)Boolean.valueOf(false));
        this.heldBox = class_1799.field_8037;
        this.previouslyUnwrapped = class_1799.field_8037;
        this.inventory = new PackagerItemHandler(this);
        this.animationTicks = 0;
        this.animationInward = true;
        this.queuedExitingPackages = new LinkedList<BigItemStack>();
        this.signBasedAddress = "";
        this.customComputerAddress = "";
        this.hasCustomComputerAddress = false;
        this.buttonCooldown = 0;
    }

    public PackagerBlockEntity(class_2338 pos, class_2680 state) {
        this(AllBlockEntityTypes.PACKAGER, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.targetInventory = (InvManipulationBehaviour)new InvManipulationBehaviour(this, CapManipulationBehaviourBase.InterfaceProvider.oppositeOfBlockFacing()).withFilter((Predicate<class_2586>)((Predicate)this::supportsBlockEntity));
        behaviours.add(this.targetInventory);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.PACKAGER);
    }

    private boolean supportsBlockEntity(class_2586 target) {
        return target != null && !(target instanceof PortableStorageInterfaceBlockEntity);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.recheckIfLinksPresent();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.buttonCooldown > 0) {
            --this.buttonCooldown;
        }
        if (this.animationTicks == 0) {
            this.previouslyUnwrapped = class_1799.field_8037;
            if (!this.field_11863.method_8608() && !this.queuedExitingPackages.isEmpty() && this.heldBox.method_7960()) {
                BigItemStack entry = this.queuedExitingPackages.getFirst();
                this.heldBox = entry.stack.method_7972();
                --entry.count;
                if (entry.count <= 0) {
                    this.queuedExitingPackages.removeFirst();
                }
                this.animationInward = false;
                this.animationTicks = 20;
                this.notifyUpdate();
            }
            return;
        }
        if (this.field_11863.method_8608()) {
            if (this.animationTicks == 20 - (this.animationInward ? 5 : 1)) {
                AllSoundEvents.PACKAGER.playAt(this.field_11863, (class_2382)this.field_11867, 1.0f, 1.0f, true);
            }
            if (this.animationTicks == (this.animationInward ? 1 : 5)) {
                this.field_11863.method_45446(this.field_11867, class_3417.field_15131, class_3419.field_15245, 0.25f, 0.75f, true);
            }
        }
        --this.animationTicks;
        if (this.animationTicks == 0 && !this.field_11863.method_8608()) {
            this.wakeTheFrogs();
            this.method_5431();
        }
    }

    public void triggerStockCheck() {
        this.getAvailableItems();
    }

    public InventorySummary getAvailableItems() {
        if (this.availableItems != null && this.invVersionTracker.stillWaiting((class_1263)this.targetInventory.getInventory())) {
            return this.availableItems;
        }
        InventorySummary availableItems = new InventorySummary();
        class_1263 targetInv = (class_1263)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            this.availableItems = availableItems;
            return availableItems;
        }
        if (targetInv instanceof BottomlessItemHandler) {
            BottomlessItemHandler bih = (BottomlessItemHandler)targetInv;
            availableItems.add(bih.method_5438(0), 1000000000);
            this.availableItems = availableItems;
            return availableItems;
        }
        int size = targetInv.method_5439();
        for (int slot = 0; slot < size; ++slot) {
            availableItems.add(targetInv.method_5438(slot));
        }
        this.invVersionTracker.awaitNewVersion((class_1263)this.targetInventory.getInventory());
        this.submitNewArrivals(this.availableItems, availableItems);
        this.availableItems = availableItems;
        return availableItems;
    }

    private void submitNewArrivals(InventorySummary before, InventorySummary after) {
        if (before == null || after.isEmpty()) {
            return;
        }
        HashSet<RequestPromiseQueue> promiseQueues = new HashSet<RequestPromiseQueue>();
        for (class_2350 d : Iterate.directions) {
            Object object;
            if (!this.field_11863.method_8477(this.field_11867.method_10093(d))) continue;
            class_2680 adjacentState = this.field_11863.method_8320(this.field_11867.method_10093(d));
            if (adjacentState.method_27852((class_2248)AllBlocks.FACTORY_GAUGE)) {
                if (FactoryPanelBlock.connectedDirection(adjacentState) != d || !((object = this.field_11863.method_8321(this.field_11867.method_10093(d))) instanceof FactoryPanelBlockEntity)) continue;
                FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)object;
                if (!fpbe.restocker) continue;
                object = fpbe.panels.values().iterator();
                while (object.hasNext()) {
                    ServerFactoryPanelBehaviour behaviour = (ServerFactoryPanelBehaviour)object.next();
                    if (!behaviour.isActive()) continue;
                    promiseQueues.add(behaviour.restockerPromises);
                }
            }
            if (!adjacentState.method_27852((class_2248)AllBlocks.STOCK_LINK) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d || !((object = this.field_11863.method_8321(this.field_11867.method_10093(d))) instanceof PackagerLinkBlockEntity)) continue;
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)object;
            UUID freqId = plbe.behaviour.freqId;
            if (!Create.LOGISTICS.hasQueuedPromises(freqId)) continue;
            promiseQueues.add(Create.LOGISTICS.getQueuedPromises(freqId));
        }
        if (promiseQueues.isEmpty()) {
            return;
        }
        for (BigItemStack entry : after.getStacks()) {
            before.add(entry.stack, -entry.count);
        }
        for (RequestPromiseQueue queue : promiseQueues) {
            for (BigItemStack entry : before.getStacks()) {
                if (entry.count >= 0) continue;
                queue.itemEnteredSystem(entry.stack, -entry.count);
            }
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.method_8608()) {
            return;
        }
        this.recheckIfLinksPresent();
        if (!this.redstonePowered) {
            return;
        }
        this.redstonePowered = (Boolean)this.method_11010().method_61767((class_2769)PackagerBlock.POWERED, (Comparable)Boolean.valueOf(false));
        if (!this.redstoneModeActive()) {
            return;
        }
        this.updateSignAddress();
        this.attemptToSend(null);
    }

    public void recheckIfLinksPresent() {
        boolean isLinked;
        if (this.field_11863.method_8608()) {
            return;
        }
        class_2680 blockState = this.method_11010();
        if (!blockState.method_28498((class_2769)PackagerBlock.LINKED)) {
            return;
        }
        boolean shouldBeLinked = this.getLinkPos() != null;
        if (shouldBeLinked == (isLinked = ((Boolean)blockState.method_11654((class_2769)PackagerBlock.LINKED)).booleanValue())) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_28493((class_2769)PackagerBlock.LINKED));
    }

    public boolean redstoneModeActive() {
        return (Boolean)this.method_11010().method_61767((class_2769)PackagerBlock.LINKED, (Comparable)Boolean.valueOf(false)) == false;
    }

    private class_2338 getLinkPos() {
        for (class_2350 d : Iterate.directions) {
            class_2680 adjacentState = this.field_11863.method_8320(this.field_11867.method_10093(d));
            if (!adjacentState.method_27852((class_2248)AllBlocks.STOCK_LINK) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d) continue;
            return this.field_11867.method_10093(d);
        }
        return null;
    }

    public void flashLink() {
        class_2350[] class_2350Array = this.field_11863;
        if (!(class_2350Array instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_2350Array;
        for (class_2350 d : Iterate.directions) {
            class_2338 adjacentPos = this.field_11867.method_10093(d);
            class_2680 adjacentState = this.field_11863.method_8320(adjacentPos);
            if (!adjacentState.method_27852((class_2248)AllBlocks.STOCK_LINK) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d) continue;
            serverWorld.method_8503().method_3760().method_14605(null, (double)adjacentPos.method_10263(), (double)adjacentPos.method_10264(), (double)adjacentPos.method_10260(), 32.0, serverWorld.method_27983(), (class_2596)new WiFiEffectPacket(adjacentPos));
            return;
        }
    }

    public boolean isTooBusyFor(LogisticallyLinkedBehaviour.RequestType type) {
        int queue = this.queuedExitingPackages.size();
        return queue >= (switch (type) {
            default -> throw new MatchException(null, null);
            case LogisticallyLinkedBehaviour.RequestType.PLAYER -> 50;
            case LogisticallyLinkedBehaviour.RequestType.REDSTONE -> 20;
            case LogisticallyLinkedBehaviour.RequestType.RESTOCK -> 10;
        });
    }

    public void activate() {
        this.redstonePowered = true;
        this.method_5431();
        this.recheckIfLinksPresent();
        if (!this.redstoneModeActive()) {
            return;
        }
        this.updateSignAddress();
        this.attemptToSend(null);
        if (this.buttonCooldown <= 0) {
            this.buttonCooldown = 40;
        }
    }

    public boolean unwrapBox(class_1799 box, boolean simulate) {
        if (this.animationTicks > 0) {
            return false;
        }
        Objects.requireNonNull(this.field_11863);
        ItemStackHandler contents = PackageItem.getContents(box);
        List<class_1799> items = ItemHelper.getNonEmptyStacks(contents);
        if (items.isEmpty()) {
            return true;
        }
        PackageOrderWithCrafts orderContext = PackageItem.getOrderContext(box);
        class_2350 facing = (class_2350)this.method_11010().method_61767((class_2769)PackagerBlock.field_10927, (Comparable)class_2350.field_11036);
        class_2338 target = this.field_11867.method_10093(facing.method_10153());
        class_2680 targetState = this.field_11863.method_8320(target);
        UnpackingHandler handler = UnpackingHandler.REGISTRY.get((class_2688<class_2248, ?>)targetState);
        UnpackingHandler toUse = handler != null ? handler : AllUnpackingHandlers.DEFAULT;
        boolean unpacked = toUse.unpack(this.field_11863, target, targetState, facing, items, orderContext, simulate);
        if (unpacked && !simulate) {
            this.previouslyUnwrapped = box;
            this.animationInward = true;
            this.animationTicks = 20;
            this.notifyUpdate();
        }
        return unpacked;
    }

    public void attemptToSend(@Nullable List<PackagingRequest> queuedRequests) {
        class_2586 class_25862;
        boolean requestQueue;
        if (!(queuedRequests != null || this.heldBox.method_7960() && this.animationTicks == 0 && this.buttonCooldown <= 0)) {
            return;
        }
        class_1263 targetInv = (class_1263)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        MutableBoolean anyItemPresent = new MutableBoolean();
        ItemStackHandler extractedItems = new ItemStackHandler(9);
        class_1799 extractedPackageItem = class_1799.field_8037;
        PackagingRequest nextRequest = null;
        String fixedAddress = null;
        int fixedOrderId = 0;
        int linkIndexInOrder = 0;
        boolean finalLinkInOrder = false;
        int packageIndexAtLink = 0;
        boolean finalPackageAtLink = false;
        PackageOrderWithCrafts orderContext = null;
        boolean bl = requestQueue = queuedRequests != null;
        if (requestQueue && !queuedRequests.isEmpty()) {
            nextRequest = queuedRequests.get(0);
            fixedAddress = nextRequest.address();
            fixedOrderId = nextRequest.orderId();
            linkIndexInOrder = nextRequest.linkIndex();
            finalLinkInOrder = nextRequest.finalLink().booleanValue();
            packageIndexAtLink = nextRequest.packageCounter().getAndIncrement();
            orderContext = nextRequest.context();
        }
        block0: for (int i = 0; i < 9; ++i) {
            boolean continuePacking = true;
            while (continuePacking) {
                class_1792 item;
                continuePacking = false;
                if (requestQueue) {
                    int count;
                    int extract;
                    boolean bulky;
                    class_1799 stack2 = nextRequest.item();
                    item = stack2.method_7909();
                    boolean bl2 = bulky = !item.method_31568();
                    if (bulky && anyItemPresent.isTrue() || (extract = targetInv.extract(stack2, count = Math.min(64, nextRequest.getCount()))) == 0) break block0;
                    anyItemPresent.setTrue();
                    extractedItems.insert(stack2, extract);
                    if (item instanceof PackageItem) {
                        extractedPackageItem = stack2.method_46651(extract);
                    }
                    nextRequest.subtract(extract);
                    if (!nextRequest.isEmpty()) {
                        if (!bulky) continue block0;
                        break block0;
                    }
                    finalPackageAtLink = true;
                    queuedRequests.removeFirst();
                    if (queuedRequests.isEmpty()) break block0;
                    int previousCount = nextRequest.packageCounter().intValue();
                    nextRequest = queuedRequests.getFirst();
                    if (!fixedAddress.equals(nextRequest.address()) || fixedOrderId != nextRequest.orderId()) break block0;
                    nextRequest.packageCounter().setValue(previousCount);
                    finalPackageAtLink = false;
                    continuePacking = true;
                    if (nextRequest.context() != null) {
                        orderContext = nextRequest.context();
                    }
                    if (!bulky) continue;
                    break block0;
                }
                class_1799 extracted = targetInv.extract(stack -> anyItemPresent.isFalse() || stack.method_7909().method_31568(), 64);
                if (extracted.method_7960()) break block0;
                anyItemPresent.setTrue();
                extractedItems.insert(extracted);
                item = extracted.method_7909();
                if (item instanceof PackageItem) {
                    extractedPackageItem = extracted;
                }
                if (item.method_31568()) continue;
                break block0;
            }
        }
        if (anyItemPresent.isFalse()) {
            if (nextRequest != null) {
                queuedRequests.removeFirst();
            }
            return;
        }
        class_1799 createdBox = extractedPackageItem.method_7960() ? PackageItem.containing(extractedItems) : extractedPackageItem;
        PackageItem.clearAddress(createdBox);
        if (fixedAddress != null && !fixedAddress.isBlank()) {
            PackageItem.addAddress(createdBox, fixedAddress);
        }
        if (requestQueue) {
            PackageItem.setOrder(createdBox, fixedOrderId, linkIndexInOrder, finalLinkInOrder, packageIndexAtLink, finalPackageAtLink, orderContext);
        }
        if (!requestQueue && !this.signBasedAddress.isBlank()) {
            PackageItem.addAddress(createdBox, this.signBasedAddress);
        }
        class_2338 linkPos = this.getLinkPos();
        if (extractedPackageItem.method_7960() && linkPos != null && (class_25862 = this.field_11863.method_8321(linkPos)) instanceof PackagerLinkBlockEntity) {
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)class_25862;
            plbe.behaviour.deductFromAccurateSummary(extractedItems);
        }
        if (!this.heldBox.method_7960() || this.animationTicks != 0) {
            this.queuedExitingPackages.add(new BigItemStack(createdBox, 1));
            return;
        }
        this.heldBox = createdBox;
        this.animationInward = false;
        this.animationTicks = 20;
        this.award(AllAdvancements.PACKAGER);
        this.triggerStockCheck();
        this.notifyUpdate();
    }

    public void updateSignAddress() {
        this.signBasedAddress = "";
        for (class_2350 side : Iterate.directions) {
            String address = this.getSign(side);
            if (address == null || address.isBlank()) continue;
            this.signBasedAddress = address;
        }
        this.hasCustomComputerAddress = false;
    }

    protected String getSign(class_2350 side) {
        class_2586 blockEntity = this.field_11863.method_8321(this.field_11867.method_10093(side));
        if (!(blockEntity instanceof class_2625)) {
            return null;
        }
        class_2625 sign = (class_2625)blockEntity;
        for (boolean front : Iterate.trueAndFalse) {
            class_8242 text = sign.method_49843(front);
            Object address = "";
            for (class_2561 component : text.method_49877(false)) {
                String string = component.getString();
                if (string.isBlank()) continue;
                address = (String)address + string.trim() + " ";
            }
            if (((String)address).isBlank()) continue;
            return ((String)address).trim();
        }
        return null;
    }

    protected void wakeTheFrogs() {
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.redstonePowered = view.method_71433("Active", false);
        this.animationInward = view.method_71433("AnimationInward", false);
        this.animationTicks = view.method_71424("AnimationTicks", 0);
        this.signBasedAddress = view.method_71428("SignAddress", "");
        this.customComputerAddress = view.method_71428("ComputerAddress", "");
        this.hasCustomComputerAddress = view.method_71433("HasComputerAddress", false);
        this.heldBox = view.method_71426("HeldBox", class_1799.field_24671).orElse(class_1799.field_8037);
        this.previouslyUnwrapped = view.method_71426("InsertedBox", class_1799.field_24671).orElse(class_1799.field_8037);
        if (clientPacket) {
            return;
        }
        this.queuedExitingPackages.clear();
        view.method_71426("QueuedExitingPackages", EXITING_CODEC).ifPresent(list -> this.queuedExitingPackages.addAll((Collection<BigItemStack>)list));
        view.method_71426("LastSummary", InventorySummary.CODEC).ifPresent(summary -> {
            this.availableItems = summary;
        });
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71472("Active", this.redstonePowered);
        view.method_71472("AnimationInward", this.animationInward);
        view.method_71465("AnimationTicks", this.animationTicks);
        view.method_71469("SignAddress", this.signBasedAddress);
        view.method_71469("ComputerAddress", this.customComputerAddress);
        view.method_71472("HasComputerAddress", this.hasCustomComputerAddress.booleanValue());
        if (!this.heldBox.method_7960()) {
            view.method_71468("HeldBox", class_1799.field_24671, (Object)this.heldBox);
        }
        if (!this.previouslyUnwrapped.method_7960()) {
            view.method_71468("InsertedBox", class_1799.field_24671, (Object)this.previouslyUnwrapped);
        }
        if (clientPacket) {
            return;
        }
        view.method_71468("QueuedExitingPackages", EXITING_CODEC, this.queuedExitingPackages);
        if (this.availableItems != null) {
            view.method_71468("LastSummary", InventorySummary.CODEC, (Object)this.availableItems);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this.inventory);
        this.queuedExitingPackages.forEach(bigStack -> {
            for (int i = 0; i < bigStack.count; ++i) {
                class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)bigStack.stack.method_7972());
            }
        });
        this.queuedExitingPackages.clear();
    }

    public float getTrayOffset(float partialTicks) {
        float tickCycle = this.animationInward ? (float)this.animationTicks - partialTicks : (float)(this.animationTicks - 5) - partialTicks;
        float progress = class_3532.method_15363((float)(tickCycle / 15.0f * 2.0f - 1.0f), (float)-1.0f, (float)1.0f);
        progress = 1.0f - progress * progress;
        return progress * progress;
    }

    public class_1799 getRenderedBox() {
        if (this.animationInward) {
            return this.animationTicks <= 10 ? class_1799.field_8037 : this.previouslyUnwrapped;
        }
        return this.animationTicks >= 10 ? class_1799.field_8037 : this.heldBox;
    }

    public boolean isTargetingSameInventory(@Nullable IdentifiedInventory inventory) {
        if (inventory == null) {
            return false;
        }
        class_1263 targetHandler = (class_1263)this.targetInventory.getInventory();
        if (targetHandler == null) {
            return false;
        }
        if (inventory.identifier() != null) {
            BlockFace face = this.targetInventory.getTarget().getOpposite();
            return inventory.identifier().contains(face);
        }
        return PackagerBlockEntity.isSameInventoryFallback(targetHandler, inventory.handler());
    }

    private static boolean isSameInventoryFallback(class_1263 first, class_1263 second) {
        if (first == second) {
            return true;
        }
        int secondSize = second.method_5439();
        for (int i = 0; i < secondSize; ++i) {
            class_1799 stackInSlot = second.method_5438(i);
            if (stackInSlot.method_7960()) continue;
            int firstSize = first.method_5439();
            for (int j = 0; j < firstSize; ++j) {
                if (stackInSlot != first.method_5438(j)) continue;
                return true;
            }
            break;
        }
        return false;
    }
}

