/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.condition.LazyTickedScheduleCondition;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public abstract class CargoThresholdCondition
extends LazyTickedScheduleCondition {
    public CargoThresholdCondition(class_2960 id) {
        super(id, 20);
        this.data.method_10582("Threshold", "10");
    }

    @Override
    public boolean lazyTickCompletion(class_1937 level, Train train, class_2487 context) {
        int lastChecked = context.method_10545("LastChecked") ? context.method_68083("LastChecked", 0) : -1;
        int status = 0;
        for (Carriage carriage : train.carriages) {
            status += carriage.storage.getVersion();
        }
        if (status == lastChecked) {
            return false;
        }
        context.method_10569("LastChecked", status);
        return this.test(level, train, context);
    }

    protected void requestStatusToUpdate(int amount, class_2487 context) {
        context.method_10569("CurrentDisplay", amount);
        super.requestStatusToUpdate(context);
    }

    protected int getLastDisplaySnapshot(class_2487 context) {
        if (!context.method_10545("CurrentDisplay")) {
            return -1;
        }
        return context.method_68083("CurrentDisplay", 0);
    }

    protected abstract boolean test(class_1937 var1, Train var2, class_2487 var3);

    public Ops getOperator() {
        return this.enumData("Operator", Ops.class);
    }

    public int getThreshold() {
        try {
            return Integer.parseInt(this.textData("Threshold"));
        }
        catch (NumberFormatException e) {
            this.data.method_10582("Threshold", "0");
            return 0;
        }
    }

    public int getMeasure() {
        return this.intData("Measure");
    }

    public static enum Ops {
        GREATER(">"),
        LESS("<"),
        EQUAL("=");

        public final String formatted;

        private Ops(String formatted) {
            this.formatted = formatted;
        }

        public boolean test(int current, int target) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (current > target) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (current == target) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> current < target;
            };
        }
    }
}

