/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_3542;

public enum TrackShape implements class_3542
{
    NONE("", class_243.field_1353),
    ZO("z_ortho", new class_243(0.0, 0.0, 1.0)),
    XO("x_ortho", new class_243(1.0, 0.0, 0.0)),
    PD("diag", new class_243(1.0, 0.0, 1.0)),
    ND("diag_2", new class_243(-1.0, 0.0, 1.0)),
    AN("ascending", 180, new class_243(0.0, 1.0, -1.0), new class_243(0.0, 1.0, 1.0)),
    AS("ascending", 0, new class_243(0.0, 1.0, 1.0), new class_243(0.0, 1.0, -1.0)),
    AE("ascending", 270, new class_243(1.0, 1.0, 0.0), new class_243(-1.0, 1.0, 0.0)),
    AW("ascending", 90, new class_243(-1.0, 1.0, 0.0), new class_243(1.0, 1.0, 0.0)),
    TN("teleport", 180, new class_243(0.0, 0.0, -1.0), new class_243(0.0, 1.0, 0.0)),
    TS("teleport", 0, new class_243(0.0, 0.0, 1.0), new class_243(0.0, 1.0, 0.0)),
    TE("teleport", 270, new class_243(1.0, 0.0, 0.0), new class_243(0.0, 1.0, 0.0)),
    TW("teleport", 90, new class_243(-1.0, 0.0, 0.0), new class_243(0.0, 1.0, 0.0)),
    CR_O("cross_ortho", new class_243(0.0, 0.0, 1.0), new class_243(1.0, 0.0, 0.0)),
    CR_D("cross_diag", new class_243(1.0, 0.0, 1.0), new class_243(-1.0, 0.0, 1.0)),
    CR_PDX("cross_d1_xo", new class_243(1.0, 0.0, 0.0), new class_243(1.0, 0.0, 1.0)),
    CR_PDZ("cross_d1_zo", new class_243(0.0, 0.0, 1.0), new class_243(1.0, 0.0, 1.0)),
    CR_NDX("cross_d2_xo", new class_243(1.0, 0.0, 0.0), new class_243(-1.0, 0.0, 1.0)),
    CR_NDZ("cross_d2_zo", new class_243(0.0, 0.0, 1.0), new class_243(-1.0, 0.0, 1.0));

    private String model;
    private List<class_243> axes;
    private int modelRotation;
    private class_243 normal;
    static EnumMap<TrackShape, TrackShape> zMirror;
    static EnumMap<TrackShape, TrackShape> xMirror;
    static EnumMap<TrackShape, TrackShape> clockwise;

    private TrackShape(String model, class_243 axis) {
        this(model, 0, axis, new class_243(0.0, 1.0, 0.0));
    }

    private TrackShape(String model, class_243 axis, class_243 secondAxis) {
        this.model = model;
        this.modelRotation = 0;
        this.normal = new class_243(0.0, 1.0, 0.0);
        this.axes = ImmutableList.of((Object)axis, (Object)secondAxis);
    }

    private TrackShape(String model, int modelRotation, class_243 axis, class_243 normal) {
        this.model = model;
        this.modelRotation = modelRotation;
        this.normal = normal.method_1029();
        this.axes = ImmutableList.of((Object)axis);
    }

    public String method_15434() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getModel() {
        return this.model;
    }

    public List<class_243> getAxes() {
        return this.axes;
    }

    public boolean isJunction() {
        return this.axes.size() > 1;
    }

    public boolean isPortal() {
        return switch (this.ordinal()) {
            case 9, 10, 11, 12 -> true;
            default -> false;
        };
    }

    public static TrackShape asPortal(class_2350 horizontalFacing) {
        return switch (horizontalFacing) {
            case class_2350.field_11034 -> TE;
            case class_2350.field_11043 -> TN;
            case class_2350.field_11035 -> TS;
            default -> TW;
        };
    }

    public class_243 getNormal() {
        return this.normal;
    }

    public int getModelRotation() {
        return this.modelRotation;
    }

    public TrackShape mirror(class_2415 mirror) {
        return mirror == class_2415.field_11302 ? this : (mirror == class_2415.field_11301 ? xMirror.getOrDefault((Object)this, this) : zMirror.getOrDefault((Object)this, this));
    }

    public TrackShape rotate(class_2470 rotation) {
        TrackShape shape = this;
        for (int i = 0; i < rotation.ordinal(); ++i) {
            shape = clockwise.getOrDefault((Object)shape, shape);
        }
        return shape;
    }

    static {
        zMirror = new EnumMap(TrackShape.class);
        xMirror = new EnumMap(TrackShape.class);
        clockwise = new EnumMap(TrackShape.class);
        zMirror.putAll((Map<TrackShape, TrackShape>)ImmutableMap.builder().put((Object)PD, (Object)ND).put((Object)ND, (Object)PD).put((Object)AN, (Object)AS).put((Object)AS, (Object)AN).put((Object)CR_PDX, (Object)CR_NDX).put((Object)CR_NDX, (Object)CR_PDX).put((Object)CR_PDZ, (Object)CR_NDZ).put((Object)CR_NDZ, (Object)CR_PDZ).build());
        xMirror.putAll((Map<TrackShape, TrackShape>)ImmutableMap.builder().put((Object)PD, (Object)ND).put((Object)ND, (Object)PD).put((Object)AE, (Object)AW).put((Object)AW, (Object)AE).put((Object)CR_PDX, (Object)CR_NDX).put((Object)CR_NDX, (Object)CR_PDX).put((Object)CR_PDZ, (Object)CR_NDZ).put((Object)CR_NDZ, (Object)CR_PDZ).build());
        clockwise.putAll((Map<TrackShape, TrackShape>)ImmutableMap.builder().put((Object)PD, (Object)ND).put((Object)ND, (Object)PD).put((Object)XO, (Object)ZO).put((Object)ZO, (Object)XO).put((Object)AE, (Object)AS).put((Object)AS, (Object)AW).put((Object)AW, (Object)AN).put((Object)AN, (Object)AE).put((Object)CR_PDX, (Object)CR_NDZ).put((Object)CR_NDX, (Object)CR_PDZ).put((Object)CR_PDZ, (Object)CR_NDX).put((Object)CR_NDZ, (Object)CR_PDX).build());
    }
}

