/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_4844;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record ShoppingList(@Unmodifiable List<IntAttached<class_2338>> purchases, UUID shopOwner, UUID shopNetwork) {
    public static final Codec<ShoppingList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntAttached.codec(class_2338.field_25064).listOf().fieldOf("purchases").forGetter(ShoppingList::purchases), (App)class_4844.field_25122.fieldOf("shop_owner").forGetter(ShoppingList::shopOwner), (App)class_4844.field_25122.fieldOf("shop_network").forGetter(ShoppingList::shopNetwork)).apply((Applicative)instance, ShoppingList::new));
    public static final class_9139<class_2540, ShoppingList> STREAM_CODEC = class_9139.method_56436(CatnipStreamCodecBuilders.list(IntAttached.streamCodec(class_2338.field_48404)), ShoppingList::purchases, (class_9139)class_4844.field_48453, ShoppingList::shopOwner, (class_9139)class_4844.field_48453, ShoppingList::shopNetwork, ShoppingList::new);

    public ShoppingList duplicate() {
        return new ShoppingList(new ArrayList<IntAttached<class_2338>>(this.purchases.stream().map(ia -> IntAttached.with((Integer)ia.getFirst(), (class_2338)ia.getSecond())).toList()), this.shopOwner, this.shopNetwork);
    }

    public int getPurchases(class_2338 clothPos) {
        for (IntAttached<class_2338> entry : this.purchases) {
            if (!clothPos.equals((Object)entry.getValue())) continue;
            return (Integer)entry.getFirst();
        }
        return 0;
    }

    public Couple<InventorySummary> bakeEntries(class_1936 level, @Nullable class_2338 clothPosToIgnore) {
        InventorySummary input = new InventorySummary();
        InventorySummary output = new InventorySummary();
        for (IntAttached<class_2338> entry : this.purchases) {
            Object object;
            if (clothPosToIgnore != null && clothPosToIgnore.equals((Object)entry.getValue()) || !((object = level.method_8321(entry.getValue())) instanceof TableClothBlockEntity)) continue;
            TableClothBlockEntity dcbe = (TableClothBlockEntity)object;
            input.add(dcbe.getPaymentItem(), dcbe.getPaymentAmount() * (Integer)entry.getFirst());
            object = dcbe.requestData.encodedRequest().stacks().iterator();
            while (object.hasNext()) {
                BigItemStack stackEntry = (BigItemStack)object.next();
                output.add(stackEntry.stack, stackEntry.count * (Integer)entry.getFirst());
            }
        }
        return Couple.create(output, input);
    }

    public static class Mutable {
        private final List<IntAttached<class_2338>> purchases = new ArrayList<IntAttached<class_2338>>();
        private final UUID shopOwner;
        private final UUID shopNetwork;

        public Mutable(ShoppingList list) {
            this.purchases.addAll(list.purchases);
            this.shopOwner = list.shopOwner;
            this.shopNetwork = list.shopNetwork;
        }

        public void addPurchases(class_2338 clothPos, int amount) {
            for (IntAttached<class_2338> entry : this.purchases) {
                if (!clothPos.equals((Object)entry.getValue())) continue;
                entry.setFirst((Integer)entry.getFirst() + amount);
                return;
            }
            this.purchases.add(IntAttached.with(amount, clothPos));
        }

        public ShoppingList toImmutable() {
            return new ShoppingList(this.purchases, this.shopOwner, this.shopNetwork);
        }
    }
}

