/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.transfer;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.transfer.FluidInventoryStorage;
import com.zurrtum.create.infrastructure.transfer.FluidInventoryStorageImpl;
import com.zurrtum.create.infrastructure.transfer.SingleFluidStackStorage;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_9331;

public class FluidInventorySlotWrapper
extends SingleFluidStackStorage {
    private final FluidInventoryStorageImpl storage;
    final int slot;
    private FluidStack lastReleasedSnapshot = null;

    FluidInventorySlotWrapper(FluidInventoryStorageImpl storage, int slot) {
        this.storage = storage;
        this.slot = slot;
    }

    @Override
    protected FluidStack getStack() {
        return this.storage.inventory.getStack(this.slot);
    }

    @Override
    protected void setStack(FluidStack stack) {
        this.storage.inventory.setStack(this.slot, stack);
    }

    @Override
    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        if (!this.canInsert(this.slot, FluidInventoryStorage.getCachedStack(insertedVariant))) {
            return 0L;
        }
        return super.insert(insertedVariant, maxAmount, transaction);
    }

    private boolean canInsert(int slot, FluidStack stack) {
        return this.storage.inventory.isValid(slot, stack);
    }

    @Override
    public int getCapacity(FluidVariant insert, FluidStack stack) {
        Integer capacity = (Integer)stack.method_58694(AllDataComponents.FLUID_MAX_CAPACITY);
        if (capacity != null) {
            return Math.min(this.storage.inventory.getMaxAmountPerStack(), capacity);
        }
        return this.storage.inventory.getMaxAmount(FluidInventoryStorage.getCachedStack(insert));
    }

    public void updateSnapshots(TransactionContext transaction) {
        this.storage.markDirtyParticipant.updateSnapshots(transaction);
        super.updateSnapshots(transaction);
    }

    protected void releaseSnapshot(FluidStack snapshot) {
        this.lastReleasedSnapshot = snapshot;
    }

    protected void onFinalCommit() {
        FluidStack original = this.lastReleasedSnapshot;
        FluidStack currentStack = this.getStack();
        if (!original.isEmpty() && original.getFluid() == currentStack.getFluid()) {
            if (!Objects.equals(original.getComponentChanges(), currentStack.getComponentChanges())) {
                for (class_9331 type : original.method_57353().method_57831()) {
                    original.set(type, null);
                }
                original.applyComponentsFrom(currentStack.method_57353());
            }
            original.setAmount(currentStack.getAmount());
            this.setStack(original);
        } else {
            original.setAmount(0);
        }
    }

    @Override
    public String toString() {
        return "InventorySlotWrapper[%s#%d]".formatted(FluidInventoryStorage.toString(this.storage.inventory), this.slot);
    }
}

