package com.zurrtum.create;

import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.nbt.NBTProcessors;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsServerHandler;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContactBlock;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContactBlockEntity;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.content.contraptions.glue.SuperGlueSelectionHelper;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import com.zurrtum.create.content.equipment.blueprint.BlueprintMenu;
import com.zurrtum.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxHandler;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.equipment.zapper.ZapperInteractionHandler;
import com.zurrtum.create.content.equipment.zapper.ZapperItem;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.kinetics.chainConveyor.ServerChainConveyorHandler;
import com.zurrtum.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.depot.EjectorBlock;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.logistics.filter.AttributeFilterMenu;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterMenu;
import com.zurrtum.create.content.logistics.filter.PackageFilterMenu;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.logistics.packagePort.PackagePortTarget;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour.RequestType;
import com.zurrtum.create.content.logistics.packagerLink.LogisticsNetwork;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterBlock;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperCategoryMenu;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.content.redstone.link.controller.LecternControllerBlockEntity;
import com.zurrtum.create.content.redstone.link.controller.LinkedControllerItem;
import com.zurrtum.create.content.redstone.link.controller.LinkedControllerServerHandler;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.zurrtum.create.content.schematics.SchematicInstances;
import com.zurrtum.create.content.schematics.SchematicPrinter;
import com.zurrtum.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.zurrtum.create.content.schematics.cannon.SchematicannonMenu;
import com.zurrtum.create.content.schematics.table.SchematicTableMenu;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TrainIconType;
import com.zurrtum.create.content.trains.entity.TrainRelocator;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackPropagator;
import com.zurrtum.create.content.trains.track.TrackTargetingBlockItem;
import com.zurrtum.create.content.trains.track.TrackTargetingBlockItem.OverlapResult;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettingsHandleBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.foundation.gui.menu.GhostItemMenu;
import com.zurrtum.create.foundation.gui.menu.IClearableMenu;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.*;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.c2s.*;
import com.zurrtum.create.infrastructure.packet.s2c.*;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_11362;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_8942;
import net.minecraft.class_9335;

public class AllHandle {
    public static void onConfigureSchematicannon(class_3244 listener, ConfigureSchematicannonPacket packet) {
        if (!(listener.field_14140.field_7512 instanceof SchematicannonMenu menu))
            return;

        SchematicannonBlockEntity be = menu.contentHolder;
        ConfigureSchematicannonPacket.Option option = packet.option();
        switch (option) {
            case DONT_REPLACE:
            case REPLACE_ANY:
            case REPLACE_EMPTY:
            case REPLACE_SOLID:
                be.replaceMode = option.ordinal();
                break;
            case SKIP_MISSING:
                be.skipMissing = packet.set();
                break;
            case SKIP_BLOCK_ENTITIES:
                be.replaceBlockEntities = packet.set();
                break;

            case PLAY:
                be.state = SchematicannonBlockEntity.State.RUNNING;
                be.statusMsg = "running";
                break;
            case PAUSE:
                be.state = SchematicannonBlockEntity.State.PAUSED;
                be.statusMsg = "paused";
                break;
            case STOP:
                be.state = SchematicannonBlockEntity.State.STOPPED;
                be.statusMsg = "stopped";
                break;
            default:
                break;
        }

        be.sendUpdate = true;
    }

    private static void onBlockEntityConfiguration(class_3244 listener, class_2338 pos, int distance, Predicate<class_2586> predicate) {
        class_3222 player = listener.field_14140;
        if (player.method_7325() || !player.method_7294()) {
            return;
        }
        class_3218 world = player.method_51469();
        if (!world.method_8477(pos)) {
            return;
        }
        if (!pos.method_19771(player.method_24515(), distance)) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (predicate.test(blockEntity)) {
            world.method_14178().method_14128(pos);
            blockEntity.method_5431();
        }
    }

    public static void onConfigureThresholdSwitch(class_3244 listener, ConfigureThresholdSwitchPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof ThresholdSwitchBlockEntity be) {
                    be.offWhenBelow = packet.offBelow();
                    be.onWhenAbove = packet.onAbove();
                    be.setInverted(packet.invert());
                    be.inStacks = packet.inStacks();
                    return true;
                }
                return false;
            }
        );
    }

    public static void onConfigureSequencedGearshift(class_3244 listener, ConfigureSequencedGearshiftPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                //TODO
                if (blockEntity instanceof SequencedGearshiftBlockEntity be/* && !be.computerBehaviour.hasAttachedComputer()*/) {
                    be.run(-1);
                    be.instructions = packet.instructions();
                    return true;
                }
                return false;
            }
        );
    }

    public static void onEjectorTrigger(class_3244 listener, EjectorTriggerPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof EjectorBlockEntity be) {
                    be.activate();
                    return true;
                }
                return false;
            }
        );
    }

    public static void onStationEdit(class_3244 listener, StationEditPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof StationBlockEntity be) {
                    class_3222 player = listener.field_14140;
                    class_1937 level = be.method_10997();
                    class_2338 blockPos = be.method_11016();
                    class_2680 blockState = level.method_8320(blockPos);
                    GlobalStation station = be.getStation();

                    if (packet.dropSchedule()) {
                        if (station == null)
                            return true;
                        be.dropSchedule(player, station.getPresentTrain());
                        return true;
                    }

                    if (packet.doorControl() != null)
                        be.doorControls.set(packet.doorControl());

                    if (packet.name() != null && !packet.name().isBlank())
                        be.updateName(packet.name());

                    if (!(blockState.method_26204() instanceof StationBlock))
                        return true;

                    Boolean isAssemblyMode = blockState.method_11654(StationBlock.ASSEMBLING);
                    boolean assemblyComplete = false;

                    if (packet.tryAssemble() != null) {
                        if (!isAssemblyMode)
                            return true;
                        if (packet.tryAssemble()) {
                            be.assemble(player.method_5667());
                            assemblyComplete = station != null && station.getPresentTrain() != null;
                        } else {
                            if (be.tryDisassembleTrain(player) && be.tryEnterAssemblyMode())
                                be.refreshAssemblyInfo();
                        }
                        if (!assemblyComplete)
                            return true;
                    }

                    if (packet.assemblyMode())
                        be.enterAssemblyMode(player);
                    else
                        be.exitAssemblyMode();
                    return true;
                }
                return false;
            }
        );
    }

    public static void onDisplayLinkConfiguration(class_3244 listener, DisplayLinkConfigurationPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof DisplayLinkBlockEntity be) {
                    be.targetLine = packet.targetLine();

                    class_2487 configData = packet.configData();
                    class_2960 id = configData.method_67491("Id", class_2960.field_25139).orElse(null);
                    if (id == null) {
                        be.notifyUpdate();
                        return true;
                    }

                    DisplaySource source = DisplaySource.get(id);
                    if (source == null) {
                        be.notifyUpdate();
                        return true;
                    }

                    if (be.activeSource == null || be.activeSource != source) {
                        be.activeSource = source;
                        be.setSourceConfig(configData.method_10553());
                    } else {
                        be.getSourceConfig().method_10543(configData);
                    }

                    be.updateGatheredData();
                    be.notifyUpdate();
                    return true;
                }
                return false;
            }
        );
    }

    public static void onCurvedTrackDestroy(class_3244 listener, CurvedTrackDestroyPacket packet) {
        class_2338 pos = packet.pos();
        onBlockEntityConfiguration(
            listener, pos, AllConfigs.server().trains.maxTrackPlacementLength.get() + 16, blockEntity -> {
                if (blockEntity instanceof TrackBlockEntity be) {
                    class_3222 player = listener.field_14140;
                    class_3218 world = player.method_51469();
                    int verifyDistance = AllConfigs.server().trains.maxTrackPlacementLength.get() * 4;
                    if (!be.method_11016().method_19771(player.method_24515(), verifyDistance)) {
                        Create.LOGGER.warn(player.method_5820() + " too far away from destroyed Curve track");
                        return true;
                    }

                    class_2338 targetPos = packet.targetPos();
                    BezierConnection bezierConnection = be.getConnections().get(targetPos);

                    be.removeConnection(targetPos);
                    if (world.method_8321(targetPos) instanceof TrackBlockEntity other)
                        other.removeConnection(pos);

                    class_2680 blockState = be.method_11010();
                    TrackPropagator.onRailRemoved(world, pos, blockState);

                    if (packet.wrench()) {
                        AllSoundEvents.WRENCH_REMOVE.playOnServer(world, packet.soundSource(), 1, world.field_9229.method_43057() * .5f + .5f);
                        if (!player.method_68878() && bezierConnection != null)
                            bezierConnection.addItemsToPlayer(player);
                    } else if (!player.method_68878() && bezierConnection != null)
                        bezierConnection.spawnItems(world);

                    bezierConnection.spawnDestroyParticles(world);
                    class_2498 soundtype = blockState.method_26231();
                    if (soundtype == null)
                        return true;

                    world.method_8396(
                        null,
                        packet.soundSource(),
                        soundtype.method_10595(),
                        class_3419.field_15245,
                        (soundtype.method_10597() + 1.0F) / 2.0F,
                        soundtype.method_10599() * 0.8F
                    );
                    return true;
                }
                return false;
            }
        );
    }

    public static void onCurvedTrackSelection(class_3244 listener, CurvedTrackSelectionPacket packet) {
        class_2338 pos = packet.pos();
        onBlockEntityConfiguration(
            listener, pos, AllConfigs.server().trains.maxTrackPlacementLength.get() + 16, blockEntity -> {
                if (blockEntity instanceof TrackBlockEntity be) {
                    class_3222 player = listener.field_14140;
                    class_3218 world = player.method_51469();
                    if (player.method_31548().method_67532() != packet.slot())
                        return true;
                    class_1799 stack = player.method_31548().method_5438(packet.slot());
                    if (!(stack.method_7909() instanceof TrackTargetingBlockItem))
                        return true;
                    if (player.method_5715() && stack.method_57826(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS)) {
                        player.method_7353(class_2561.method_43471("create.track_target.clear"), true);
                        stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
                        stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
                        stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
                        AllSoundEvents.CONTROLLER_CLICK.play(world, null, pos, 1, .5f);
                        return true;
                    }

                    EdgePointType<?> type = stack.method_31574(AllItems.TRACK_SIGNAL) ? EdgePointType.SIGNAL : EdgePointType.STATION;
                    MutableObject<OverlapResult> result = new MutableObject<>(null);
                    BezierTrackPointLocation bezierTrackPointLocation = new BezierTrackPointLocation(packet.targetPos(), packet.segment());
                    TrackTargetingBlockItem.withGraphLocation(
                        world,
                        pos,
                        packet.front(),
                        bezierTrackPointLocation,
                        type,
                        (overlap, location) -> result.setValue(overlap)
                    );

                    if (result.getValue().feedback != null) {
                        player.method_7353(class_2561.method_43471("create." + result.getValue().feedback).method_27692(class_124.field_1061), true);
                        AllSoundEvents.DENY.play(world, null, pos, .5f, 1);
                        return true;
                    }

                    stack.method_57379(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS, pos);
                    stack.method_57379(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, packet.front());
                    stack.method_57379(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER, bezierTrackPointLocation);

                    player.method_7353(class_2561.method_43471("create.track_target.set"), true);
                    AllSoundEvents.CONTROLLER_CLICK.play(world, null, pos, 1, 1);
                    return true;
                }
                return false;
            }
        );
    }

    public static void onGaugeObserved(class_3244 listener, GaugeObservedPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof StressGaugeBlockEntity be) {
                    be.onObserved();
                }
                return false;
            }
        );
    }

    public static void onEjectorAward(class_3244 listener, EjectorAwardPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof EjectorBlockEntity) {
                    AllAdvancements.EJECTOR_MAXED.trigger(listener.field_14140);
                    return true;
                }
                return false;
            }
        );
    }

    public static void onElevatorContactEdit(class_3244 listener, ElevatorContactEditPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof ElevatorContactBlockEntity be) {
                    be.updateName(packet.shortName(), packet.longName());
                    be.doorControls.set(packet.doorControl());
                    return true;
                }
                return false;
            }
        );
    }

    public static void onValueSettings(class_3244 listener, ValueSettingsPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof SmartBlockEntity be) {
                    class_3222 player = listener.field_14140;
                    if (be instanceof FactoryPanelBlockEntity fpbe) {
                        for (ServerFactoryPanelBehaviour behaviour : fpbe.panels.values()) {
                            if (handleValueSettings(player, behaviour, packet)) {
                                break;
                            }
                        }
                    } else {
                        ServerScrollValueBehaviour scrollValueBehaviour = be.getBehaviour(ServerScrollValueBehaviour.TYPE);
                        if (!handleValueSettings(player, scrollValueBehaviour, packet)) {
                            ServerFilteringBehaviour filteringBehaviour = be.getBehaviour(ServerFilteringBehaviour.TYPE);
                            handleValueSettings(player, filteringBehaviour, packet);
                        }
                    }
                    return true;
                }
                return false;
            }
        );
    }

    private static boolean handleValueSettings(class_3222 player, ValueSettingsHandleBehaviour handle, ValueSettingsPacket packet) {
        if (handle == null || !handle.acceptsValueSettings() || packet.behaviourIndex() != handle.netId()) {
            return false;
        }
        if (packet.interactHand() != null) {
            handle.onShortInteract(player, packet.interactHand(), packet.side(), packet.hitResult());
            return true;
        }
        handle.setValueSettings(player, new ValueSettings(packet.row(), packet.value()), packet.ctrlDown());
        return true;
    }

    public static void onLogisticalStockRequest(class_3244 listener, LogisticalStockRequestPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 4096, blockEntity -> {
                if (blockEntity instanceof StockCheckingBlockEntity be) {
                    be.getRecentSummary().divideAndSendTo(listener.field_14140, packet.pos());
                    return true;
                }
                return false;
            }
        );
    }

    public static void onPackageOrderRequest(class_3244 listener, PackageOrderRequestPacket packet) {
        class_3222 player = listener.field_14140;
        class_3218 world = player.method_51469();
        class_2338 pos = packet.pos();
        onBlockEntityConfiguration(
            listener, pos, 20, blockEntity -> {
                if (blockEntity instanceof StockTickerBlockEntity be) {
                    PackageOrderWithCrafts order = packet.order();
                    if (packet.encodeRequester()) {
                        if (!order.isEmpty())
                            AllSoundEvents.CONFIRM.playOnServer(world, pos);
                        player.method_7346();
                        RedstoneRequesterBlock.programRequester(player, be, order, packet.address());
                        return true;
                    }

                    if (!order.isEmpty()) {
                        AllSoundEvents.STOCK_TICKER_REQUEST.playOnServer(world, pos);
                        AllAdvancements.STOCK_TICKER.trigger(player);
                        listener.field_45012.method_3760()
                            .method_14605(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), 32, world.method_27983(), new WiFiEffectPacket(pos));
                    }

                    be.broadcastPackageRequest(RequestType.PLAYER, order, null, packet.address());
                    return true;
                }
                return false;
            }
        );
    }

    public static void onChainConveyorConnection(class_3244 listener, ChainConveyorConnectionPacket packet) {
        class_3222 player = listener.field_14140;
        class_3218 world = player.method_51469();
        int maxRange = AllConfigs.server().kinetics.maxChainConveyorLength.get() + 16;
        onBlockEntityConfiguration(
            listener, packet.pos(), maxRange, blockEntity -> {
                if (blockEntity instanceof ChainConveyorBlockEntity be) {
                    class_2338 targetPos = packet.targetPos();
                    boolean connect = packet.connect();
                    if (!be.method_11016().method_19771(targetPos, maxRange - 16 + 1))
                        return true;
                    if (!(world.method_8321(targetPos) instanceof ChainConveyorBlockEntity clbe))
                        return true;

                    if (connect && !player.method_68878()) {
                        int chainCost = ChainConveyorBlockEntity.getChainCost(targetPos.method_10059(be.method_11016()));
                        boolean hasEnough = ChainConveyorBlockEntity.getChainsFromInventory(player, packet.chain(), chainCost, true);
                        if (!hasEnough)
                            return true;
                        ChainConveyorBlockEntity.getChainsFromInventory(player, packet.chain(), chainCost, false);
                    }

                    if (!connect) {
                        if (!player.method_68878()) {
                            int chainCost = ChainConveyorBlockEntity.getChainCost(targetPos.method_10059(packet.pos()));
                            while (chainCost > 0) {
                                player.method_31548().method_7398(new class_1799(class_1802.field_23983, Math.min(chainCost, 64)));
                                chainCost -= 64;
                            }
                        }
                        be.chainDestroyed(targetPos.method_10059(be.method_11016()), false, true);
                        world.method_45447(null, player.method_24515(), class_3417.field_24065, class_3419.field_15245);
                    }

                    if (connect) {
                        if (!clbe.addConnectionTo(be.method_11016()))
                            return true;
                    } else
                        clbe.removeConnectionTo(be.method_11016());

                    if (connect) {
                        if (!be.addConnectionTo(targetPos))
                            clbe.removeConnectionTo(be.method_11016());
                    } else
                        be.removeConnectionTo(targetPos);
                    return true;
                }
                return false;
            }
        );
    }

    public static void onServerboundChainConveyorRiding(class_3244 listener, ServerboundChainConveyorRidingPacket packet) {
        class_3222 sender = listener.field_14140;
        onBlockEntityConfiguration(
            listener, packet.pos(), AllConfigs.server().kinetics.maxChainConveyorLength.get() * 2, blockEntity -> {
                if (blockEntity instanceof ChainConveyorBlockEntity be) {
                    sender.field_6017 = 0;
                    sender.field_13987.field_14138 = 0;
                    sender.field_13987.field_14137 = 0;
                    if (packet.stop()) {
                        ServerChainConveyorHandler.handleStopRidingPacket(listener.field_45012, sender);
                    } else {
                        ServerChainConveyorHandler.handleTTLPacket(listener.field_45012, sender);
                    }
                    return true;
                }
                return false;
            }
        );
    }

    public static void onChainPackageInteraction(class_3244 listener, ChainPackageInteractionPacket packet) {
        class_3222 player = listener.field_14140;
        int maxRange = AllConfigs.server().kinetics.maxChainConveyorLength.get() + 16;
        onBlockEntityConfiguration(
            listener, packet.pos(), maxRange, blockEntity -> {
                if (blockEntity instanceof ChainConveyorBlockEntity be) {
                    class_2338 selectedConnection = packet.selectedConnection();
                    float chainPosition = packet.chainPosition();
                    if (packet.removingPackage()) {

                        float bestDiff = Float.POSITIVE_INFINITY;
                        ChainConveyorPackage best = null;
                        List<ChainConveyorPackage> list = selectedConnection.equals(class_2338.field_11176) ? be.getLoopingPackages() : be.getTravellingPackages()
                            .get(selectedConnection);

                        if (list == null || list.isEmpty())
                            return true;

                        for (ChainConveyorPackage liftPackage : list) {
                            float diff = Math.abs(selectedConnection == null ? AngleHelper.getShortestAngleDiff(
                                liftPackage.chainPosition,
                                chainPosition
                            ) : liftPackage.chainPosition - chainPosition);
                            if (diff > bestDiff)
                                continue;
                            bestDiff = diff;
                            best = liftPackage;
                        }

                        if (player.method_6047().method_7960()) {
                            player.method_6122(class_1268.field_5808, best.item.method_7972());
                        } else {
                            player.method_31548().method_7398(best.item.method_7972());
                        }

                        list.remove(best);
                        be.sendData();
                    } else {
                        ChainConveyorPackage chainConveyorPackage = new ChainConveyorPackage(chainPosition, player.method_6047().method_7972());
                        if (!be.canAcceptPackagesFor(selectedConnection))
                            return true;

                        if (!player.method_68878()) {
                            player.method_6047().method_7934(1);
                            if (player.method_6047().method_7960()) {
                                player.method_6122(class_1268.field_5808, class_1799.field_8037);
                            }
                        }

                        if (selectedConnection.equals(class_2338.field_11176)) {
                            be.addLoopingPackage(chainConveyorPackage);
                        } else {
                            be.addTravellingPackage(chainConveyorPackage, selectedConnection);
                        }
                    }
                    return true;
                }
                return false;
            }
        );
    }

    public static void onPackagePortConfiguration(class_3244 listener, PackagePortConfigurationPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof PackagePortBlockEntity be) {
                    if (be.addressFilter.equals(packet.newFilter()) && be.acceptsPackages == packet.acceptPackages())
                        return true;
                    be.addressFilter = packet.newFilter();
                    be.acceptsPackages = packet.acceptPackages();
                    be.filterChanged();
                    return true;
                }
                return false;
            }
        );
    }

    public static void onFactoryPanelConnection(class_3244 listener, FactoryPanelConnectionPacket packet) {
        class_3222 player = listener.field_14140;
        onBlockEntityConfiguration(
            listener, packet.toPos().pos(), 40, blockEntity -> {
                if (blockEntity instanceof FactoryPanelBlockEntity be) {
                    ServerFactoryPanelBehaviour behaviour = ServerFactoryPanelBehaviour.at(be.method_10997(), packet.toPos());
                    if (behaviour != null)
                        if (packet.relocate())
                            behaviour.moveTo(packet.fromPos(), player);
                        else
                            behaviour.addConnection(packet.fromPos());
                    return true;
                }
                return false;
            }
        );
    }

    public static void onFactoryPanelConfiguration(class_3244 listener, FactoryPanelConfigurationPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.position().pos(), 20, blockEntity -> {
                if (blockEntity instanceof FactoryPanelBlockEntity be) {
                    ServerFactoryPanelBehaviour behaviour = be.panels.get(packet.position().slot());
                    if (behaviour == null)
                        return false;

                    boolean reset = packet.reset();
                    behaviour.recipeAddress = reset ? "" : packet.address();
                    behaviour.recipeOutput = reset ? 1 : packet.outputAmount();
                    behaviour.promiseClearingInterval = reset ? -1 : packet.promiseClearingInterval();
                    behaviour.activeCraftingArrangement = reset ? List.of() : packet.craftingArrangement();

                    if (reset) {
                        behaviour.forceClearPromises = true;
                        behaviour.disconnectAll();
                        behaviour.setFilter(class_1799.field_8037);
                        behaviour.count = 0;
                        be.redraw = true;
                        return true;
                    }

                    if (packet.redstoneReset()) {
                        behaviour.disconnectAllLinks();
                        return true;
                    }

                    for (Map.Entry<FactoryPanelPosition, Integer> entry : packet.inputAmounts().entrySet()) {
                        FactoryPanelPosition key = entry.getKey();
                        FactoryPanelConnection connection = behaviour.targetedBy.get(key);
                        if (connection != null)
                            connection.amount = entry.getValue();
                    }

                    FactoryPanelPosition removeConnection = packet.removeConnection();
                    if (removeConnection != null) {
                        behaviour.targetedBy.remove(removeConnection);
                        behaviour.searchForCraftingRecipe();
                        ServerFactoryPanelBehaviour source = ServerFactoryPanelBehaviour.at(be.method_10997(), removeConnection);
                        if (source != null) {
                            source.targeting.remove(behaviour.getPanelPosition());
                            source.blockEntity.sendData();
                        }
                    }

                    if (packet.clearPromises())
                        behaviour.forceClearPromises = true;

                    return true;
                }
                return false;
            }
        );
    }

    public static void onRedstoneRequesterConfiguration(class_3244 listener, RedstoneRequesterConfigurationPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof RedstoneRequesterBlockEntity be) {
                    be.encodedTargetAdress = packet.address();
                    List<BigItemStack> stacks = be.encodedRequest.stacks();
                    List<Integer> amounts = packet.amounts();
                    for (int i = 0; i < stacks.size() && i < amounts.size(); i++) {
                        class_1799 stack = stacks.get(i).stack;
                        if (!stack.method_7960())
                            stacks.set(i, new BigItemStack(stack, amounts.get(i)));
                    }
                    if (!be.encodedRequest.orderedStacksMatchOrderedRecipes())
                        be.encodedRequest = PackageOrderWithCrafts.simple(be.encodedRequest.stacks());
                    be.allowPartialRequests = packet.allowPartial();
                    return true;
                }
                return false;
            }
        );
    }

    public static void onStockKeeperCategoryEdit(class_3244 listener, StockKeeperCategoryEditPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof StockTickerBlockEntity be) {
                    be.categories = packet.schedule();
                    return true;
                }
                return false;
            }
        );
    }

    public static void onStockKeeperCategoryRefund(class_3244 listener, StockKeeperCategoryRefundPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof StockTickerBlockEntity be) {
                    class_1799 filter = packet.filter();
                    if (!filter.method_7960() && filter.method_7909() instanceof FilterItem)
                        listener.field_14140.method_31548().method_7398(filter);
                    return true;
                }
                return false;
            }
        );
    }

    public static void onStockKeeperLock(class_3244 listener, StockKeeperLockPacket packet) {
        class_3222 player = listener.field_14140;
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof StockTickerBlockEntity be) {
                    if (!be.behaviour.mayAdministrate(player))
                        return true;
                    LogisticsNetwork network = Create.LOGISTICS.logisticsNetworks.get(be.behaviour.freqId);
                    if (network != null) {
                        network.locked = packet.lock();
                        Create.LOGISTICS.markDirty();
                    }
                    return true;
                }
                return false;
            }
        );
    }

    public static void onStockKeeperCategoryHiding(class_3244 listener, StockKeeperCategoryHidingPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof StockTickerBlockEntity be) {
                    if (packet.indices().isEmpty()) {
                        be.hiddenCategoriesByPlayer.remove(listener.field_14140.method_5667());
                        return false;
                    } else {
                        be.hiddenCategoriesByPlayer.put(listener.field_14140.method_5667(), packet.indices());
                    }
                    return true;
                }
                return false;
            }
        );
    }

    public static void onSchematicPlace(class_3244 listener, SchematicPlacePacket packet) {
        class_3222 player = listener.field_14140;
        if (!player.method_68878()) {
            return;
        }
        class_3218 world = player.method_51469();
        SchematicPrinter printer = new SchematicPrinter();
        printer.loadSchematic(packet.stack(), world, !player.method_7338());
        if (!printer.isLoaded() || printer.isErrored()) {
            return;
        }

        boolean includeAir = AllConfigs.server().schematics.creativePrintIncludesAir.get();

        while (printer.advanceCurrentPos()) {
            if (!printer.shouldPlaceCurrent(world)) {
                continue;
            }

            printer.handleCurrentTarget(
                (pos, state, blockEntity) -> {
                    boolean placingAir = state.method_26215();
                    if (placingAir && !includeAir) {
                        return;
                    }

                    class_2487 data = BlockHelper.prepareBlockEntityData(world, state, blockEntity);
                    BlockHelper.placeSchematicBlock(world, state, pos, null, data);
                }, (pos, entity) -> {
                    world.method_8649(entity);
                }
            );
        }
    }

    public static void onSchematicUpload(class_3244 listener, SchematicUploadPacket packet) {
        class_3222 player = listener.field_14140;
        String schematic = packet.schematic();
        if (packet.code() == SchematicUploadPacket.BEGIN) {
            class_2338 pos = ((SchematicTableMenu) player.field_7512).contentHolder.method_11016();
            Create.SCHEMATIC_RECEIVER.handleNewUpload(player, schematic, packet.size(), pos);
        } else if (packet.code() == SchematicUploadPacket.WRITE) {
            Create.SCHEMATIC_RECEIVER.handleWriteRequest(player, schematic, packet.data());
        } else {
            Create.SCHEMATIC_RECEIVER.handleFinishedUpload(player, schematic);
        }
    }

    public static void onClearContainer(class_3244 listener) {
        if (!(listener.field_14140.field_7512 instanceof IClearableMenu menu))
            return;
        menu.clearContents();
    }

    public static void onFilterScreen(class_3244 serverPlayNetworkHandler, FilterScreenPacket packet) {
        class_3222 player = serverPlayNetworkHandler.field_14140;
        class_2487 tag = packet.data() == null ? new class_2487() : packet.data();
        FilterScreenPacket.Option option = packet.option();

        if (player.field_7512 instanceof FilterMenu c) {
            if (option == FilterScreenPacket.Option.WHITELIST)
                c.blacklist = false;
            if (option == FilterScreenPacket.Option.BLACKLIST)
                c.blacklist = true;
            if (option == FilterScreenPacket.Option.RESPECT_DATA)
                c.respectNBT = true;
            if (option == FilterScreenPacket.Option.IGNORE_DATA)
                c.respectNBT = false;
            if (option == FilterScreenPacket.Option.UPDATE_FILTER_ITEM)
                c.ghostInventory.method_5447(tag.method_68083("Slot", 0), tag.method_67491("Item", class_1799.field_24671).orElse(class_1799.field_8037));
        } else if (player.field_7512 instanceof AttributeFilterMenu c) {
            if (option == FilterScreenPacket.Option.WHITELIST)
                c.whitelistMode = AttributeFilterWhitelistMode.WHITELIST_DISJ;
            if (option == FilterScreenPacket.Option.WHITELIST2)
                c.whitelistMode = AttributeFilterWhitelistMode.WHITELIST_CONJ;
            if (option == FilterScreenPacket.Option.BLACKLIST)
                c.whitelistMode = AttributeFilterWhitelistMode.BLACKLIST;
            if (option == FilterScreenPacket.Option.ADD_TAG)
                c.appendSelectedAttribute(ItemAttribute.loadStatic(packet.data(), player.method_56673()), false);
            if (option == FilterScreenPacket.Option.ADD_INVERTED_TAG)
                c.appendSelectedAttribute(ItemAttribute.loadStatic(packet.data(), player.method_56673()), true);
        } else if (player.field_7512 instanceof PackageFilterMenu c) {
            if (option == FilterScreenPacket.Option.UPDATE_ADDRESS)
                c.address = tag.method_68564("Address", "");
        }
    }

    public static void onContraptionInteraction(class_3244 listener, ContraptionInteractionPacket packet) {
        class_3222 sender = listener.field_14140;
        class_1297 entityByID = sender.method_51469().method_8469(packet.target());
        if (!(entityByID instanceof AbstractContraptionEntity contraptionEntity))
            return;
        class_238 bb = contraptionEntity.method_5829();
        double boundsExtra = Math.max(bb.method_17939(), bb.method_17940());
        double d = sender.method_45325(class_5134.field_47758) + 10 + boundsExtra;
        if (!sender.method_6057(entityByID))
            d -= 3;
        d *= d;
        if (sender.method_5858(entityByID) > d)
            return;
        if (contraptionEntity.handlePlayerInteraction(sender, packet.localPos(), packet.face(), packet.hand()))
            sender.method_23667(packet.hand(), true);
    }

    public static void onClientMotion(class_3244 listener, ClientMotionPacket packet) {
        class_3222 sender = listener.field_14140;
        sender.method_18799(packet.motion());
        sender.method_24830(packet.onGround());
        if (packet.onGround()) {
            sender.method_5747(sender.field_6017, 1, sender.method_48923().method_48827());
            sender.field_6017 = 0;
            sender.field_13987.field_14138 = 0;
            sender.field_13987.field_14137 = 0;
        }
        sender.method_51469().method_14178()
            .method_18754(sender, new LimbSwingUpdatePacket(sender.method_5628(), sender.method_73189(), packet.limbSwing()));
    }

    public static void onArmPlacement(class_3244 listener, ArmPlacementPacket packet) {
        class_1937 world = listener.field_14140.method_51469();
        if (!world.method_8477(packet.pos()))
            return;
        class_2586 blockEntity = world.method_8321(packet.pos());
        if (!(blockEntity instanceof ArmBlockEntity arm))
            return;

        arm.interactionPointTag = packet.tag();
    }

    public static void onPackagePortPlacement(class_3244 listener, PackagePortPlacementPacket packet) {
        class_1937 world = listener.field_14140.method_51469();
        class_2338 pos = packet.pos();
        if (world == null || !world.method_8477(pos))
            return;
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof PackagePortBlockEntity ppbe))
            return;
        PackagePortTarget target = packet.target();
        if (!target.canSupport(ppbe))
            return;

        class_243 targetLocation = target.getExactTargetLocation(ppbe, world, pos);
        if (targetLocation == class_243.field_1353 || !targetLocation.method_24802(
            class_243.method_24955(pos),
            AllConfigs.server().logistics.packagePortRange.get() + 2
        ))
            return;

        target.setup(ppbe, world, pos);
        ppbe.target = target;
        ppbe.notifyUpdate();
        ppbe.use(listener.field_14140);
    }

    public static void onCouplingCreation(class_3244 listener, CouplingCreationPacket packet) {
        CouplingHandler.tryToCoupleCarts(listener.field_14140, listener.field_14140.method_51469(), packet.id1(), packet.id2());
    }

    public static void onInstantSchematic(class_3244 listener, InstantSchematicPacket packet) {
        Create.SCHEMATIC_RECEIVER.handleInstantSchematic(
            listener.field_14140,
            packet.name(),
            listener.field_14140.method_51469(),
            packet.origin(),
            packet.bounds()
        );
    }

    public static void onSchematicSync(class_3244 listener, SchematicSyncPacket packet) {
        class_3222 player = listener.field_14140;
        class_1799 stack;
        if (packet.slot() == -1) {
            stack = player.method_6047();
        } else {
            stack = player.method_31548().method_5438(packet.slot());
        }
        if (!stack.method_31574(AllItems.SCHEMATIC)) {
            return;
        }
        stack.method_57379(AllDataComponents.SCHEMATIC_DEPLOYED, packet.deployed());
        stack.method_57379(AllDataComponents.SCHEMATIC_ANCHOR, packet.anchor());
        stack.method_57379(AllDataComponents.SCHEMATIC_ROTATION, packet.rotation());
        stack.method_57379(AllDataComponents.SCHEMATIC_MIRROR, packet.mirror());
        SchematicInstances.clearHash(stack);
    }

    public static void onLeftClick(class_3244 listener) {
        class_3222 player = listener.field_14140;
        class_1799 stack = player.method_6047();
        if (stack.method_7909() instanceof ZapperItem) {
            ZapperInteractionHandler.trySelect(stack, player);
        }
    }

    public static void onEjectorPlacement(class_3244 listener, EjectorPlacementPacket packet) {
        class_3218 world = listener.field_14140.method_51469();
        class_2338 pos = packet.pos();
        if (!world.method_8477(pos))
            return;
        class_2586 blockEntity = world.method_8321(pos);
        class_2680 state = world.method_8320(pos);
        if (blockEntity instanceof EjectorBlockEntity ejector)
            ejector.setTarget(packet.h(), packet.v());
        if (state.method_27852(AllBlocks.WEIGHTED_EJECTOR))
            world.method_8501(pos, state.method_11657(EjectorBlock.HORIZONTAL_FACING, packet.facing()));
    }

    public static void onEjectorElytra(class_3244 listener, EjectorElytraPacket packet) {
        class_3218 world = listener.field_14140.method_51469();
        if (!world.method_8477(packet.pos()))
            return;
        class_2586 blockEntity = world.method_8321(packet.pos());
        if (blockEntity instanceof EjectorBlockEntity ejector)
            ejector.deployElytra(listener.field_14140);
    }

    private static void onLinkedController(class_3222 player, class_2338 pos, Consumer<class_2586> onLectern, Consumer<class_1799> onStack) {
        if (pos != null) {
            if (onLectern != null) {
                onLectern.accept(player.method_51469().method_8321(pos));
            }
        } else if (onStack != null) {
            class_1799 controller = player.method_6047();
            if (!controller.method_31574(AllItems.LINKED_CONTROLLER)) {
                controller = player.method_6079();
                if (!controller.method_31574(AllItems.LINKED_CONTROLLER))
                    return;
            }
            onStack.accept(controller);
        }
    }

    public static void onLinkedControllerInput(class_3244 listener, LinkedControllerInputPacket packet) {
        class_3222 player = listener.field_14140;
        Consumer<class_1799> handleItem = stack -> {
            class_3218 world = player.method_51469();
            UUID uniqueID = player.method_5667();
            class_2338 pos = player.method_24515();

            if (player.method_7325() && packet.press())
                return;

            LinkedControllerServerHandler.receivePressed(
                world,
                pos,
                uniqueID,
                packet.activatedButtons().stream().map(i -> LinkedControllerItem.toFrequency(stack, i)).collect(Collectors.toList()),
                packet.press()
            );
        };
        onLinkedController(
            player, packet.lecternPos(), blockEntity -> {
                if (blockEntity instanceof LecternControllerBlockEntity lectern) {
                    if (lectern.isUsedBy(player))
                        handleItem.accept(lectern.getController());
                }
            }, handleItem
        );
    }

    public static void onLinkedControllerBind(class_3244 listener, LinkedControllerBindPacket packet) {
        class_3222 player = listener.field_14140;
        if (player.method_7325()) {
            return;
        }
        onLinkedController(
            player, null, null, stack -> {
                ItemStackHandler frequencyItems = LinkedControllerItem.getFrequencyItems(stack);
                ServerLinkBehaviour linkBehaviour = BlockEntityBehaviour.get(
                    player.method_51469(),
                    packet.linkLocation(),
                    ServerLinkBehaviour.TYPE
                );
                if (linkBehaviour == null)
                    return;

                int button = packet.button();
                linkBehaviour.getNetworkKey()
                    .forEachWithContext((f, first) -> frequencyItems.method_5447(button * 2 + (first ? 0 : 1), f.getStack().method_7972()));

                stack.method_57379(AllDataComponents.LINKED_CONTROLLER_ITEMS, ItemHelper.containerContentsFromHandler(frequencyItems));
            }
        );
    }

    public static void onLinkedControllerStopLectern(class_3244 listener, LinkedControllerStopLecternPacket packet) {
        class_3222 player = listener.field_14140;
        onLinkedController(
            player, packet.lecternPos(), blockEntity -> {
                if (blockEntity instanceof LecternControllerBlockEntity lectern) {
                    lectern.tryStopUsing(player);
                }
            }, null
        );
    }

    public static void onGhostItemSubmit(class_3244 listener, GhostItemSubmitPacket packet) {
        class_1703 containerMenu = listener.field_14140.field_7512;
        int slot = packet.slot();
        class_1799 item = packet.item();
        if (containerMenu instanceof GhostItemMenu<?> menu) {
            menu.ghostInventory.method_5447(slot, item);
            menu.method_7611(36 + slot).method_7668();
        } else if (containerMenu instanceof StockKeeperCategoryMenu menu && (item.method_7960() || item.method_7909() instanceof FilterItem)) {
            menu.proxyInventory.method_5447(slot, item);
            menu.method_7611(36 + slot).method_7668();
        }
    }

    public static void onBlueprintAssignCompleteRecipe(class_3244 listener, BlueprintAssignCompleteRecipePacket packet) {
        class_3222 player = listener.field_14140;
        if (player.field_7512 instanceof BlueprintMenu c) {
            class_1863.class_10288 serverRecipe = listener.field_45012.method_3772().method_64686(packet.recipeId());
            if (serverRecipe != null) {
                //TODO
                //                BlueprintItem.assignCompleteRecipe(player.getWorld(), c.ghostInventory, serverRecipe.parent().value());
            }
        }
    }

    public static void onConfigureSymmetryWand(class_3244 listener, ConfigureSymmetryWandPacket packet) {
        class_1799 stack = listener.field_14140.method_5998(packet.hand());
        if (stack.method_7909() instanceof SymmetryWandItem) {
            SymmetryWandItem.configureSettings(stack, packet.mirror());
        }
    }

    public static void onConfigureWorldshaper(class_3244 listener, ConfigureWorldshaperPacket packet) {
        class_1799 stack = listener.field_14140.method_5998(packet.hand());
        if (stack.method_7909() instanceof ZapperItem) {
            packet.configureZapper(stack);
        }
    }

    public static void onToolboxEquip(class_3244 listener, ToolboxEquipPacket packet) {
        class_3222 player = listener.field_14140;
        class_2338 toolboxPos = packet.toolboxPos();
        int slot = packet.slot();
        int hotbarSlot = packet.hotbarSlot();
        if (toolboxPos == null) {
            ToolboxHandler.unequip(player, hotbarSlot, false);
            ToolboxHandler.syncData(player, AllSynchedDatas.TOOLBOX.get(player));
            return;
        }
        class_3218 world = player.method_51469();
        class_2586 blockEntity = world.method_8321(toolboxPos);
        double maxRange = ToolboxHandler.getMaxRange(player);
        if (player.method_5649(toolboxPos.method_10263() + 0.5, toolboxPos.method_10264(), toolboxPos.method_10260() + 0.5) > maxRange * maxRange)
            return;
        if (!(blockEntity instanceof ToolboxBlockEntity toolboxBlockEntity))
            return;

        ToolboxHandler.unequip(player, hotbarSlot, false);

        if (slot < 0 || slot >= 8) {
            ToolboxHandler.syncData(player, AllSynchedDatas.TOOLBOX.get(player));
            return;
        }

        class_1661 playerInventory = player.method_31548();
        class_1799 playerStack = playerInventory.method_5438(hotbarSlot);
        if (!playerStack.method_7960() && !ToolboxInventory.canItemsShareCompartment(playerStack, toolboxBlockEntity.inventory.filters.get(slot))) {
            toolboxBlockEntity.inventory.inLimitedMode(inventory -> {
                int count = playerStack.method_7947();
                int insert = inventory.insertExist(playerStack);
                if (insert != count) {
                    count -= insert;
                    insert = playerInventory.insert(playerStack, count, class_1661.method_7368(), class_1661.field_30638);
                }
                if (insert == count) {
                    playerInventory.method_5447(hotbarSlot, class_1799.field_8037);
                } else {
                    playerStack.method_7939(count - insert);
                }
            });
        }

        class_2487 compound = AllSynchedDatas.TOOLBOX.get(player);
        String key = String.valueOf(hotbarSlot);

        class_2487 data = new class_2487();
        data.method_10569("Slot", slot);
        data.method_67494("Pos", class_2338.field_25064, toolboxPos);
        compound.method_10566(key, data);

        toolboxBlockEntity.connectPlayer(slot, player, hotbarSlot);
        ToolboxHandler.syncData(player, compound);
    }

    public static void onToolboxDisposeAll(class_3244 listener, ToolboxDisposeAllPacket packet) {
        class_3222 player = listener.field_14140;
        class_3218 world = player.method_51469();
        class_2338 toolboxPos = packet.toolboxPos();
        class_2586 blockEntity = world.method_8321(toolboxPos);

        double maxRange = ToolboxHandler.getMaxRange(player);
        if (player.method_5649(toolboxPos.method_10263() + 0.5, toolboxPos.method_10264(), toolboxPos.method_10260() + 0.5) > maxRange * maxRange)
            return;
        if (!(blockEntity instanceof ToolboxBlockEntity toolbox))
            return;

        class_2487 compound = AllSynchedDatas.TOOLBOX.get(player);
        MutableBoolean sendData = new MutableBoolean(false);

        class_1661 playerInventory = player.method_31548();
        toolbox.inventory.inLimitedMode(inventory -> {
            for (int i = 0; i < 36; i++) {
                if (compound.method_10562(String.valueOf(i)).flatMap(nbt -> nbt.method_67491("Pos", class_2338.field_25064)).map(pos -> pos.equals(toolboxPos))
                    .orElse(false)) {
                    ToolboxHandler.unequip(player, i, true);
                    sendData.setTrue();
                }

                class_1799 itemStack = playerInventory.method_5438(i);
                int count = itemStack.method_7947();
                if (count == 0) {
                    continue;
                }
                int insert = toolbox.inventory.insertExist(itemStack, count);
                if (insert == count) {
                    playerInventory.method_5447(i, class_1799.field_8037);
                } else {
                    itemStack.method_7939(count - insert);
                }
            }
        });

        if (sendData.booleanValue())
            ToolboxHandler.syncData(player, compound);
    }

    public static void onScheduleEdit(class_3244 listener, ScheduleEditPacket packet) {
        class_3222 sender = listener.field_14140;
        class_1799 mainHandItem = sender.method_6047();
        if (!mainHandItem.method_31574(AllItems.SCHEDULE))
            return;

        if (packet.schedule().entries.isEmpty()) {
            mainHandItem.method_57381(AllDataComponents.TRAIN_SCHEDULE);
        } else {
            try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "ScheduleEdit", Create.LOGGER)) {
                class_11362 view = class_11362.method_71459(logging, sender.method_56673());
                packet.schedule().write(view);
                mainHandItem.method_57379(AllDataComponents.TRAIN_SCHEDULE, view.method_71475());
            }
        }

        sender.method_7357().method_62835(mainHandItem, 5);
    }

    public static void onTrainEdit(class_3244 listener, TrainEditPacket packet) {
        class_3222 sender = listener.field_14140;
        class_3218 world = sender.method_51469();
        Train train = Create.RAILWAYS.sided(world).trains.get(packet.id());
        if (train == null)
            return;
        if (!packet.name().isBlank()) {
            train.name = class_2561.method_43470(packet.name());
        }
        train.icon = TrainIconType.byId(packet.iconType());
        train.mapColorIndex = packet.mapColor();
        listener.field_45012.method_3760().method_14581(new TrainEditReturnPacket(packet.id(), packet.name(), packet.iconType(), packet.mapColor()));
    }

    public static void onTrainRelocation(class_3244 listener, TrainRelocationPacket packet) {
        class_3222 sender = listener.field_14140;
        Train train = Create.RAILWAYS.trains.get(packet.trainId());
        class_1297 entity = sender.method_51469().method_8469(packet.entityId());

        String messagePrefix = sender.method_5477().getString() + " could not relocate Train ";

        if (train == null || !(entity instanceof CarriageContraptionEntity cce)) {
            Create.LOGGER.warn(messagePrefix + train.id.toString().substring(0, 5) + ": not present on server");
            return;
        }

        if (!train.id.equals(cce.trainId))
            return;

        int verifyDistance = AllConfigs.server().trains.maxTrackPlacementLength.get() * 2;
        if (!sender.method_73189().method_24802(class_243.method_24953(packet.pos()), verifyDistance)) {
            Create.LOGGER.warn(messagePrefix + train.name.getString() + ": player too far from clicked pos");
            return;
        }
        if (!sender.method_73189().method_24802(cce.method_73189(), verifyDistance + cce.method_5829().method_17939() / 2)) {
            Create.LOGGER.warn(messagePrefix + train.name.getString() + ": player too far from carriage entity");
            return;
        }

        if (TrainRelocator.relocate(
            train,
            sender.method_51469(),
            packet.pos(),
            packet.hoveredBezier(),
            packet.direction(),
            packet.lookAngle(),
            null
        )) {
            sender.method_7353(class_2561.method_43471("create.train.relocate.success").method_27692(class_124.field_1060), true);
            train.carriages.forEach(c -> c.forEachPresentEntity(e -> {
                e.nonDamageTicks = 10;
                listener.field_14140.method_51469().method_14178().method_18754(e, new ContraptionRelocationPacket(e.method_5628()));
            }));
            return;
        }

        Create.LOGGER.warn(messagePrefix + train.name.getString() + ": relocation failed server-side");
    }

    public static void onControlsInput(class_3244 listener, ControlsInputPacket packet) {
        class_3222 player = listener.field_14140;
        class_3218 world = player.method_51469();
        UUID uniqueID = player.method_5667();

        if (player.method_7325() && packet.press())
            return;

        class_1297 entity = world.method_8469(packet.contraptionEntityId());
        if (!(entity instanceof AbstractContraptionEntity ace))
            return;
        if (packet.stopControlling()) {
            ace.stopControlling(packet.controlsPos());
            return;
        }

        if (ace.toGlobalVector(class_243.method_24953(packet.controlsPos()), 0).method_24802(player.method_73189(), 16))
            ControlsServerHandler.receivePressed(world, ace, packet.controlsPos(), uniqueID, packet.activatedButtons(), packet.press());
    }

    public static void onPlaceExtendedCurve(class_3244 listener, PlaceExtendedCurvePacket packet) {
        class_1799 stack = listener.field_14140.method_5998(packet.mainHand() ? class_1268.field_5808 : class_1268.field_5810);
        if (!stack.method_31573(AllItemTags.TRACKS))
            return;
        stack.method_57379(AllDataComponents.TRACK_EXTENDED_CURVE, true);
    }

    public static void onSuperGlueSelection(class_3244 listener, SuperGlueSelectionPacket packet) {
        class_3222 player = listener.field_14140;
        class_3218 world = player.method_51469();
        double range = player.method_45325(class_5134.field_47758) + 2;
        class_2338 to = packet.to();
        if (player.method_5707(class_243.method_24953(to)) > range * range)
            return;
        class_2338 from = packet.from();
        if (!to.method_19771(from, 25))
            return;

        Set<class_2338> group = SuperGlueSelectionHelper.searchGlueGroup(world, from, to, false);
        if (group == null)
            return;
        if (!group.contains(to))
            return;
        if (!SuperGlueSelectionHelper.collectGlueFromInventory(player, 1, true))
            return;

        class_238 bb = SuperGlueEntity.span(from, to);
        SuperGlueSelectionHelper.collectGlueFromInventory(player, 1, false);
        SuperGlueEntity entity = new SuperGlueEntity(world, bb);
        world.method_8649(entity);
        entity.spawnParticles();

        AllAdvancements.SUPER_GLUE.trigger(player);
    }

    public static void onSuperGlueRemoval(class_3244 listener, SuperGlueRemovalPacket packet) {
        class_3222 player = listener.field_14140;
        class_3218 world = player.method_51469();
        class_1297 entity = world.method_8469(packet.entityId());
        if (!(entity instanceof SuperGlueEntity superGlue))
            return;
        double range = 32;
        if (player.method_5707(superGlue.method_73189()) > range * range)
            return;
        AllSoundEvents.SLIME_ADDED.play(world, null, packet.soundSource(), 0.5F, 0.5F);
        superGlue.spawnParticles();
        entity.method_31472();
    }

    public static void onTrainCollision(class_3244 listener, TrainCollisionPacket packet) {
        class_3222 player = listener.field_14140;
        class_3218 world = player.method_51469();
        class_1297 entity = world.method_8469(packet.contraptionEntityId());
        if (!(entity instanceof CarriageContraptionEntity cce))
            return;

        player.method_64397(world, AllDamageSources.get(world).runOver(cce), packet.damage());
        world.method_8396(player, entity.method_24515(), class_3417.field_15016, class_3419.field_15254, 1, .75f);
    }

    public static void onTrainHUDUpdate(class_3244 listener, TrainHUDUpdatePacket packet) {
        class_3222 player = listener.field_14140;
        Train train = Create.RAILWAYS.sided(player.method_51469()).trains.get(packet.trainId());
        if (train == null)
            return;

        if (packet.throttle() != null)
            train.throttle = packet.throttle();
    }

    public static void onTrainHonk(class_3244 listener, HonkPacket packet) {
        class_3222 player = listener.field_14140;
        Train train = Create.RAILWAYS.sided(player.method_51469()).trains.get(packet.trainId());
        if (train == null)
            return;

        AllAdvancements.TRAIN_WHISTLE.trigger(player);
        listener.field_45012.method_3760().method_14581(new HonkReturnPacket(train, packet.isHonk()));
    }

    public static void onTrackGraphRequest(class_3244 listener, TrackGraphRequestPacket packet) {
        class_3222 player = listener.field_14140;
        int netId = packet.netId();
        for (TrackGraph trackGraph : Create.RAILWAYS.trackNetworks.values()) {
            if (trackGraph.netId == netId) {
                Create.RAILWAYS.sync.sendFullGraphTo(trackGraph, player);
                break;
            }
        }
    }

    public static void onElevatorRequestFloorList(class_3244 listener, RequestFloorListPacket packet) {
        class_1297 entityByID = listener.field_14140.method_51469().method_8469(packet.entityId());
        if (!(entityByID instanceof AbstractContraptionEntity ace))
            return;
        if (!(ace.getContraption() instanceof ElevatorContraption ec))
            return;
        listener.method_14364(new ElevatorFloorListPacket(ace, ec.namesList));
    }

    public static void onElevatorTargetFloor(class_3244 listener, ElevatorTargetFloorPacket packet) {
        class_3222 sender = listener.field_14140;
        class_3218 world = sender.method_51469();
        class_1297 entityByID = world.method_8469(packet.entityId());
        if (!(entityByID instanceof AbstractContraptionEntity ace))
            return;
        if (!(ace.getContraption() instanceof ElevatorContraption ec))
            return;
        if (ace.method_5858(sender) > 50 * 50)
            return;

        ElevatorColumn elevatorColumn = ElevatorColumn.get(world, ec.getGlobalColumn());
        if (elevatorColumn == null) {
            return;
        }
        int targetY = packet.targetY();
        if (!elevatorColumn.contacts.contains(targetY))
            return;
        if (ec.isTargetUnreachable(targetY))
            return;

        class_2338 pos = elevatorColumn.contactAt(targetY);
        class_2680 blockState = world.method_8320(pos);
        if (!(blockState.method_26204() instanceof ElevatorContactBlock ecb))
            return;

        ecb.callToContactAndUpdate(elevatorColumn, blockState, world, pos, false);
    }

    public static void onClipboardEdit(class_3244 listener, ClipboardEditPacket packet) {
        class_3222 sender = listener.field_14140;
        ClipboardContent processedContent = clipboardProcessor(packet.clipboardContent());

        class_2338 targetedBlock = packet.targetedBlock();
        if (targetedBlock != null) {
            class_3218 world = sender.method_51469();
            if (!world.method_8477(targetedBlock))
                return;
            if (!targetedBlock.method_19771(sender.method_24515(), 20))
                return;
            if (world.method_8321(targetedBlock) instanceof ClipboardBlockEntity cbe) {
                class_9335 map = new class_9335(cbe.method_58693());
                if (processedContent == null) {
                    map.method_57939(AllDataComponents.CLIPBOARD_CONTENT);
                } else {
                    map.method_57938(AllDataComponents.CLIPBOARD_CONTENT, processedContent);
                }
                cbe.method_58684(map);
                cbe.onEditedBy(sender);
            }
            return;
        }

        class_1799 itemStack = sender.method_31548().method_5438(packet.hotbarSlot());
        if (!itemStack.method_31574(AllItems.CLIPBOARD))
            return;
        if (processedContent == null) {
            itemStack.method_57381(AllDataComponents.CLIPBOARD_CONTENT);
        } else {
            itemStack.method_57379(AllDataComponents.CLIPBOARD_CONTENT, processedContent);
        }
    }

    private static ClipboardContent clipboardProcessor(@Nullable ClipboardContent content) {
        if (content == null)
            return null;

        for (List<ClipboardEntry> page : content.pages()) {
            for (ClipboardEntry entry : page) {
                if (NBTProcessors.textComponentHasClickEvent(entry.text))
                    return null;
            }
        }

        return content;
    }

    public static void onContraptionColliderLockRequest(class_3244 listener, ContraptionColliderLockPacketRequest packet) {
        class_3222 player = listener.field_14140;
        player.method_51469().method_14178()
            .method_18754(player, new ContraptionColliderLockPacket(packet.contraption(), packet.offset(), player.method_5628()));
    }

    public static void onRadialWrenchMenuSubmit(class_3244 listener, RadialWrenchMenuSubmitPacket packet) {
        class_3218 world = listener.field_14140.method_51469();
        class_2338 blockPos = packet.blockPos();
        class_2680 newState = packet.newState();
        if (!world.method_8320(blockPos).method_27852(newState.method_26204()))
            return;

        class_2680 updatedState = class_2248.method_9510(newState, world, blockPos);
        KineticBlockEntity.switchToBlockState(world, blockPos, updatedState);

        IWrenchable.playRotateSound(world, blockPos);
    }

    public static void onTrainMapSyncRequest(class_3244 listener) {
    }

    public static void onLinkSettings(class_3244 listener, LinkSettingsPacket packet) {
        onBlockEntityConfiguration(
            listener, packet.pos(), 20, blockEntity -> {
                if (blockEntity instanceof SmartBlockEntity be) {
                    ServerLinkBehaviour behaviour = be.getBehaviour(ServerLinkBehaviour.TYPE);
                    if (behaviour != null) {
                        behaviour.setFrequency(packet.first(), listener.field_14140.method_5998(packet.hand()));
                        return true;
                    }
                }
                return false;
            }
        );
    }

    public static void onBlueprintPreviewRequest(class_3244 listener, BlueprintPreviewRequestPacket packet) {
        class_1297 entity = listener.field_14140.method_51469().method_8469(packet.entityId());
        if (!(entity instanceof BlueprintEntity blueprint)) {
            listener.method_14364(BlueprintPreviewPacket.EMPTY);
            return;
        }
        listener.method_14364(BlueprintEntity.getPreview(blueprint, packet.index(), listener.field_14140, packet.sneaking()));
    }
}
