package com.zurrtum.create.api.behaviour.display;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public interface DisplayHolder {
    class_2487 getDisplayLinkData();

    void setDisplayLinkData(class_2487 data);

    default void updateLine(int line, class_2338 pos) {
        class_2487 data = getDisplayLinkData();
        if (data == null) {
            data = new class_2487();
            setDisplayLinkData(data);
        }
        data.method_67494("Line" + line, class_2338.field_25064, pos);
    }

    @Nullable
    default class_2338 getLine(int line) {
        class_2487 data = getDisplayLinkData();
        if (data == null) {
            return null;
        }
        return data.method_67491("Line" + line, class_2338.field_25064).orElse(null);
    }

    default void removeLine(int line) {
        class_2487 data = getDisplayLinkData();
        if (data == null) {
            return;
        }
        data.method_10551("Line" + line);
        if (data.method_33133()) {
            setDisplayLinkData(null);
        }
    }

    default void writeDisplayLink(class_11372 view) {
        class_2487 data = getDisplayLinkData();
        if (data == null) {
            return;
        }
        view.method_71468("DisplayLink", class_2487.field_25128, data);
    }

    default void readDisplayLink(class_11368 view) {
        class_2487 data = view.method_71426("DisplayLink", class_2487.field_25128).orElse(null);
        setDisplayLinkData(data);
    }
}
