package com.zurrtum.create.api.connectivity;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.zurrtum.create.foundation.fluid.FluidTank;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;

public class ConnectivityHandler {

    public static <T extends class_2586 & IMultiBlockEntityContainer> void formMulti(T be) {
        SearchCache<T> cache = new SearchCache<>();
        List<T> frontier = new ArrayList<>();
        frontier.add(be);
        formMulti(be.method_11017(), be.method_10997(), cache, frontier);
    }

    private static <T extends class_2586 & IMultiBlockEntityContainer> void formMulti(
        class_2591<?> type,
        class_1922 level,
        SearchCache<T> cache,
        List<T> frontier
    ) {
        PriorityQueue<Pair<Integer, T>> creationQueue = makeCreationQueue();
        Set<class_2338> visited = new HashSet<>();
        class_2350.class_2351 mainAxis = frontier.get(0).getMainConnectionAxis();

        // essentially, if it's a vertical multi then the search won't be restricted by
        // Y
        // alternately, a horizontal multi search shouldn't be restricted by X or Z
        int minX = (mainAxis == class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
        int minY = (mainAxis != class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
        int minZ = (mainAxis == class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE);

        for (T be : frontier) {
            class_2338 pos = be.method_11016();
            minX = Math.min(pos.method_10263(), minX);
            minY = Math.min(pos.method_10264(), minY);
            minZ = Math.min(pos.method_10260(), minZ);
        }
        if (mainAxis == class_2350.class_2351.field_11052)
            minX -= frontier.get(0).getMaxWidth();
        if (mainAxis != class_2350.class_2351.field_11052)
            minY -= frontier.get(0).getMaxWidth();
        if (mainAxis == class_2350.class_2351.field_11052)
            minZ -= frontier.get(0).getMaxWidth();

        while (!frontier.isEmpty()) {
            T part = frontier.remove(0);
            class_2338 partPos = part.method_11016();
            if (visited.contains(partPos))
                continue;

            visited.add(partPos);

            int amount = tryToFormNewMulti(part, cache, true);
            if (amount > 1) {
                creationQueue.add(Pair.of(amount, part));
            }

            for (class_2350.class_2351 axis : Iterate.axes) {
                class_2350 dir = class_2350.method_10156(class_2350.class_2352.field_11060, axis);
                class_2338 next = partPos.method_10093(dir);

                if (next.method_10263() <= minX || next.method_10264() <= minY || next.method_10260() <= minZ)
                    continue;
                if (visited.contains(next))
                    continue;
                T nextBe = partAt(type, level, next);
                if (nextBe == null)
                    continue;
                if (nextBe.method_11015())
                    continue;
                frontier.add(nextBe);
            }
        }
        visited.clear();

        while (!creationQueue.isEmpty()) {
            Pair<Integer, T> next = creationQueue.poll();
            T toCreate = next.getValue();
            if (visited.contains(toCreate.method_11016()))
                continue;

            visited.add(toCreate.method_11016());
            tryToFormNewMulti(toCreate, cache, false);
        }
    }

    private static <T extends class_2586 & IMultiBlockEntityContainer> int tryToFormNewMulti(T be, SearchCache<T> cache, boolean simulate) {
        int bestWidth = 1;
        int bestAmount = -1;
        if (!be.isController())
            return 0;

        int radius = be.getMaxWidth();
        for (int w = 1; w <= radius; w++) {
            int amount = tryToFormNewMultiOfWidth(be, w, cache, true);
            if (amount < bestAmount)
                continue;
            bestWidth = w;
            bestAmount = amount;
        }

        if (!simulate) {
            int beWidth = be.getWidth();
            if (beWidth == bestWidth && beWidth * beWidth * be.getHeight() == bestAmount)
                return bestAmount;

            splitMultiAndInvalidate(be, cache, false);
            if (be instanceof IMultiBlockEntityContainer.Fluid ifluid && ifluid.hasTank())
                ifluid.setTankSize(0, bestAmount);

            tryToFormNewMultiOfWidth(be, bestWidth, cache, false);

            be.preventConnectivityUpdate();
            be.setWidth(bestWidth);
            be.setHeight(bestAmount / bestWidth / bestWidth);
            be.notifyMultiUpdated();
        }
        return bestAmount;
    }

    private static <T extends class_2586 & IMultiBlockEntityContainer> int tryToFormNewMultiOfWidth(
        T be,
        int width,
        SearchCache<T> cache,
        boolean simulate
    ) {
        int amount = 0;
        int height = 0;
        class_2591<?> type = be.method_11017();
        class_1937 level = be.method_10997();
        if (level == null)
            return 0;
        class_2338 origin = be.method_11016();

        // optional fluid handling
        FluidTank beTank = null;
        FluidStack fluid = FluidStack.EMPTY;
        if (be instanceof IMultiBlockEntityContainer.Fluid ifluid && ifluid.hasTank()) {
            beTank = ifluid.getTank(0);
            fluid = beTank.getFluid();
        }
        class_2350.class_2351 axis = be.getMainConnectionAxis();

        Search:
        for (int yOffset = 0; yOffset < be.getMaxLength(axis, width); yOffset++) {
            for (int xOffset = 0; xOffset < width; xOffset++) {
                for (int zOffset = 0; zOffset < width; zOffset++) {
                    class_2338 pos = switch (axis) {
                        case field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };
                    Optional<T> part = cache.getOrCache(type, level, pos);
                    if (part.isEmpty())
                        break Search;

                    T controller = part.get();
                    int otherWidth = controller.getWidth();
                    if (otherWidth > width)
                        break Search;
                    if (otherWidth == width && controller.getHeight() == be.getMaxLength(axis, width))
                        break Search;

                    class_2350.class_2351 conAxis = controller.getMainConnectionAxis();
                    if (axis != conAxis)
                        break Search;

                    class_2338 conPos = controller.method_11016();
                    if (!conPos.equals(origin)) {
                        if (axis == class_2350.class_2351.field_11052) { // vertical multi, like a FluidTank
                            if (conPos.method_10263() < origin.method_10263())
                                break Search;
                            if (conPos.method_10260() < origin.method_10260())
                                break Search;
                            if (conPos.method_10263() + otherWidth > origin.method_10263() + width)
                                break Search;
                            if (conPos.method_10260() + otherWidth > origin.method_10260() + width)
                                break Search;
                        } else { // horizontal multi, like an ItemVault
                            if (axis == class_2350.class_2351.field_11051 && conPos.method_10263() < origin.method_10263())
                                break Search;
                            if (conPos.method_10264() < origin.method_10264())
                                break Search;
                            if (axis == class_2350.class_2351.field_11048 && conPos.method_10260() < origin.method_10260())
                                break Search;
                            if (axis == class_2350.class_2351.field_11051 && conPos.method_10263() + otherWidth > origin.method_10263() + width)
                                break Search;
                            if (conPos.method_10264() + otherWidth > origin.method_10264() + width)
                                break Search;
                            if (axis == class_2350.class_2351.field_11048 && conPos.method_10260() + otherWidth > origin.method_10260() + width)
                                break Search;
                        }
                    }
                    if (controller instanceof IMultiBlockEntityContainer.Fluid ifluidCon && ifluidCon.hasTank()) {
                        FluidStack otherFluid = ifluidCon.getFluid(0);
                        if (!fluid.isEmpty() && !otherFluid.isEmpty() && !ifluidCon.matches(fluid, otherFluid))
                            break Search;
                    }
                }
            }
            amount += width * width;
            height++;
        }

        if (simulate)
            return amount;

        Object extraData = be.getExtraData();

        for (int yOffset = 0; yOffset < height; yOffset++) {
            for (int xOffset = 0; xOffset < width; xOffset++) {
                for (int zOffset = 0; zOffset < width; zOffset++) {
                    class_2338 pos = switch (axis) {
                        case field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };
                    T part = partAt(type, level, pos);
                    if (part == null)
                        continue;
                    if (part == be)
                        continue;

                    extraData = be.modifyExtraData(extraData);

                    if (part instanceof IMultiBlockEntityContainer.Fluid ifluidPart && ifluidPart.hasTank()) {
                        FluidTank tankAt = ifluidPart.getTank(0);
                        FluidStack fluidAt = tankAt.getFluid();
                        if (!fluidAt.isEmpty()) {
                            // making this generic would be a rather large mess, unfortunately
                            if (beTank != null && fluid.isEmpty() && beTank instanceof CreativeFluidTankBlockEntity.CreativeFluidTankInventory creativeTank) {
                                creativeTank.setStack(0, fluidAt);
                                creativeTank.markDirty();
                            }
                            if (be instanceof IMultiBlockEntityContainer.Fluid ifluidBE && ifluidBE.hasTank() && beTank != null) {
                                beTank.insert(fluidAt);
                            }
                        }
                        tankAt.extract(fluidAt);
                    }

                    splitMultiAndInvalidate(part, cache, false);
                    part.setController(origin);
                    part.preventConnectivityUpdate();
                    cache.put(pos, be);
                    part.setHeight(height);
                    part.setWidth(width);
                    part.notifyMultiUpdated();
                }
            }
        }
        be.setExtraData(extraData);
        be.notifyMultiUpdated();
        return amount;
    }

    public static <T extends class_2586 & IMultiBlockEntityContainer> void splitMulti(T be) {
        splitMultiAndInvalidate(be, null, false);
    }

    // tryReconnect helps whenever only a few tanks have been removed
    private static <T extends class_2586 & IMultiBlockEntityContainer> void splitMultiAndInvalidate(
        T be,
        @Nullable SearchCache<T> cache,
        boolean tryReconnect
    ) {
        class_1937 level = be.method_10997();
        if (level == null)
            return;

        be = be.getControllerBE();
        if (be == null)
            return;

        int height = be.getHeight();
        int width = be.getWidth();
        if (width == 1 && height == 1)
            return;

        class_2338 origin = be.method_11016();
        List<T> frontier = new ArrayList<>();
        class_2350.class_2351 axis = be.getMainConnectionAxis();

        // fluid handling, if present
        FluidStack toDistribute = FluidStack.EMPTY;
        int maxCapacity = 0;
        if (be instanceof IMultiBlockEntityContainer.Fluid ifluidBE && ifluidBE.hasTank()) {
            toDistribute = ifluidBE.getFluid(0);
            maxCapacity = ifluidBE.getTankSize(0);
            if (!toDistribute.isEmpty() && !be.method_11015())
                toDistribute.decrement(maxCapacity);
            ifluidBE.setTankSize(0, 1);
        }

        for (int yOffset = 0; yOffset < height; yOffset++) {
            for (int xOffset = 0; xOffset < width; xOffset++) {
                for (int zOffset = 0; zOffset < width; zOffset++) {

                    class_2338 pos = switch (axis) {
                        case field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };

                    T partAt = partAt(be.method_11017(), level, pos);
                    if (partAt == null)
                        continue;
                    if (!partAt.getController().equals(origin))
                        continue;

                    T controllerBE = partAt.getControllerBE();
                    partAt.setExtraData((controllerBE == null ? null : controllerBE.getExtraData()));
                    partAt.removeController(true);

                    if (!toDistribute.isEmpty() && partAt != be) {
                        FluidStack copy = toDistribute.copy();
                        FluidTank tank = (partAt instanceof IMultiBlockEntityContainer.Fluid ifluidPart ? ifluidPart.getTank(0) : null);
                        // making this generic would be a rather large mess, unfortunately
                        if (tank instanceof CreativeFluidTankBlockEntity.CreativeFluidTankInventory creativeTank) {
                            if (creativeTank.isEmpty()) {
                                creativeTank.setStack(0, toDistribute);
                                creativeTank.markDirty();
                            }
                        } else {
                            int split = Math.min(maxCapacity, toDistribute.getAmount());
                            copy.setAmount(split);
                            toDistribute.decrement(split);
                            if (tank != null)
                                tank.insert(copy);
                        }
                    }
                    if (tryReconnect) {
                        frontier.add(partAt);
                        partAt.preventConnectivityUpdate();
                    }
                    if (cache != null)
                        cache.put(pos, partAt);
                }
            }
        }

        if (tryReconnect)
            formMulti(be.method_11017(), level, cache == null ? new SearchCache<>() : cache, frontier);
    }

    private static <T extends class_2586 & IMultiBlockEntityContainer> PriorityQueue<Pair<Integer, T>> makeCreationQueue() {
        return new PriorityQueue<>((one, two) -> two.getKey() - one.getKey());
    }

    @Nullable
    public static <T extends class_2586 & IMultiBlockEntityContainer> T partAt(class_2591<?> type, class_1922 level, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        if (be != null && be.method_11017() == type && !be.method_11015())
            return checked(be);
        return null;
    }

    public static <T extends class_2586 & IMultiBlockEntityContainer> boolean isConnected(class_1922 level, class_2338 pos, class_2338 other) {
        T one = checked(level.method_8321(pos));
        T two = checked(level.method_8321(other));
        if (one == null || two == null)
            return false;
        return one.getController().equals(two.getController());
    }

    @Nullable
    @SuppressWarnings("unchecked")
    private static <T extends class_2586 & IMultiBlockEntityContainer> T checked(class_2586 be) {
        if (be instanceof IMultiBlockEntityContainer)
            return (T) be;
        return null;
    }

    private static class SearchCache<T extends class_2586 & IMultiBlockEntityContainer> {
        Map<class_2338, Optional<T>> controllerMap;

        public SearchCache() {
            controllerMap = new HashMap<>();
        }

        void put(class_2338 pos, T target) {
            controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(class_2338 pos) {
            controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(class_2338 pos) {
            return controllerMap.containsKey(pos);
        }

        Optional<T> getOrCache(class_2591<?> type, class_1922 level, class_2338 pos) {
            if (hasVisited(pos))
                return controllerMap.get(pos);

            T partAt = partAt(type, level, pos);
            if (partAt == null) {
                putEmpty(pos);
                return Optional.empty();
            }
            T controller = checked(level.method_8321(partAt.getController()));
            if (controller == null) {
                putEmpty(pos);
                return Optional.empty();
            }
            put(pos, controller);
            return Optional.of(controller);
        }
    }
}
