package com.zurrtum.create.api.contraption.train;

import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.trains.track.AllPortalTracks;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_9797;
import org.jetbrains.annotations.Nullable;

/**
 * A provider for portal track connections.
 * Takes a track inbound through a portal and finds the exit location for the outbound track.
 */
@FunctionalInterface
public interface PortalTrackProvider {
    SimpleRegistry<class_2248, PortalTrackProvider> REGISTRY = SimpleRegistry.create();

    /**
     * Find the exit location for a track going through a portal.
     *
     * @param level the level of the inbound track
     * @param face  the face of the inbound track
     */
    Exit findExit(class_3218 level, BlockFace face);

    /**
     * Checks if a given {@link class_2680} represents a supported portal block.
     *
     * @param state The block state to check.
     * @return {@code true} if the block state represents a supported portal; {@code false} otherwise.
     */
    static boolean isSupportedPortal(class_2680 state) {
        return REGISTRY.get(state) != null;
    }

    /**
     * Retrieves the corresponding outbound track on the other side of a portal.
     *
     * @param level        The current {@link class_3218}.
     * @param inboundTrack The inbound track {@link BlockFace}.
     * @return the found outbound track, or null if one wasn't found.
     */
    @Nullable
    static Exit getOtherSide(class_3218 level, BlockFace inboundTrack) {
        class_2338 portalPos = inboundTrack.getConnectedPos();
        class_2680 portalState = level.method_8320(portalPos);
        PortalTrackProvider provider = REGISTRY.get(portalState);
        return provider == null ? null : provider.findExit(level, inboundTrack);
    }

    /**
     * Find an exit location by using an {@link class_9797} instance.
     *
     * @param level           The level of the inbound track
     * @param face            The face of the inbound track
     * @param firstDimension  The first dimension (typically the Overworld)
     * @param secondDimension The second dimension (e.g., Nether, Aether)
     * @param portal          The portal
     * @return A found exit, or null if one wasn't found
     */
    static Exit fromPortal(class_3218 level, BlockFace face, class_5321<class_1937> firstDimension, class_5321<class_1937> secondDimension, class_9797 portal) {
        return AllPortalTracks.fromPortal(level, face, firstDimension, secondDimension, portal);
    }

    record Exit(class_3218 level, BlockFace face) {
    }
}
