package com.zurrtum.create.api.packager.unpacking;

import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

/**
 * Interface for custom handling of box unpacking into storage.
 * <p>
 * This interface is <strong>experimental</strong> as it is for a new feature. It may be revised or relocated,
 * but will likely not change very much.
 */
@ApiStatus.Experimental
public interface UnpackingHandler {
    SimpleRegistry<class_2248, UnpackingHandler> REGISTRY = SimpleRegistry.create();

    /**
     * Unpack the given items into storage.
     *
     * @param items        the list of non-empty item stacks to unpack. May be freely modified
     * @param orderContext the order context, if present
     * @param simulate     true if the unpacking should only be simulated
     * @return true if all items have been unpacked successfully
     */
    boolean unpack(
        class_1937 level,
        class_2338 pos,
        class_2680 state,
        class_2350 side,
        List<class_1799> items,
        @Nullable PackageOrderWithCrafts orderContext,
        boolean simulate
    );
}
