package com.zurrtum.create.api.registry;

import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageType;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileBlockHitAction;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileEntityHitAction;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileRenderMode;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessingType;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttributeType;
import com.zurrtum.create.content.logistics.packagePort.PackagePortTargetType;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_9248;
import net.minecraft.registry.*;

public class CreateRegistries {
    public static final class_2378<ArmInteractionPointType> ARM_INTERACTION_POINT_TYPE = register(CreateRegistryKeys.ARM_INTERACTION_POINT_TYPE);
    public static final class_2378<FanProcessingType> FAN_PROCESSING_TYPE = register(CreateRegistryKeys.FAN_PROCESSING_TYPE);
    public static final class_2378<ItemAttributeType> ITEM_ATTRIBUTE_TYPE = register(CreateRegistryKeys.ITEM_ATTRIBUTE_TYPE);
    public static final class_2378<DisplaySource> DISPLAY_SOURCE = register(CreateRegistryKeys.DISPLAY_SOURCE);
    public static final class_2378<DisplayTarget> DISPLAY_TARGET = register(CreateRegistryKeys.DISPLAY_TARGET);
    public static final class_2378<MountedItemStorageType<?>> MOUNTED_ITEM_STORAGE_TYPE = registerIntrusive(CreateRegistryKeys.MOUNTED_ITEM_STORAGE_TYPE);
    public static final class_2378<MountedFluidStorageType<?>> MOUNTED_FLUID_STORAGE_TYPE = register(CreateRegistryKeys.MOUNTED_FLUID_STORAGE_TYPE);
    public static final class_2378<ContraptionType> CONTRAPTION_TYPE = registerIntrusive(CreateRegistryKeys.CONTRAPTION_TYPE);
    public static final class_2378<MapCodec<? extends PotatoProjectileRenderMode>> POTATO_PROJECTILE_RENDER_MODE = register(CreateRegistryKeys.POTATO_PROJECTILE_RENDER_MODE);
    public static final class_2378<MapCodec<? extends PotatoProjectileEntityHitAction>> POTATO_PROJECTILE_ENTITY_HIT_ACTION = register(
        CreateRegistryKeys.POTATO_PROJECTILE_ENTITY_HIT_ACTION);
    public static final class_2378<MapCodec<? extends PotatoProjectileBlockHitAction>> POTATO_PROJECTILE_BLOCK_HIT_ACTION = register(CreateRegistryKeys.POTATO_PROJECTILE_BLOCK_HIT_ACTION);
    public static final class_2378<PackagePortTargetType> PACKAGE_PORT_TARGET_TYPE = register(CreateRegistryKeys.PACKAGE_PORT_TARGET_TYPE);
    public static final class_2378<MenuType<?>> MENU_TYPE = register(CreateRegistryKeys.MENU_TYPE);

    private static <T> class_2378<T> register(class_5321<? extends class_2378<T>> key) {
        return register(key, false);
    }

    private static <T> class_2378<T> registerIntrusive(class_5321<? extends class_2378<T>> key) {
        return register(key, true);
    }

    @SuppressWarnings("unchecked")
    private static <T> class_2378<T> register(class_5321<? extends class_2378<T>> key, boolean intrusive) {
        class_2370<T> registry = new class_2370<>(key, Lifecycle.stable(), intrusive);
        class_7923.field_41170.method_10272((class_5321<class_2385<?>>) (Object) key, registry, class_9248.field_49136);
        return registry;
    }

    public static void register() {
    }
}