package com.zurrtum.create.api.schematic.requirement;

import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

/**
 * Registries for custom schematic requirements for blocks, block entities, and entities. These requirements determine
 * the items that are needed for placement into the world through schematics.
 * <p>
 * This is provided as an alternative to the following interfaces:
 * <ul>
 *     <li>{@link SpecialBlockItemRequirement}</li>
 *     <li>{@link SpecialBlockEntityItemRequirement}</li>
 *     <li>{@link SpecialEntityItemRequirement}</li>
 * </ul>
 */
public class SchematicRequirementRegistries {
    public static final SimpleRegistry<class_2248, BlockRequirement> BLOCKS = SimpleRegistry.create();
    public static final SimpleRegistry<class_2591<?>, BlockEntityRequirement> BLOCK_ENTITIES = SimpleRegistry.create();
    public static final SimpleRegistry<class_1299<?>, EntityRequirement> ENTITIES = SimpleRegistry.create();

    @FunctionalInterface
    public interface BlockRequirement {
        ItemRequirement getRequiredItems(class_2680 state, @Nullable class_2586 blockEntity);
    }

    @FunctionalInterface
    public interface BlockEntityRequirement {
        ItemRequirement getRequiredItems(class_2586 blockEntity, class_2680 state);
    }

    @FunctionalInterface
    public interface EntityRequirement {
        ItemRequirement getRequiredItems(class_1297 entity);
    }

    private SchematicRequirementRegistries() {
        throw new AssertionError("This class should not be instantiated");
    }
}