package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.zurrtum.create.catnip.theme.Color;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

import java.util.List;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_241;
import net.minecraft.class_4588;
import net.minecraft.class_8030;

import static com.zurrtum.create.client.catnip.render.PonderRenderPipelines.POSITION_COLOR_STRIP;

public record RadialSectorRenderState(
    Matrix3x2f pose, List<class_241> innerPoints, List<class_241> outerPoints, int outerColor, int innerColor, class_8030 bounds
) implements class_11244 {
    public RadialSectorRenderState(
        Matrix3x2f pose,
        double minX,
        double maxX,
        double minY,
        double maxY,
        List<class_241> innerPoints,
        List<class_241> outerPoints,
        Color innerColor,
        Color outerColor
    ) {
        this(
            pose,
            innerPoints,
            outerPoints,
            outerColor.getRGB(),
            innerColor.getRGB(),
            new class_8030((int) minX, (int) minY, (int) (maxX - minX), (int) (maxY - minY)).method_71523(pose)
        );
    }

    @Override
    public RenderPipeline comp_4055() {
        return POSITION_COLOR_STRIP;
    }

    @Override
    public void method_70917(class_4588 vertexConsumer) {
        for (int i = 0; i < innerPoints.size(); i++) {
            class_241 point = outerPoints.get(i);
            vertexConsumer.method_70815(pose, point.field_1343, point.field_1342).method_39415(outerColor);

            point = innerPoints.get(i);
            vertexConsumer.method_70815(pose, point.field_1343, point.field_1342).method_39415(innerColor);
        }
    }

    @Override
    public class_11231 comp_4056() {
        return class_11231.method_70899();
    }

    @Override
    public @Nullable class_8030 comp_4069() {
        return null;
    }
}
