package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.zurrtum.create.catnip.theme.Color;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import org.joml.Matrix3x2f;

public record TexturedQuadRenderState(
    Matrix3x2f pose, float left, float right, float top, float bot, int red, int green, int blue, int alpha, float u1, float u2, float v1, float v2,
    class_11231 textureSetup, class_8030 bounds, class_8030 scissorArea
) implements class_11244 {
    public TexturedQuadRenderState(
        Matrix3x2f pose,
        class_11231 textureSetup,
        int left,
        int right,
        int top,
        int bot,
        Color color,
        float u1,
        float u2,
        float v1,
        float v2,
        class_8030 scissorArea
    ) {
        this(
            pose,
            left,
            right,
            top,
            bot,
            color.getRed(),
            color.getGreen(),
            color.getBlue(),
            color.getAlpha(),
            u1,
            u2,
            v1,
            v2,
            textureSetup,
            new class_8030(left, top, right - left, bot - top).method_71523(pose),
            scissorArea
        );
    }

    @Override
    public RenderPipeline comp_4055() {
        return class_10799.field_56883;
    }

    @Override
    public void method_70917(class_4588 vertexConsumer) {
        vertexConsumer.method_70815(pose, left, bot).method_1336(red, green, blue, alpha).method_22913(u1, v2);
        vertexConsumer.method_70815(pose, right, bot).method_1336(red, green, blue, alpha).method_22913(u2, v2);
        vertexConsumer.method_70815(pose, right, top).method_1336(red, green, blue, alpha).method_22913(u2, v1);
        vertexConsumer.method_70815(pose, left, top).method_1336(red, green, blue, alpha).method_22913(u1, v1);
    }
}
