package com.zurrtum.create.client.catnip.lang;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.serialization.JsonOps;
import com.zurrtum.create.catnip.theme.Color;
import joptsimple.internal.Strings;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Consumer;

public class LangBuilder {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final float DEFAULT_SPACE_WIDTH = 4.0F; // space width in vanilla's default font
    String namespace;
    @Nullable class_5250 component;

    public LangBuilder(String namespace) {
        this.namespace = namespace;
    }

    public static Object[] resolveBuilders(Object[] args) {
        for (int i = 0; i < args.length; i++)
            if (args[i] instanceof LangBuilder cb)
                args[i] = cb.component();
        return args;
    }

    static int getIndents(class_327 font, int defaultIndents) {
        int spaceWidth = font.method_1727(" ");
        if (DEFAULT_SPACE_WIDTH == spaceWidth) {
            return defaultIndents;
        }
        return class_3532.method_15386(DEFAULT_SPACE_WIDTH * defaultIndents / spaceWidth);
    }

    public LangBuilder space() {
        return text(" ");
    }

    public LangBuilder newLine() {
        return text("\n");
    }

    /**
     * Appends a localised component<br>
     * To add an independently formatted localised component, use add() and a nested
     * builder
     *
     * @param langKey
     * @param args
     * @return
     */
    public LangBuilder translate(String langKey, Object... args) {
        Object[] args1 = resolveBuilders(args);
        return add(class_2561.method_43469(namespace + "." + langKey, args1));
    }

    /**
     * Appends a text component
     *
     * @param literalText
     * @return
     */
    public LangBuilder text(String literalText) {
        return add(class_2561.method_43470(literalText));
    }

    //

    /**
     * Appends a colored text component
     *
     * @param format
     * @param literalText
     * @return
     */
    public LangBuilder text(class_124 format, String literalText) {
        return add(class_2561.method_43470(literalText).method_27692(format));
    }

    /**
     * Appends a colored text component
     *
     * @param color
     * @param literalText
     * @return
     */
    public LangBuilder text(int color, String literalText) {
        return add(class_2561.method_43470(literalText).method_27694(s -> s.method_36139(color)));
    }

    /**
     * Appends the contents of another builder
     *
     * @param otherBuilder
     * @return
     */
    public LangBuilder add(LangBuilder otherBuilder) {
        return add(otherBuilder.component());
    }

    //

    /**
     * Appends a component
     *
     * @param customComponent
     * @return
     */
    public LangBuilder add(class_5250 customComponent) {
        component = component == null ? customComponent : component.method_10852(customComponent);
        return this;
    }

    /**
     * Appends a component
     *
     * @param component the component to append
     * @return this builder
     */
    public LangBuilder add(class_2561 component) {
        if (component instanceof class_5250 mutableComponent)
            return add(mutableComponent);
        else
            return add(component.method_27661());
    }

    /**
     * Applies the format to all added components
     *
     * @param format
     * @return
     */
    public LangBuilder style(class_124 format) {
        assertComponent();
        component = component.method_27692(format);
        return this;
    }

    /**
     * Applies the color to all added components
     */
    public LangBuilder color(int color) {
        assertComponent();
        component = component.method_27694(s -> s.method_36139(color));
        return this;
    }

    /**
     * Applies the color to all added components
     */
    public LangBuilder color(Color color) {
        return this.color(color.getRGB());
    }

    public class_5250 component() {
        assertComponent();
        return component;
    }

    public String string() {
        return component().getString();
    }

    public String json() {
        return GSON.toJson(class_8824.field_46597.encodeStart(class_5455.field_40585.method_57093(JsonOps.INSTANCE), component())
            .getOrThrow(JsonParseException::new));
    }

    public void sendStatus(class_1657 player) {
        player.method_7353(component(), true);
    }

    //

    public void sendChat(class_1657 player) {
        player.method_7353(component(), false);
    }

    public void addTo(List<? super class_5250> tooltip) {
        tooltip.add(component());
    }

    public void addTo(Consumer<? super class_5250> tooltip) {
        tooltip.accept(component());
    }

    private void assertComponent() {
        if (component == null)
            throw new IllegalStateException("No components were added to builder");
    }

    public void forGoggles(List<? super class_5250> tooltip) {
        forGoggles(tooltip, 0);
    }

    public void forGoggles(List<? super class_5250> tooltip, int indents) {
        tooltip.add(new LangBuilder(namespace).text(Strings.repeat(' ', getIndents(class_310.method_1551().field_1772, 4 + indents)))
            .add(this).component());
    }
}
