package com.zurrtum.create.client.catnip.outliner;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.render.BindableTexture;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.*;

public abstract class Outline {

    protected final OutlineParams params;

    protected final Vector4f colorTemp = new Vector4f();
    protected final Vector3f diffPosTemp = new Vector3f();
    protected final Vector3f minPosTemp = new Vector3f();
    protected final Vector3f maxPosTemp = new Vector3f();
    protected final Vector4f posTransformTemp = new Vector4f();
    protected final Vector3f normalTransformTemp = new Vector3f();

    public Outline() {
        params = new OutlineParams();
    }

    public OutlineParams getParams() {
        return params;
    }

    public abstract void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, float pt);

    public void tick() {
    }

    public void bufferCuboidLine(
        class_4587 poseStack,
        class_4588 consumer,
        class_243 camera,
        Vector3d start,
        Vector3d end,
        float width,
        Vector4f color,
        int lightmap,
        boolean disableNormals
    ) {
        Vector3f diff = this.diffPosTemp;
        diff.set((float) (end.x - start.x), (float) (end.y - start.y), (float) (end.z - start.z));

        float length = class_3532.method_15355(diff.x() * diff.x() + diff.y() * diff.y() + diff.z() * diff.z());
        float hAngle = AngleHelper.deg(class_3532.method_15349(diff.x(), diff.z()));
        float hDistance = class_3532.method_15355(diff.x() * diff.x() + diff.z() * diff.z());
        float vAngle = AngleHelper.deg(class_3532.method_15349(hDistance, diff.y())) - 90;

        poseStack.method_22903();
        TransformStack.of(poseStack).translate(start.x - camera.field_1352, start.y - camera.field_1351, start.z - camera.field_1350).rotateYDegrees(hAngle)
            .rotateXDegrees(vAngle);
        bufferCuboidLine(poseStack.method_23760(), consumer, new Vector3f(), class_2350.field_11035, length, width, color, lightmap, disableNormals);
        poseStack.method_22909();
    }

    public void bufferCuboidLine(
        class_4587.class_4665 pose,
        class_4588 consumer,
        Vector3f origin,
        class_2350 direction,
        float length,
        float width,
        Vector4f color,
        int lightmap,
        boolean disableNormals
    ) {
        Vector3f minPos = minPosTemp;
        Vector3f maxPos = maxPosTemp;

        float halfWidth = width / 2;
        minPos.set(origin.x() - halfWidth, origin.y() - halfWidth, origin.z() - halfWidth);
        maxPos.set(origin.x() + halfWidth, origin.y() + halfWidth, origin.z() + halfWidth);

        switch (direction) {
            case field_11033 -> {
                minPos.add(0, -length, 0);
            }
            case field_11036 -> {
                maxPos.add(0, length, 0);
            }
            case field_11043 -> {
                minPos.add(0, 0, -length);
            }
            case field_11035 -> {
                maxPos.add(0, 0, length);
            }
            case field_11039 -> {
                minPos.add(-length, 0, 0);
            }
            case field_11034 -> {
                maxPos.add(length, 0, 0);
            }
        }

        bufferCuboid(pose, consumer, minPos, maxPos, color, lightmap, disableNormals);
    }

    public void bufferCuboid(
        class_4587.class_4665 pose,
        class_4588 consumer,
        Vector3f minPos,
        Vector3f maxPos,
        Vector4f color,
        int lightmap,
        boolean disableNormals
    ) {
        Vector4f posTransformTemp = this.posTransformTemp;
        Vector3f normalTransformTemp = this.normalTransformTemp;

        float minX = minPos.x();
        float minY = minPos.y();
        float minZ = minPos.z();
        float maxX = maxPos.x();
        float maxY = maxPos.y();
        float maxZ = maxPos.z();

        Matrix4f posMatrix = pose.method_23761();

        posTransformTemp.set(minX, minY, maxZ, 1);
        posTransformTemp.mul(posMatrix);
        float x0 = posTransformTemp.x();
        float y0 = posTransformTemp.y();
        float z0 = posTransformTemp.z();

        posTransformTemp.set(minX, minY, minZ, 1);
        posTransformTemp.mul(posMatrix);
        float x1 = posTransformTemp.x();
        float y1 = posTransformTemp.y();
        float z1 = posTransformTemp.z();

        posTransformTemp.set(maxX, minY, minZ, 1);
        posTransformTemp.mul(posMatrix);
        float x2 = posTransformTemp.x();
        float y2 = posTransformTemp.y();
        float z2 = posTransformTemp.z();

        posTransformTemp.set(maxX, minY, maxZ, 1);
        posTransformTemp.mul(posMatrix);
        float x3 = posTransformTemp.x();
        float y3 = posTransformTemp.y();
        float z3 = posTransformTemp.z();

        posTransformTemp.set(minX, maxY, minZ, 1);
        posTransformTemp.mul(posMatrix);
        float x4 = posTransformTemp.x();
        float y4 = posTransformTemp.y();
        float z4 = posTransformTemp.z();

        posTransformTemp.set(minX, maxY, maxZ, 1);
        posTransformTemp.mul(posMatrix);
        float x5 = posTransformTemp.x();
        float y5 = posTransformTemp.y();
        float z5 = posTransformTemp.z();

        posTransformTemp.set(maxX, maxY, maxZ, 1);
        posTransformTemp.mul(posMatrix);
        float x6 = posTransformTemp.x();
        float y6 = posTransformTemp.y();
        float z6 = posTransformTemp.z();

        posTransformTemp.set(maxX, maxY, minZ, 1);
        posTransformTemp.mul(posMatrix);
        float x7 = posTransformTemp.x();
        float y7 = posTransformTemp.y();
        float z7 = posTransformTemp.z();

        float r = color.x();
        float g = color.y();
        float b = color.z();
        float a = color.w();

        Matrix3f normalMatrix = pose.method_23762();

        // down

        if (disableNormals) {
            normalTransformTemp.set(0, 1, 0);
        } else {
            normalTransformTemp.set(0, -1, 0);
        }
        normalTransformTemp.mul(normalMatrix);
        float nx0 = normalTransformTemp.x();
        float ny0 = normalTransformTemp.y();
        float nz0 = normalTransformTemp.z();

        consumer.method_22912(x0, y0, z0).method_22915(r, g, b, a).method_22913(0, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx0, ny0, nz0);

        consumer.method_22912(x1, y1, z1).method_22915(r, g, b, a).method_22913(0, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx0, ny0, nz0);

        consumer.method_22912(x2, y2, z2).method_22915(r, g, b, a).method_22913(1, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx0, ny0, nz0);

        consumer.method_22912(x3, y3, z3).method_22915(r, g, b, a).method_22913(1, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx0, ny0, nz0);

        // up

        normalTransformTemp.set(0, 1, 0);
        normalTransformTemp.mul(normalMatrix);
        float nx1 = normalTransformTemp.x();
        float ny1 = normalTransformTemp.y();
        float nz1 = normalTransformTemp.z();

        consumer.method_22912(x4, y4, z4).method_22915(r, g, b, a).method_22913(0, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx1, ny1, nz1);

        consumer.method_22912(x5, y5, z5).method_22915(r, g, b, a).method_22913(0, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx1, ny1, nz1);

        consumer.method_22912(x6, y6, z6).method_22915(r, g, b, a).method_22913(1, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx1, ny1, nz1);

        consumer.method_22912(x7, y7, z7).method_22915(r, g, b, a).method_22913(1, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx1, ny1, nz1);

        // north

        if (disableNormals) {
            normalTransformTemp.set(0, 1, 0);
        } else {
            normalTransformTemp.set(0, 0, -1);
        }
        normalTransformTemp.mul(normalMatrix);
        float nx2 = normalTransformTemp.x();
        float ny2 = normalTransformTemp.y();
        float nz2 = normalTransformTemp.z();

        consumer.method_22912(x7, y7, z7).method_22915(r, g, b, a).method_22913(0, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx2, ny2, nz2);

        consumer.method_22912(x2, y2, z2).method_22915(r, g, b, a).method_22913(0, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx2, ny2, nz2);

        consumer.method_22912(x1, y1, z1).method_22915(r, g, b, a).method_22913(1, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx2, ny2, nz2);

        consumer.method_22912(x4, y4, z4).method_22915(r, g, b, a).method_22913(1, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx2, ny2, nz2);

        // south

        if (disableNormals) {
            normalTransformTemp.set(0, 1, 0);
        } else {
            normalTransformTemp.set(0, 0, 1);
        }
        normalTransformTemp.mul(normalMatrix);
        float nx3 = normalTransformTemp.x();
        float ny3 = normalTransformTemp.y();
        float nz3 = normalTransformTemp.z();

        consumer.method_22912(x5, y5, z5).method_22915(r, g, b, a).method_22913(0, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx3, ny3, nz3);

        consumer.method_22912(x0, y0, z0).method_22915(r, g, b, a).method_22913(0, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx3, ny3, nz3);

        consumer.method_22912(x3, y3, z3).method_22915(r, g, b, a).method_22913(1, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx3, ny3, nz3);

        consumer.method_22912(x6, y6, z6).method_22915(r, g, b, a).method_22913(1, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx3, ny3, nz3);

        // west

        if (disableNormals) {
            normalTransformTemp.set(0, 1, 0);
        } else {
            normalTransformTemp.set(-1, 0, 0);
        }
        normalTransformTemp.mul(normalMatrix);
        float nx4 = normalTransformTemp.x();
        float ny4 = normalTransformTemp.y();
        float nz4 = normalTransformTemp.z();

        consumer.method_22912(x4, y4, z4).method_22915(r, g, b, a).method_22913(0, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx4, ny4, nz4);

        consumer.method_22912(x1, y1, z1).method_22915(r, g, b, a).method_22913(0, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx4, ny4, nz4);

        consumer.method_22912(x0, y0, z0).method_22915(r, g, b, a).method_22913(1, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx4, ny4, nz4);

        consumer.method_22912(x5, y5, z5).method_22915(r, g, b, a).method_22913(1, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx4, ny4, nz4);

        // east

        if (disableNormals) {
            normalTransformTemp.set(0, 1, 0);
        } else {
            normalTransformTemp.set(1, 0, 0);
        }
        normalTransformTemp.mul(normalMatrix);
        float nx5 = normalTransformTemp.x();
        float ny5 = normalTransformTemp.y();
        float nz5 = normalTransformTemp.z();

        consumer.method_22912(x6, y6, z6).method_22915(r, g, b, a).method_22913(0, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx5, ny5, nz5);

        consumer.method_22912(x3, y3, z3).method_22915(r, g, b, a).method_22913(0, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx5, ny5, nz5);

        consumer.method_22912(x2, y2, z2).method_22915(r, g, b, a).method_22913(1, 1).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx5, ny5, nz5);

        consumer.method_22912(x7, y7, z7).method_22915(r, g, b, a).method_22913(1, 0).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx5, ny5, nz5);
    }

    public void bufferQuad(
        class_4587.class_4665 pose,
        class_4588 consumer,
        Vector3f pos0,
        Vector3f pos1,
        Vector3f pos2,
        Vector3f pos3,
        Vector4f color,
        int lightmap,
        Vector3f normal
    ) {
        bufferQuad(pose, consumer, pos0, pos1, pos2, pos3, color, 0, 0, 1, 1, lightmap, normal);
    }

    public void bufferQuad(
        class_4587.class_4665 pose,
        class_4588 consumer,
        Vector3f pos0,
        Vector3f pos1,
        Vector3f pos2,
        Vector3f pos3,
        Vector4f color,
        float minU,
        float minV,
        float maxU,
        float maxV,
        int lightmap,
        Vector3f normal
    ) {
        Vector4f posTransformTemp = this.posTransformTemp;
        Vector3f normalTransformTemp = this.normalTransformTemp;

        Matrix4f posMatrix = pose.method_23761();

        posTransformTemp.set(pos0.x(), pos0.y(), pos0.z(), 1);
        posTransformTemp.mul(posMatrix);
        float x0 = posTransformTemp.x();
        float y0 = posTransformTemp.y();
        float z0 = posTransformTemp.z();

        posTransformTemp.set(pos1.x(), pos1.y(), pos1.z(), 1);
        posTransformTemp.mul(posMatrix);
        float x1 = posTransformTemp.x();
        float y1 = posTransformTemp.y();
        float z1 = posTransformTemp.z();

        posTransformTemp.set(pos2.x(), pos2.y(), pos2.z(), 1);
        posTransformTemp.mul(posMatrix);
        float x2 = posTransformTemp.x();
        float y2 = posTransformTemp.y();
        float z2 = posTransformTemp.z();

        posTransformTemp.set(pos3.x(), pos3.y(), pos3.z(), 1);
        posTransformTemp.mul(posMatrix);
        float x3 = posTransformTemp.x();
        float y3 = posTransformTemp.y();
        float z3 = posTransformTemp.z();

        float r = color.x();
        float g = color.y();
        float b = color.z();
        float a = color.w();

        normalTransformTemp.set(normal);
        normalTransformTemp.mul(pose.method_23762());
        float nx = normalTransformTemp.x();
        float ny = normalTransformTemp.y();
        float nz = normalTransformTemp.z();

        consumer.method_22912(x0, y0, z0).method_22915(r, g, b, a).method_22913(minU, minV).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx, ny, nz);

        consumer.method_22912(x1, y1, z1).method_22915(r, g, b, a).method_22913(minU, maxV).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx, ny, nz);

        consumer.method_22912(x2, y2, z2).method_22915(r, g, b, a).method_22913(maxU, maxV).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx, ny, nz);

        consumer.method_22912(x3, y3, z3).method_22915(r, g, b, a).method_22913(maxU, minV).method_22922(class_4608.field_21444).method_60803(lightmap).method_22914(nx, ny, nz);
    }

    public static class OutlineParams {
        @Nullable
        protected BindableTexture faceTexture;
        @Nullable
        protected BindableTexture highlightedFaceTexture;
        @Nullable class_2350 highlightedFace;
        protected boolean fadeLineWidth;
        protected boolean disableCull;
        protected boolean disableLineNormals;
        protected float alpha;
        protected int lightmap;
        protected Color rgb;
        private float lineWidth;

        public OutlineParams() {
            faceTexture = highlightedFaceTexture = null;
            alpha = 1;
            lineWidth = 1 / 32f;
            fadeLineWidth = true;
            rgb = Color.WHITE;
            lightmap = class_765.field_32767;
        }

        // builder

        public OutlineParams colored(int color) {
            rgb = new Color(color, false);
            return this;
        }

        public OutlineParams colored(Color c) {
            rgb = c.copy();
            return this;
        }

        public OutlineParams lightmap(int light) {
            lightmap = light;
            return this;
        }

        public OutlineParams lineWidth(float width) {
            this.lineWidth = width;
            return this;
        }

        public OutlineParams withFaceTexture(@Nullable BindableTexture texture) {
            this.faceTexture = texture;
            return this;
        }

        public OutlineParams clearTextures() {
            return this.withFaceTextures(null, null);
        }

        public OutlineParams withFaceTextures(@Nullable BindableTexture texture, @Nullable BindableTexture highlightTexture) {
            this.faceTexture = texture;
            this.highlightedFaceTexture = highlightTexture;
            return this;
        }

        public OutlineParams highlightFace(@Nullable class_2350 face) {
            highlightedFace = face;
            return this;
        }

        public OutlineParams disableLineNormals() {
            disableLineNormals = true;
            return this;
        }

        public OutlineParams disableCull() {
            disableCull = true;
            return this;
        }

        // getter

        public float getLineWidth() {
            return fadeLineWidth ? alpha * lineWidth : lineWidth;
        }

        @Nullable
        public class_2350 getHighlightedFace() {
            return highlightedFace;
        }

        public void loadColor(Vector4f vec) {
            vec.set(rgb.getRedAsFloat(), rgb.getGreenAsFloat(), rgb.getBlueAsFloat(), rgb.getAlphaAsFloat() * alpha);
        }
    }

}
