package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.IconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.DeployerRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zurrtum.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_10289;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.ArrayList;
import java.util.List;

public class DeployingCategory extends CreateCategory<class_8786<? extends ItemApplicationRecipe>> {
    public static List<class_8786<? extends ItemApplicationRecipe>> getRecipes(class_10289 preparedRecipes) {
        List<class_8786<? extends ItemApplicationRecipe>> recipes = new ArrayList<>();
        recipes.addAll(preparedRecipes.method_64698(AllRecipeTypes.DEPLOYING));
        recipes.addAll(preparedRecipes.method_64698(AllRecipeTypes.ITEM_APPLICATION));
        List<class_6880<class_1792>> sandpaperList = new ArrayList<>();
        for (class_6880<class_1792> entry : class_7923.field_41178.method_40286(AllItemTags.SANDPAPER)) {
            sandpaperList.add(entry);
        }
        class_1856 ingredient = class_1856.method_8106(class_6885.method_40242(sandpaperList));
        for (class_8786<SandPaperPolishingRecipe> entry : preparedRecipes.method_64698(AllRecipeTypes.SANDPAPER_POLISHING)) {
            SandPaperPolishingRecipe recipe = entry.comp_1933();
            recipes.add(new class_8786<>(
                class_5321.method_29179(class_7924.field_52178, entry.comp_1932().method_29177().method_48331("_using_deployer")),
                new DeployerApplicationRecipe(recipe.result(), true, recipe.ingredient(), ingredient)
            ));
        }
        return recipes;
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<? extends ItemApplicationRecipe>> getRecipeType() {
        return JeiClientPlugin.DEPLOYING;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.deploying");
    }

    @Override
    public IDrawable getIcon() {
        return new IconRenderer(AllItems.DEPLOYER);
    }

    @Override
    public int getHeight() {
        return 70;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<? extends ItemApplicationRecipe> entry, IFocusGroup focuses) {
        ItemApplicationRecipe recipe = entry.comp_1933();
        builder.addInputSlot(51, 5).setBackground(SLOT, -1, -1).add(recipe.ingredient());
        builder.addInputSlot(27, 51).setBackground(SLOT, -1, -1).add(recipe.target());
        builder.addOutputSlot(132, 51).setBackground(SLOT, -1, -1).add(recipe.result());
    }

    @Override
    public void draw(
        class_8786<? extends ItemApplicationRecipe> entry,
        IRecipeSlotsView recipeSlotsView,
        class_332 graphics,
        double mouseX,
        double mouseY
    ) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 62, 57);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 126, 29);
        graphics.field_59826.method_70922(new DeployerRenderState(new Matrix3x2f(graphics.method_51448()), 75, -10));
    }
}
