package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.DrainRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.fluids.transfer.EmptyingRecipe;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.fabricmc.fabric.api.recipe.v1.ingredient.DefaultCustomIngredients;
import net.minecraft.class_10289;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import static com.zurrtum.create.Create.MOD_ID;

public class DrainingCategory extends CreateCategory<class_8786<EmptyingRecipe>> {
    public static List<class_8786<EmptyingRecipe>> getRecipes(class_10289 preparedRecipes, Stream<class_1799> itemStream) {
        List<class_8786<EmptyingRecipe>> recipes = new ArrayList<>(preparedRecipes.method_64698(AllRecipeTypes.EMPTYING));
        MutableInt i = new MutableInt();
        itemStream.forEach(stack -> {
            if (PotionFluidHandler.isPotionItem(stack)) {
                class_1856 ingredient = stack.method_57380()
                    .method_57848() ? class_1856.method_8101(stack.method_7909()) : DefaultCustomIngredients.components(stack);
                recipes.add(new class_8786<>(
                    class_5321.method_29179(class_7924.field_52178, class_2960.method_60655(MOD_ID, "draining_potions_" + i.getAndIncrement())),
                    new EmptyingRecipe(class_1802.field_8469.method_7854(), PotionFluidHandler.getFluidFromPotionItem(stack), ingredient)
                ));
                return;
            }
            try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack.method_7972())) {
                if (capability == null) {
                    return;
                }
                FluidStack fluid = capability.extractAny(BucketFluidInventory.CAPACITY);
                if (fluid.isEmpty()) {
                    return;
                }
                class_2960 itemName = class_7923.field_41178.method_10221(stack.method_7909());
                class_2960 fluidName = class_7923.field_41173.method_10221(fluid.getFluid());
                class_2960 id = class_2960.method_60655(
                    MOD_ID,
                    "empty_" + itemName.method_12836() + "_" + itemName.method_12832() + "_with_" + fluidName.method_12836() + "_" + fluidName.method_12832()
                );
                class_1856 ingredient = stack.method_57380()
                    .method_57848() ? class_1856.method_8101(stack.method_7909()) : DefaultCustomIngredients.components(stack);
                recipes.add(new class_8786<>(
                    class_5321.method_29179(class_7924.field_52178, id),
                    new EmptyingRecipe(capability.getContainer(), fluid, ingredient)
                ));
            }
        });
        return recipes;
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<EmptyingRecipe>> getRecipeType() {
        return JeiClientPlugin.DRAINING;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.draining");
    }

    @Override
    public IDrawable getIcon() {
        return new TwoIconRenderer(AllItems.ITEM_DRAIN, class_1802.field_8705);
    }

    @Override
    public int getHeight() {
        return 50;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<EmptyingRecipe> entry, IFocusGroup focuses) {
        EmptyingRecipe recipe = entry.comp_1933();
        builder.addInputSlot(27, 8).setBackground(SLOT, -1, -1).add(recipe.ingredient());
        addFluidSlot(builder, 132, 8, recipe.fluidResult()).setBackground(SLOT, -1, -1);
        builder.addOutputSlot(132, 27).setBackground(SLOT, -1, -1).add(recipe.result());
    }

    @Override
    public void draw(class_8786<EmptyingRecipe> entry, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 62, 37);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 73, 4);
        FluidStack stack = entry.comp_1933().fluidResult();
        graphics.field_59826.method_70922(new DrainRenderState(
            new Matrix3x2f(graphics.method_51448()),
            stack.getFluid(),
            stack.getComponentChanges(),
            75,
            23
        ));
    }
}
