package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.IconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.CrafterRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_10289;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8786;
import net.minecraft.class_8957;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.List;
import java.util.Optional;

public class MechanicalCraftingCategory extends CreateCategory<class_8786<MechanicalCraftingRecipe>> {
    public static List<class_8786<MechanicalCraftingRecipe>> getRecipes(class_10289 preparedRecipes) {
        return preparedRecipes.method_64698(AllRecipeTypes.MECHANICAL_CRAFTING).stream().toList();
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<MechanicalCraftingRecipe>> getRecipeType() {
        return JeiClientPlugin.MECHANICAL_CRAFTING;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.mechanical_crafting");
    }

    @Override
    public IDrawable getIcon() {
        return new IconRenderer(AllItems.MECHANICAL_CRAFTER);
    }

    @Override
    public int getHeight() {
        return 107;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<MechanicalCraftingRecipe> entry, IFocusGroup focuses) {
        MechanicalCraftingRecipe recipe = entry.comp_1933();
        class_8957 raw = recipe.raw();
        int width = raw.method_59995();
        int height = raw.method_59996();
        List<Optional<class_1856>> layout = raw.method_59997();
        int left = 7;
        if (width < 5) {
            left += (19 * (5 - width)) / 2;
        }
        int top = 7;
        if (height < 5) {
            top += (19 * (5 - height)) / 2;
        }
        for (int h = 0; h < height; h++) {
            for (int w = 0; w < width; w++) {
                Optional<class_1856> ingredient = layout.get(h * width + w);
                if (ingredient.isEmpty()) {
                    continue;
                }
                builder.addInputSlot(left + 16 * w + (w * 3), top + 16 * h + (h * 3)).setBackground(SLOT, -1, -1).add(ingredient.get());
            }
        }
        builder.addOutputSlot(133, 80).setBackground(SLOT, -1, -1).add(recipe.result());
    }

    @Override
    public void draw(
        class_8786<MechanicalCraftingRecipe> entry,
        IRecipeSlotsView recipeSlotsView,
        class_332 graphics,
        double mouseX,
        double mouseY
    ) {
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 128, 59);
        AllGuiTextures.JEI_SHADOW.render(graphics, 113, 38);
        graphics.field_59826.method_70922(new CrafterRenderState(new Matrix3x2f(graphics.method_51448()), 124, 18));
        int size = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT).size();
        graphics.method_51433(class_310.method_1551().field_1772, String.valueOf(size), 142, 39, 0xFFFFFFFF, true);
    }
}
