package com.zurrtum.create.client.content.contraptions.actors.harvester;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterBlock;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class HarvesterRenderer implements class_827<HarvesterBlockEntity, HarvesterRenderer.HarvesterRenderState> {
    public static final class_243 PIVOT = new class_243(0, 6, 9);

    public HarvesterRenderer(class_5614.class_5615 context) {
    }

    @Override
    public HarvesterRenderState method_74335() {
        return new HarvesterRenderState();
    }

    @Override
    public void updateRenderState(
        HarvesterBlockEntity be,
        HarvesterRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = class_1921.method_23579();
        state.model = CachedBuffers.partial(AllPartialModels.HARVESTER_BLADE, state.field_62674);
        float originOffset = 1 / 16f;
        state.rotOffset = new class_243(0, PIVOT.field_1351 * originOffset, PIVOT.field_1350 * originOffset);
        float time = AnimationTickHolder.getRenderTime(be.method_10997()) / 20;
        state.angle = AngleHelper.rad((time * be.getAnimatedSpeed()) % 360);
        state.horizontalAngle = AngleHelper.rad(AngleHelper.horizontalAngle(state.field_62674.method_11654(HarvesterBlock.field_11177)));
    }

    @Override
    public void render(HarvesterRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
    }

    public static class HarvesterRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer model;
        public float angle;
        public class_243 rotOffset;
        public float horizontalAngle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            model.rotateCentered(horizontalAngle, class_2350.field_11036);
            model.translate(rotOffset.field_1352, rotOffset.field_1351, rotOffset.field_1350);
            model.rotate(angle, class_2350.field_11039);
            model.translate(-rotOffset.field_1352, -rotOffset.field_1351, -rotOffset.field_1350);
            model.light(field_62676);
            model.renderInto(matricesEntry, vertexConsumer);
        }
    }
}
