package com.zurrtum.create.client.content.equipment.bell;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.equipment.bell.AbstractBellBlockEntity;
import com.zurrtum.create.content.equipment.bell.PeculiarBellBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3709;
import net.minecraft.class_3867;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class BellRenderer<BE extends AbstractBellBlockEntity> implements class_827<BE, BellRenderer.BellRenderState> {
    public BellRenderer(class_5614.class_5615 context) {
    }

    @Override
    public BellRenderState method_74335() {
        return new BellRenderState();
    }

    @Override
    public void updateRenderState(
        BE be,
        BellRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = class_1921.method_23581();
        state.model = CachedBuffers.partial(
            be instanceof PeculiarBellBlockEntity ? AllPartialModels.PECULIAR_BELL : AllPartialModels.HAUNTED_BELL,
            state.field_62674
        );
        if (be.isRinging) {
            state.direction = be.ringDirection.method_10160();
            state.angle = getSwingAngle(be.ringingTicks + tickProgress);
        }
        class_2350 facing = state.field_62674.method_11654(class_3709.field_16324);
        class_3867 attachment = state.field_62674.method_11654(class_3709.field_16326);
        float rY = AngleHelper.horizontalAngle(facing);
        if (attachment == class_3867.field_17100 || attachment == class_3867.field_17101)
            rY += 90;
        state.upAngle = AngleHelper.rad(rY);
    }

    @Override
    public void render(BellRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
    }

    public static float getSwingAngle(float time) {
        float t = time / 1.5f;
        return 1.2f * class_3532.method_15374(t / (float) Math.PI) / (2.5f + t / 3.0f);
    }

    public static class BellRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer model;
        public float upAngle;
        public class_2350 direction;
        public float angle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (direction != null) {
                model.rotateCentered(angle, direction);
            }
            model.rotateCentered(upAngle, class_2350.field_11036);
            model.light(field_62676);
            model.renderInto(matricesEntry, vertexConsumer);
        }
    }
}
