package com.zurrtum.create.client.content.kinetics.mechanicalArm;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPoint.Mode;
import com.zurrtum.create.infrastructure.packet.c2s.ArmPlacementPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_746;

public class ArmInteractionPointHandler {

    static List<ArmInteractionPoint> currentSelection = new ArrayList<>();
    static class_1799 currentItem;

    static long lastBlockPos = -1;


    public static class_1269 rightClickingBlocksSelectsThem(class_1937 world, class_746 player, class_1268 hand, class_3965 hit) {
        if (currentItem == null)
            return null;
        if (player != null && player.method_7325())
            return null;

        class_2338 pos = hit.method_17777();
        ArmInteractionPoint selected = getSelected(pos);
        class_2680 state = world.method_8320(pos);

        if (selected == null) {
            ArmInteractionPoint point = ArmInteractionPoint.create(world, pos, state);
            if (point == null)
                return null;
            selected = point;
            put(point);
        }

        selected.cycleMode();
        if (player != null) {
            Mode mode = selected.getMode();
            class_2561 text = class_2561.method_43469(mode.getTranslationKey(), CreateLang.blockName(state).style(class_124.field_1068).component())
                .method_54663(mode.getColor());
            player.method_7353(text, true);
        }

        return class_1269.field_5812;
    }

    public static boolean leftClickingBlocksDeselectsThem(class_2338 pos) {
        if (currentItem == null)
            return false;
        return remove(pos);
    }

    public static void flushSettings(class_746 player, class_2338 pos) {
        if (currentSelection == null)
            return;

        int removed = 0;
        for (Iterator<ArmInteractionPoint> iterator = currentSelection.iterator(); iterator.hasNext(); ) {
            ArmInteractionPoint point = iterator.next();
            if (point.getPos().method_19771(pos, ArmBlockEntity.getRange()))
                continue;
            iterator.remove();
            removed++;
        }

        if (removed > 0) {
            CreateLang.builder().translate("mechanical_arm.points_outside_range", removed).style(class_124.field_1061).sendStatus(player);
        } else {
            int inputs = 0;
            int outputs = 0;
            for (ArmInteractionPoint armInteractionPoint : currentSelection) {
                if (armInteractionPoint.getMode() == Mode.DEPOSIT)
                    outputs++;
                else
                    inputs++;
            }
            if (inputs + outputs > 0)
                CreateLang.builder().translate("mechanical_arm.summary", inputs, outputs).style(class_124.field_1068).sendStatus(player);
        }

        player.field_3944.method_52787(new ArmPlacementPacket(currentSelection, pos));
        currentSelection.clear();
        currentItem = null;
    }

    public static void tick(class_310 mc) {
        class_1657 player = mc.field_1724;

        if (player == null)
            return;

        class_1799 heldItemMainhand = player.method_6047();
        if (!heldItemMainhand.method_31574(AllItems.MECHANICAL_ARM)) {
            currentItem = null;
        } else {
            if (heldItemMainhand != currentItem) {
                currentSelection.clear();
                currentItem = heldItemMainhand;
            }

            drawOutlines(currentSelection);
        }

        checkForWrench(mc, heldItemMainhand);
    }

    private static void checkForWrench(class_310 mc, class_1799 heldItem) {
        if (!heldItem.method_31574(AllItems.WRENCH)) {
            return;
        }

        class_239 objectMouseOver = mc.field_1765;
        if (!(objectMouseOver instanceof class_3965 result)) {
            return;
        }

        class_2338 pos = result.method_17777();

        class_2586 be = mc.field_1687.method_8321(pos);
        if (!(be instanceof ArmBlockEntity)) {
            lastBlockPos = -1;
            currentSelection.clear();
            return;
        }

        if (lastBlockPos == -1 || lastBlockPos != pos.method_10063()) {
            currentSelection.clear();
            ArmBlockEntity arm = (ArmBlockEntity) be;
            arm.inputs.forEach(ArmInteractionPointHandler::put);
            arm.outputs.forEach(ArmInteractionPointHandler::put);
            lastBlockPos = pos.method_10063();
        }

        if (lastBlockPos != -1) {
            drawOutlines(currentSelection);
        }
    }

    private static void drawOutlines(Collection<ArmInteractionPoint> selection) {
        for (Iterator<ArmInteractionPoint> iterator = selection.iterator(); iterator.hasNext(); ) {
            ArmInteractionPoint point = iterator.next();

            if (!point.isValid()) {
                iterator.remove();
                continue;
            }

            class_1937 level = point.getLevel();
            class_2338 pos = point.getPos();
            class_2680 state = level.method_8320(pos);
            class_265 shape = state.method_26218(level, pos);
            if (shape.method_1110())
                continue;

            int color = point.getMode().getColor();
            Outliner.getInstance().showAABB(point, shape.method_1107().method_996(pos)).colored(color).lineWidth(1 / 16f);
        }
    }

    private static void put(ArmInteractionPoint point) {
        currentSelection.add(point);
    }

    private static boolean remove(class_2338 pos) {
        ArmInteractionPoint result = getSelected(pos);
        if (result != null) {
            currentSelection.remove(result);
            return true;
        }
        return false;
    }

    private static ArmInteractionPoint getSelected(class_2338 pos) {
        for (ArmInteractionPoint point : currentSelection)
            if (point.getPos().equals(pos))
                return point;
        return null;
    }
}
