package com.zurrtum.create.client.content.kinetics.simpleRelays.encased;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.content.decoration.encasing.EncasedCTBehaviour;
import com.zurrtum.create.client.foundation.block.connected.CTSpriteShiftEntry;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

import static net.minecraft.class_2741.field_12496;

public class EncasedCogCTBehaviour extends EncasedCTBehaviour {

    private Couple<CTSpriteShiftEntry> sideShifts;
    private boolean large;

    public EncasedCogCTBehaviour(CTSpriteShiftEntry shift, Couple<CTSpriteShiftEntry> sideShifts) {
        super(shift);
        large = sideShifts == null;
        this.sideShifts = sideShifts;
    }

    @Override
    public boolean connectsTo(class_2680 state, class_2680 other, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face) {
        class_2351 axis = state.method_11654(field_12496);
        if (large || axis == face.method_10166())
            return super.connectsTo(state, other, reader, pos, otherPos, face);

        if (other.method_26204() == state.method_26204() && other.method_11654(field_12496) == state.method_11654(field_12496))
            return true;

        class_2680 blockState = reader.method_8320(otherPos.method_10093(face));
        if (!ICogWheel.isLargeCog(blockState))
            return false;

        return ((IRotate) blockState.method_26204()).getRotationAxis(blockState) == axis;
    }

    @Override
    protected boolean reverseUVs(class_2680 state, class_2350 face) {
        return state.method_11654(field_12496).method_10179() && face.method_10166().method_10179() && face.method_10171() == class_2352.field_11056;
    }

    @Override
    protected boolean reverseUVsVertically(class_2680 state, class_2350 face) {
        if (!large && state.method_11654(field_12496) == class_2351.field_11048 && face.method_10166() == class_2351.field_11051)
            return face != class_2350.field_11035;
        return super.reverseUVsVertically(state, face);
    }

    @Override
    protected boolean reverseUVsHorizontally(class_2680 state, class_2350 face) {
        if (large)
            return super.reverseUVsHorizontally(state, face);

        if (state.method_11654(field_12496).method_10178() && face.method_10166().method_10179())
            return true;

        if (state.method_11654(field_12496) == class_2351.field_11051 && face == class_2350.field_11033)
            return true;

        return super.reverseUVsHorizontally(state, face);
    }

    @Override
    public CTSpriteShiftEntry getShift(class_2680 state, class_2350 direction, @Nullable class_1058 sprite) {
        class_2351 axis = state.method_11654(field_12496);
        if (large || axis == direction.method_10166()) {
            if (axis == direction.method_10166() && state.method_11654(direction.method_10171() == class_2352.field_11056 ? EncasedCogwheelBlock.TOP_SHAFT : EncasedCogwheelBlock.BOTTOM_SHAFT))
                return null;
            return super.getShift(state, direction, sprite);
        }
        return sideShifts.get(axis == class_2351.field_11048 || axis == class_2351.field_11051 && direction.method_10166() == class_2351.field_11048);
    }

}
