package com.zurrtum.create.client.content.logistics;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.content.trains.schedule.DestinationSuggestions;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import org.lwjgl.glfw.GLFW;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class AddressEditBox extends class_342 {

    private final DestinationSuggestions destinationSuggestions;
    private final Consumer<String> mainResponder;
    private String prevValue = "=)";

    public AddressEditBox(class_437 screen, class_327 pFont, int pX, int pY, int pWidth, int pHeight, boolean anchorToBottom) {
        this(screen, pFont, pX, pY, pWidth, pHeight, anchorToBottom, null);
    }

    public AddressEditBox(class_437 screen, class_327 pFont, int pX, int pY, int pWidth, int pHeight, boolean anchorToBottom, String localAddress) {
        super(pFont, pX, pY, pWidth, pHeight, class_2561.method_43473());
        destinationSuggestions = AddressEditBoxHelper.createSuggestions(screen, this, anchorToBottom, localAddress);
        destinationSuggestions.method_23933(true);
        destinationSuggestions.method_23934();
        mainResponder = t -> {
            if (!t.equals(prevValue))
                destinationSuggestions.method_23934();
            prevValue = t;
        };
        method_1863(mainResponder);
        method_1858(false);
        method_25365(false);
        method_25402(new class_11909(0, 0, new class_11910(0, 0)), false);
        method_1880(25);
    }

    @Override
    public boolean method_25404(class_11908 input) {
        if (destinationSuggestions.method_23924(input))
            return true;
        if (method_25370() && input.comp_4795() == GLFW.GLFW_KEY_ENTER) {
            method_25365(false);
            method_1872(false);
            method_25402(new class_11909(0, 0, new class_11910(0, 0)), false);
            return true;
        }
        return super.method_25404(input);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (destinationSuggestions.method_23921(class_3532.method_15350(scrollY, -1.0D, 1.0D)))
            return true;
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        if (click.method_74245() == GLFW.GLFW_MOUSE_BUTTON_RIGHT) {
            if (method_25405(click.comp_4798(), click.comp_4799())) {
                method_1852("");
                return true;
            }
        }

        boolean wasFocused = method_25370();
        if (super.method_25402(click, doubled)) {
            if (!wasFocused) {
                method_1884(0);
                method_1875(method_1882().length());
            }
            return true;
        }
        return destinationSuggestions.method_23922(click);
    }

    @Override
    public void method_1852(String text) {
        method_1884(0);
        super.method_1852(text);
    }

    @Override
    public void method_25365(boolean focused) {
        super.method_25365(focused);
    }

    @Override
    public void method_48579(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.method_48579(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        destinationSuggestions.method_23923(pGuiGraphics, pMouseX, pMouseY);

        if (!destinationSuggestions.isEmpty())
            return;

        int itemX = method_46426() + field_22758 + 4;
        int itemY = method_46427() - 4;
        pGuiGraphics.method_51427(AllItems.CLIPBOARD.method_7854(), itemX, itemY);
        if (pMouseX >= itemX && pMouseX < itemX + 16 && pMouseY >= itemY && pMouseY < itemY + 16) {
            List<class_2561> promiseTip = List.of(
                CreateLang.translate("gui.address_box.clipboard_tip").color(ScrollInput.HEADER_RGB).component(),
                CreateLang.translate("gui.address_box.clipboard_tip_1").style(class_124.field_1080).component(),
                CreateLang.translate("gui.address_box.clipboard_tip_2").style(class_124.field_1080).component(),
                CreateLang.translate("gui.address_box.clipboard_tip_3").style(class_124.field_1080).component(),
                CreateLang.translate("gui.address_box.clipboard_tip_4").style(class_124.field_1063).component()
            );
            pGuiGraphics.method_51434(field_2105, promiseTip, pMouseX, pMouseY);
        }
    }

    @Override
    public void method_1863(Consumer<String> pResponder) {
        super.method_1863(pResponder == mainResponder ? mainResponder : mainResponder.andThen(pResponder));
    }

    public void tick() {
        if (!method_25370())
            destinationSuggestions.method_44931();
        if (method_25370() && destinationSuggestions.field_21612 == null)
            destinationSuggestions.method_23934();
        destinationSuggestions.tick();
    }
}