package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.logistics.AddressEditBox;
import com.zurrtum.create.client.content.trains.station.NoShadowFontWrapper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.FactoryPanelConfigurationPacket;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1109;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_638;

import static com.zurrtum.create.client.foundation.gui.AllGuiTextures.*;

public class FactoryPanelScreen extends AbstractSimiScreen {
    private ElementWidget renderedBlock;
    private ElementWidget renderedItem;

    private AddressEditBox addressBox;
    private IconButton confirmButton;
    private IconButton deleteButton;
    private IconButton newInputButton;
    private IconButton relocateButton;
    private IconButton activateCraftingButton;
    private ScrollInput promiseExpiration;
    private ServerFactoryPanelBehaviour behaviour;
    private boolean restocker;
    private boolean sendReset;
    private boolean sendRedstoneReset;

    private BigItemStack outputConfig;
    private List<BigItemStack> inputConfig;
    private List<FactoryPanelConnection> connections;

    private boolean craftingActive;

    public FactoryPanelScreen(ServerFactoryPanelBehaviour behaviour) {
        this.behaviour = behaviour;
        restocker = behaviour.panelBE().restocker;
        craftingActive = !behaviour.activeCraftingArrangement.isEmpty();
        updateConfigs(class_310.method_1551().field_1687);
    }

    private void updateConfigs(class_638 world) {
        connections = new ArrayList<>(behaviour.targetedBy.values());
        outputConfig = new BigItemStack(behaviour.getFilter(), behaviour.recipeOutput);
        inputConfig = connections.stream().map(c -> {
            ServerFactoryPanelBehaviour b = ServerFactoryPanelBehaviour.at(world, c.from);
            return b == null ? new BigItemStack(class_1799.field_8037, 0) : new BigItemStack(b.getFilter(), c.amount);
        }).toList();

        if (behaviour.craftingList == null) {
            craftingActive = false;
        }
    }

    @Override
    protected void method_25426() {
        int sizeX = FACTORY_GAUGE_BOTTOM.getWidth();
        int sizeY = (restocker ? FACTORY_GAUGE_RESTOCK : FACTORY_GAUGE_RECIPE).getHeight() + FACTORY_GAUGE_BOTTOM.getHeight();

        setWindowSize(sizeX, sizeY);
        super.method_25426();
        method_37067();

        int x = guiLeft;
        int y = guiTop;

        if (addressBox == null) {
            String frogAddress = behaviour.getFrogAddress();
            addressBox = new AddressEditBox(this, new NoShadowFontWrapper(field_22793), x + 36, y + windowHeight - 51, 108, 10, false, frogAddress);
            addressBox.method_1852(behaviour.recipeAddress);
            addressBox.method_1868(0xFF555555);
        }
        addressBox.method_46421(x + 36);
        addressBox.method_46419(y + windowHeight - 51);
        method_37063(addressBox);

        confirmButton = new IconButton(x + sizeX - 33, y + sizeY - 25, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> field_22787.method_1507(null));
        confirmButton.setToolTip(CreateLang.translate("gui.factory_panel.save_and_close").component());
        method_37063(confirmButton);

        deleteButton = new IconButton(x + sizeX - 55, y + sizeY - 25, AllIcons.I_TRASH);
        deleteButton.withCallback(() -> {
            sendReset = true;
            field_22787.method_1507(null);
        });
        deleteButton.setToolTip(CreateLang.translate("gui.factory_panel.reset").component());
        method_37063(deleteButton);

        promiseExpiration = new ScrollInput(x + 97, y + windowHeight - 24, 28, 16).withRange(-1, 31)
            .titled(CreateLang.translate("gui.factory_panel.promises_expire_title").component());
        promiseExpiration.setState(behaviour.promiseClearingInterval);
        method_37063(promiseExpiration);

        newInputButton = new IconButton(x + 31, y + 47, AllIcons.I_ADD);
        newInputButton.withCallback(() -> {
            FactoryPanelConnectionHandler.startConnection(behaviour);
            field_22787.method_1507(null);
        });
        newInputButton.setToolTip(CreateLang.translate("gui.factory_panel.connect_input").component());

        relocateButton = new IconButton(x + 31, y + 67, AllIcons.I_MOVE_GAUGE);
        relocateButton.withCallback(() -> {
            FactoryPanelConnectionHandler.startRelocating(behaviour);
            field_22787.method_1507(null);
        });
        relocateButton.setToolTip(CreateLang.translate("gui.factory_panel.relocate").component());

        if (!restocker) {
            method_37063(newInputButton);
            method_37063(relocateButton);
        }

        activateCraftingButton = null;
        if (behaviour.craftingList != null) {
            activateCraftingButton = new IconButton(x + 31, y + 27, AllIcons.I_3x3);
            activateCraftingButton.green = craftingActive;
            activateCraftingButton.withCallback(() -> {
                craftingActive = !craftingActive;
                clearRenderedElements();
                method_25426();
                if (craftingActive) {
                    outputConfig.count = behaviour.craftingList.getFirst().count;
                }
            });
            activateCraftingButton.setToolTip(CreateLang.translate("gui.factory_panel.activate_crafting").component());
            method_37063(activateCraftingButton);
        }

        // ITEM PREVIEW
        int previewY = restocker ? 0 : 60;
        renderedBlock = new ElementWidget(x + 195, y + 55 + previewY).showingElement(GuiGameElement.of(AllItems.FACTORY_GAUGE.method_7854())
            .scale(4));
        method_37063(renderedBlock);

        if (!behaviour.getFilter().method_7960()) {
            renderedItem = new ElementWidget(x + 214, y + 68 + previewY).showingElement(GuiGameElement.of(behaviour.getFilter()).scale(1.625F));
            method_37063(renderedItem);
        } else {
            renderedItem = null;
        }
    }

    @Override
    public void method_25419() {
        super.method_25419();
        clearRenderedElements();
    }

    private void clearRenderedElements() {
        renderedBlock.getRenderElement().clear();
        if (renderedItem != null) {
            renderedItem.getRenderElement().clear();
        }
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (inputConfig.size() != behaviour.targetedBy.size()) {
            updateConfigs(field_22787.field_1687);
            clearRenderedElements();
            method_25426();
        }
        if (activateCraftingButton != null)
            activateCraftingButton.green = craftingActive;
        addressBox.tick();
        promiseExpiration.titled(CreateLang.translate(promiseExpiration.getState() == -1 ? "gui.factory_panel.promises_do_not_expire" : "gui.factory_panel.promises_expire_title")
            .component());
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiLeft;
        int y = guiTop;

        // BG
        AllGuiTextures bg = restocker ? FACTORY_GAUGE_RESTOCK : FACTORY_GAUGE_RECIPE;
        if (restocker)
            FACTORY_GAUGE_RECIPE.render(graphics, x, y - 16);
        bg.render(graphics, x, y);
        FACTORY_GAUGE_BOTTOM.render(graphics, x, y + bg.getHeight());
        y = guiTop;

        // RECIPE
        int slot = 0;
        if (craftingActive) {
            List<BigItemStack> list = behaviour.craftingList;
            for (int i = 1, size = list.size(); i < size; i++) {
                renderInputItem(graphics, slot++, list.get(i), mouseX, mouseY);
            }
        } else {
            for (BigItemStack itemStack : inputConfig)
                renderInputItem(graphics, slot++, itemStack, mouseX, mouseY);
            if (inputConfig.isEmpty()) {
                int inputX = guiLeft + (restocker ? 88 : 68 + (slot % 3 * 20));
                int inputY = guiTop + (restocker ? 12 : 28) + (slot / 3 * 20);
                if (!restocker && mouseY > inputY && mouseY < inputY + 60 && mouseX > inputX && mouseX < inputX + 60)
                    graphics.method_51434(
                        field_22793, List.of(
                            CreateLang.translate("gui.factory_panel.unconfigured_input").color(ScrollInput.HEADER_RGB).component(),
                            CreateLang.translate("gui.factory_panel.unconfigured_input_tip").style(class_124.field_1080).component(),
                            CreateLang.translate("gui.factory_panel.unconfigured_input_tip_1").style(class_124.field_1080).component()
                        ), mouseX, mouseY
                    );
            }
        }

        if (restocker)
            renderInputItem(graphics, slot, new BigItemStack(behaviour.getFilter(), 1), mouseX, mouseY);

        if (!restocker) {
            int outputX = x + 160;
            int outputY = y + 48;
            graphics.method_51427(outputConfig.stack, outputX, outputY);
            graphics.method_51432(field_22793, behaviour.getFilter(), outputX, outputY, outputConfig.count + "");

            if (mouseX >= outputX - 1 && mouseX < outputX - 1 + 18 && mouseY >= outputY - 1 && mouseY < outputY - 1 + 18) {
                class_5250 c1 = CreateLang.translate(
                    "gui.factory_panel.expected_output",
                    CreateLang.itemName(outputConfig.stack).add(CreateLang.text(" x" + outputConfig.count)).string()
                ).color(ScrollInput.HEADER_RGB).component();
                class_5250 c2 = CreateLang.translate("gui.factory_panel.expected_output_tip").style(class_124.field_1080).component();
                class_5250 c3 = CreateLang.translate("gui.factory_panel.expected_output_tip_1").style(class_124.field_1080).component();
                class_5250 c4 = CreateLang.translate("gui.factory_panel.expected_output_tip_2").style(class_124.field_1063).style(class_124.field_1056)
                    .component();
                graphics.method_51434(field_22793, craftingActive ? List.of(c1, c2, c3) : List.of(c1, c2, c3, c4), mouseX, mouseY);
            }
        }

        Matrix3x2fStack ms = graphics.method_51448();
        ms.pushMatrix();

        // ADDRESS
        if (addressBox.method_49606() && !addressBox.method_25370())
            showAddressBoxTooltip(graphics, mouseX, mouseY);

        // TITLE
        class_2561 title = CreateLang.translate(restocker ? "gui.factory_panel.title_as_restocker" : "gui.factory_panel.title_as_recipe").component();
        graphics.method_51439(field_22793, title, x + 97 - field_22793.method_27525(title) / 2, y + (restocker ? -12 : 4), 0xFF3D3C48, false);

        // REDSTONE LINKS
        if (!behaviour.targetedByLinks.isEmpty()) {
            class_1799 asStack = AllItems.REDSTONE_LINK.method_7854();
            int itemX = x + 9;
            int itemY = y + windowHeight - 24;
            AllGuiTextures.FROGPORT_SLOT.render(graphics, itemX - 1, itemY - 1);
            graphics.method_51427(asStack, itemX, itemY);

            if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
                List<class_2561> linkTip = List.of(
                    CreateLang.translate("gui.factory_panel.has_link_connections").color(ScrollInput.HEADER_RGB).component(),
                    CreateLang.translate("gui.factory_panel.left_click_disconnect").style(class_124.field_1063).style(class_124.field_1056).component()
                );
                graphics.method_51434(field_22793, linkTip, mouseX, mouseY);
            }
        }

        // PROMISES
        int state = promiseExpiration.getState();
        graphics.method_51439(
            field_22793,
            CreateLang.text(state == -1 ? " /" : state == 0 ? "30s" : state + "m").component(),
            promiseExpiration.method_46426() + 3,
            promiseExpiration.method_46427() + 4,
            0xffeeeeee,
            true
        );

        class_1799 asStack = PackageStyles.getDefaultBox();
        int itemX = x + 68;
        int itemY = y + windowHeight - 24;
        graphics.method_51427(asStack, itemX, itemY);
        int promised = behaviour.getPromised();
        graphics.method_51432(field_22793, asStack, itemX, itemY, promised + "");

        if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
            List<class_2561> promiseTip;

            if (promised == 0) {
                promiseTip = List.of(
                    CreateLang.translate("gui.factory_panel.no_open_promises").color(ScrollInput.HEADER_RGB).component(),
                    CreateLang.translate(restocker ? "gui.factory_panel.restocker_promises_tip" : "gui.factory_panel.recipe_promises_tip")
                        .style(class_124.field_1080).component(),
                    CreateLang.translate(restocker ? "gui.factory_panel.restocker_promises_tip_1" : "gui.factory_panel.recipe_promises_tip_1")
                        .style(class_124.field_1080).component(),
                    CreateLang.translate("gui.factory_panel.promise_prevents_oversending").style(class_124.field_1080).component()
                );
            } else {
                promiseTip = List.of(
                    CreateLang.translate("gui.factory_panel.promised_items").color(ScrollInput.HEADER_RGB).component(),
                    CreateLang.text(behaviour.getFilter().method_7964().getString() + " x" + promised).component(),
                    CreateLang.translate("gui.factory_panel.left_click_reset").style(class_124.field_1063).style(class_124.field_1056).component()
                );
            }

            graphics.method_51434(field_22793, promiseTip, mouseX, mouseY);
        }

        ms.popMatrix();
    }

    //

    private void renderInputItem(class_332 graphics, int slot, BigItemStack itemStack, int mouseX, int mouseY) {
        int inputX = guiLeft + (restocker ? 88 : 68 + (slot % 3 * 20));
        int inputY = guiTop + (restocker ? 12 : 28) + (slot / 3 * 20);

        graphics.method_51427(itemStack.stack, inputX, inputY);
        if (!craftingActive && !restocker && !itemStack.stack.method_7960())
            graphics.method_51432(field_22793, itemStack.stack, inputX, inputY, itemStack.count + "");

        if (mouseX < inputX - 2 || mouseX >= inputX - 2 + 20 || mouseY < inputY - 2 || mouseY >= inputY - 2 + 20)
            return;

        if (craftingActive) {
            graphics.method_51434(
                field_22793, List.of(
                    CreateLang.translate("gui.factory_panel.crafting_input").color(ScrollInput.HEADER_RGB).component(),
                    CreateLang.translate("gui.factory_panel.crafting_input_tip").style(class_124.field_1080).component(),
                    CreateLang.translate("gui.factory_panel.crafting_input_tip_1").style(class_124.field_1080).component()
                ), mouseX, mouseY
            );
            return;
        }

        if (itemStack.stack.method_7960()) {
            graphics.method_51434(
                field_22793, List.of(
                    CreateLang.translate("gui.factory_panel.empty_panel").color(ScrollInput.HEADER_RGB).component(),
                    CreateLang.translate("gui.factory_panel.left_click_disconnect").style(class_124.field_1063).style(class_124.field_1056).component()
                ), mouseX, mouseY
            );
            return;
        }

        if (restocker) {
            graphics.method_51434(
                field_22793, List.of(
                    CreateLang.translate("gui.factory_panel.sending_item", CreateLang.itemName(itemStack.stack).string())
                        .color(ScrollInput.HEADER_RGB).component(),
                    CreateLang.translate("gui.factory_panel.sending_item_tip").style(class_124.field_1080).component(),
                    CreateLang.translate("gui.factory_panel.sending_item_tip_1").style(class_124.field_1080).component()
                ), mouseX, mouseY
            );
            return;
        }

        graphics.method_51434(
            field_22793, List.of(
                CreateLang.translate(
                    "gui.factory_panel.sending_item",
                    CreateLang.itemName(itemStack.stack).add(CreateLang.text(" x" + itemStack.count)).string()
                ).color(ScrollInput.HEADER_RGB).component(),
                CreateLang.translate("gui.factory_panel.scroll_to_change_amount").style(class_124.field_1063).style(class_124.field_1056).component(),
                CreateLang.translate("gui.factory_panel.left_click_disconnect").style(class_124.field_1063).style(class_124.field_1056).component()
            ), mouseX, mouseY
        );
    }

    private void showAddressBoxTooltip(class_332 graphics, int mouseX, int mouseY) {
        if (addressBox.method_1882().isBlank()) {
            if (restocker) {
                graphics.method_51434(
                    field_22793, List.of(
                        CreateLang.translate("gui.factory_panel.restocker_address").color(ScrollInput.HEADER_RGB).component(),
                        CreateLang.translate("gui.factory_panel.restocker_address_tip").style(class_124.field_1080).component(),
                        CreateLang.translate("gui.factory_panel.restocker_address_tip_1").style(class_124.field_1080).component(),
                        CreateLang.translate("gui.schedule.lmb_edit").style(class_124.field_1063).style(class_124.field_1056).component()
                    ), mouseX, mouseY
                );

            } else {
                graphics.method_51434(
                    field_22793, List.of(
                        CreateLang.translate("gui.factory_panel.recipe_address").color(ScrollInput.HEADER_RGB).component(),
                        CreateLang.translate("gui.factory_panel.recipe_address_tip").style(class_124.field_1080).component(),
                        CreateLang.translate("gui.factory_panel.recipe_address_tip_1").style(class_124.field_1080).component(),
                        CreateLang.translate("gui.schedule.lmb_edit").style(class_124.field_1063).style(class_124.field_1056).component()
                    ), mouseX, mouseY
                );
            }
        } else
            graphics.method_51434(
                field_22793, List.of(
                    CreateLang.translate(restocker ? "gui.factory_panel.restocker_address_given" : "gui.factory_panel.recipe_address_given")
                        .color(ScrollInput.HEADER_RGB).component(),
                    CreateLang.text("'" + addressBox.method_1882() + "'").style(class_124.field_1080).component()
                ), mouseX, mouseY
            );
    }

    //

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        if (method_25399() != null && !method_25399().method_25405(mouseX, mouseY))
            method_25395(null);

        int x = guiLeft;
        int y = guiTop;

        // Remove connections
        if (!craftingActive)
            for (int i = 0; i < connections.size(); i++) {
                int inputX = x + 68 + (i % 3 * 20);
                int inputY = y + 28 + (i / 3 * 20);
                if (mouseX >= inputX && mouseX < inputX + 16 && mouseY >= inputY && mouseY < inputY + 16) {
                    sendIt(connections.get(i).from, false);
                    playButtonSound();
                    return true;
                }
            }

        // Clear promises
        int itemX = x + 68;
        int itemY = y + windowHeight - 24;
        if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
            sendIt(null, true);
            playButtonSound();
            return true;
        }

        // remove redstone connections
        itemX = x + 9;
        itemY = y + windowHeight - 24;
        if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
            sendRedstoneReset = true;
            sendIt(null, false);
            playButtonSound();
            return true;
        }

        return super.method_25402(click, doubled);
    }

    public void playButtonSound() {
        field_22787.method_1483().method_4873(class_1109.method_4757(class_3417.field_15015.comp_349(), 1.0f, 0.25f));
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        int x = guiLeft;
        int y = guiTop;

        if (addressBox.method_25401(mouseX, mouseY, scrollX, scrollY))
            return true;

        if (craftingActive)
            return super.method_25401(mouseX, mouseY, scrollX, scrollY);

        for (int i = 0; i < inputConfig.size(); i++) {
            int inputX = x + 68 + (i % 3 * 20);
            int inputY = y + 26 + (i / 3 * 20);
            if (mouseX >= inputX && mouseX < inputX + 16 && mouseY >= inputY && mouseY < inputY + 16) {
                BigItemStack itemStack = inputConfig.get(i);
                if (itemStack.stack.method_7960())
                    return true;
                itemStack.count = class_3532.method_15340((int) (itemStack.count + Math.signum(scrollY) * (AllKeys.hasShiftDown() ? 10 : 1)), 1, 64);
                return true;
            }
        }

        if (!restocker) {
            int outputX = x + 160;
            int outputY = y + 48;
            if (mouseX >= outputX && mouseX < outputX + 16 && mouseY >= outputY && mouseY < outputY + 16) {
                BigItemStack itemStack = outputConfig;
                itemStack.count = class_3532.method_15340((int) (itemStack.count + Math.signum(scrollY) * (AllKeys.hasShiftDown() ? 10 : 1)), 1, 64);
                return true;
            }
        }

        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public void method_25432() {
        sendIt(null, false);
        super.method_25432();
    }

    private void sendIt(@Nullable FactoryPanelPosition toRemove, boolean clearPromises) {
        Map<FactoryPanelPosition, Integer> inputs = new HashMap<>();

        if (inputConfig.size() == connections.size()) {
            for (int i = 0; i < inputConfig.size(); i++) {
                BigItemStack stackInConfig = inputConfig.get(i);
                inputs.put(
                    connections.get(i).from,
                    craftingActive ? (int) behaviour.craftingList.stream().skip(1)
                        .filter(b -> !b.stack.method_7960() && class_1799.method_31577(b.stack, stackInConfig.stack))
                        .count() : stackInConfig.count
                );
            }
        }

        List<class_1799> craftingArrangement = craftingActive ? behaviour.craftingList.stream().skip(1).map(b -> b.stack).toList() : List.of();

        FactoryPanelPosition pos = behaviour.getPanelPosition();
        int promiseExp = promiseExpiration.getState();
        String address = addressBox.method_1882();

        FactoryPanelConfigurationPacket packet = new FactoryPanelConfigurationPacket(
            pos,
            address,
            inputs,
            craftingArrangement,
            outputConfig.count,
            promiseExp,
            toRemove,
            clearPromises,
            sendReset,
            sendRedstoneReset
        );
        field_22787.field_1724.field_3944.method_52787(packet);
    }

}
