package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5244;
import org.lwjgl.glfw.GLFW;

public class SchematicPromptScreen extends AbstractSimiScreen {

    private final AllGuiTextures background;

    private final class_2561 convertLabel = CreateLang.translateDirect("schematicAndQuill.convert");
    private final class_2561 abortLabel = CreateLang.translateDirect("action.discard");
    private final class_2561 confirmLabel = CreateLang.translateDirect("action.saveToFile");

    private class_342 nameField;
    private IconButton confirm;
    private IconButton abort;
    private IconButton convert;
    private ElementWidget renderedItem;

    public SchematicPromptScreen() {
        super(CreateLang.translateDirect("schematicAndQuill.title"));
        background = AllGuiTextures.SCHEMATIC_PROMPT;
    }

    @Override
    public void method_25426() {
        setWindowSize(background.getWidth(), background.getHeight());
        super.method_25426();

        int x = guiLeft;
        int y = guiTop + 2;

        nameField = new class_342(field_22793, x + 49, y + 26, 131, 10, class_5244.field_39003);
        nameField.method_1868(-1);
        nameField.method_1860(-1);
        nameField.method_1858(false);
        nameField.method_1880(35);
        nameField.method_25365(true);
        method_25395(nameField);
        method_37063(nameField);

        abort = new IconButton(x + 7, y + 53, AllIcons.I_TRASH);
        abort.withCallback(() -> {
            Create.SCHEMATIC_AND_QUILL_HANDLER.discard(field_22787);
            method_25419();
        });
        abort.setToolTip(abortLabel);
        method_37063(abort);

        confirm = new IconButton(x + 158, y + 53, AllIcons.I_CONFIRM);
        confirm.withCallback(() -> {
            confirm(false);
        });
        confirm.setToolTip(confirmLabel);
        method_37063(confirm);

        convert = new IconButton(x + 180, y + 53, AllIcons.I_SCHEMATIC);
        convert.withCallback(() -> {
            confirm(true);
        });
        convert.setToolTip(convertLabel);
        method_37063(convert);

        renderedItem = new ElementWidget(x + background.getWidth() + 6, guiTop + background.getHeight() - 38).showingElement(GuiGameElement.of(
            AllItems.SCHEMATIC_AND_QUILL.method_7854()).scale(3));
        method_37063(renderedItem);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiLeft;
        int y = guiTop;

        background.render(graphics, x, y);
        graphics.method_51439(field_22793, field_22785, x + (background.getWidth() - 8 - field_22793.method_27525(field_22785)) / 2, y + 4, 0xFF505050, false);

        graphics.method_51427(AllItems.SCHEMATIC.method_7854(), x + 22, y + 24);
    }

    @Override
    public boolean method_25404(class_11908 input) {
        int keyCode = input.comp_4795();
        if (keyCode == GLFW.GLFW_KEY_ENTER) {
            confirm(false);
            return true;
        }
        if (keyCode == 256 && this.method_25422()) {
            method_25419();
            return true;
        }
        return nameField.method_25404(input);
    }

    private void confirm(boolean convertImmediately) {
        Create.SCHEMATIC_AND_QUILL_HANDLER.saveSchematic(field_22787, nameField.method_1882(), convertImmediately);
        method_25419();
    }
}
