package com.zurrtum.create.client.content.schematics.client.tools;

import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.LineOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class RotateTool extends PlacementToolBase {

    private final LineOutline line = new LineOutline();

    @Override
    public boolean handleMouseWheel(double delta) {
        schematicHandler.getTransformation().rotate90(delta > 0);
        schematicHandler.markDirty();
        return true;
    }

    @Override
    public void renderOnSchematic(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer) {
        class_238 bounds = schematicHandler.getBounds();
        double lengthY = bounds.method_17940();
        double height = lengthY + Math.max(20, lengthY);
        class_243 center = bounds.method_1005().method_1019(schematicHandler.getTransformation().getRotationOffset(false));
        class_243 start = center.method_1023(0, height / 2, 0);
        class_243 end = center.method_1031(0, height / 2, 0);

        line.getParams().disableCull().disableLineNormals().colored(0xdddddd).lineWidth(1 / 16f);
        line.set(start, end).render(mc, ms, buffer, class_243.field_1353, AnimationTickHolder.getPartialTicks());

        super.renderOnSchematic(mc, ms, buffer);
    }

}
