package com.zurrtum.create.client.content.trains;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.placement.PlacementClient;
import com.zurrtum.create.client.content.contraptions.actors.trainControls.ControlsHandler;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.utility.ControlsUtil;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.HonkPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainHUDUpdatePacket;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3532;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

public class TrainHUD {
    static LerpedFloat displayedSpeed = LerpedFloat.linear();
    static LerpedFloat displayedThrottle = LerpedFloat.linear();
    static LerpedFloat displayedPromptSize = LerpedFloat.linear();

    static Double editedThrottle = null;
    static int hudPacketCooldown = 5;
    static int honkPacketCooldown = 5;

    public static class_2561 currentPrompt;
    public static boolean currentPromptShadow;
    public static int promptKeepAlive = 0;

    static boolean usedToHonk;

    public static void tick(class_310 mc) {
        if (promptKeepAlive > 0)
            promptKeepAlive--;
        else
            currentPrompt = null;

        displayedPromptSize.chase(currentPrompt != null ? mc.field_1772.method_27525(currentPrompt) + 17 : 0, .5f, Chaser.EXP);
        displayedPromptSize.tickChaser();

        Carriage carriage = getCarriage();
        if (carriage == null)
            return;

        Train train = carriage.train;
        double value = Math.abs(train.speed) / (train.maxSpeed() * AllConfigs.server().trains.manualTrainSpeedModifier.getF());
        value = class_3532.method_15350(value + 0.05f, 0, 1);

        displayedSpeed.chase((int) (value * 18) / 18f, .5f, Chaser.EXP);
        displayedSpeed.tickChaser();
        displayedThrottle.chase(editedThrottle != null ? editedThrottle : train.throttle, .75f, Chaser.EXP);
        displayedThrottle.tickChaser();

        boolean isSprintKeyPressed = ControlsUtil.isActuallyPressed(mc.field_1690.field_1867);

        if (isSprintKeyPressed && honkPacketCooldown-- <= 0) {
            train.determineHonk(mc.field_1687);
            if (train.lowHonk != null) {
                mc.field_1724.field_3944.method_52787(new HonkPacket(train, true));
                honkPacketCooldown = 5;
                usedToHonk = true;
            }
        }

        if (!isSprintKeyPressed && usedToHonk) {
            mc.field_1724.field_3944.method_52787(new HonkPacket(train, false));
            honkPacketCooldown = 0;
            usedToHonk = false;
        }

        if (editedThrottle == null)
            return;
        if (class_3532.method_20390(editedThrottle, train.throttle)) {
            editedThrottle = null;
            hudPacketCooldown = 5;
            return;
        }

        if (hudPacketCooldown-- <= 0) {
            mc.field_1724.field_3944.method_52787(new TrainHUDUpdatePacket(train, editedThrottle));
            hudPacketCooldown = 5;
        }
    }

    private static Carriage getCarriage() {
        if (!(ControlsHandler.getContraption() instanceof CarriageContraptionEntity cce))
            return null;
        return cce.getCarriage();
    }

    public static void renderOverlay(class_310 mc, class_332 guiGraphics, class_9779 deltaTracker) {
        float partialTicks = deltaTracker.method_60637(false);
        if (!(ControlsHandler.getContraption() instanceof CarriageContraptionEntity cce))
            return;
        Carriage carriage = cce.getCarriage();
        if (carriage == null)
            return;
        class_1297 cameraEntity = mc.method_1560();
        if (cameraEntity == null)
            return;
        class_2338 localPos = ControlsHandler.getControlsPos();
        if (localPos == null)
            return;

        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(guiGraphics.method_51421() / 2 - 91, guiGraphics.method_51443() - 29);

        // Speed, Throttle

        AllGuiTextures.TRAIN_HUD_FRAME.render(guiGraphics, -2, 1);
        AllGuiTextures.TRAIN_HUD_SPEED_BG.render(guiGraphics, 0, 0);

        int w = (int) (AllGuiTextures.TRAIN_HUD_SPEED.getWidth() * displayedSpeed.getValue(partialTicks));
        int h = AllGuiTextures.TRAIN_HUD_SPEED.getHeight();

        guiGraphics.method_25290(
            class_10799.field_56883,
            AllGuiTextures.TRAIN_HUD_SPEED.location,
            0,
            0,
            AllGuiTextures.TRAIN_HUD_SPEED.getStartX(),
            AllGuiTextures.TRAIN_HUD_SPEED.getStartY(),
            w,
            h,
            256,
            256
        );

        int promptSize = (int) displayedPromptSize.getValue(partialTicks);
        if (promptSize > 1) {

            poseStack.pushMatrix();
            poseStack.translate(promptSize / -2f + 91, -27);

            AllGuiTextures.TRAIN_PROMPT_L.render(guiGraphics, -3, 0);
            AllGuiTextures.TRAIN_PROMPT_R.render(guiGraphics, promptSize, 0);
            guiGraphics.method_25290(
                class_10799.field_56883,
                AllGuiTextures.TRAIN_PROMPT.location,
                0,
                0,
                AllGuiTextures.TRAIN_PROMPT.getStartX() + (128 - promptSize / 2f),
                AllGuiTextures.TRAIN_PROMPT.getStartY(),
                promptSize,
                AllGuiTextures.TRAIN_PROMPT.getHeight(),
                256,
                256
            );

            poseStack.popMatrix();

            class_327 font = mc.field_1772;
            if (currentPrompt != null && font.method_27525(currentPrompt) < promptSize - 10) {
                poseStack.pushMatrix();
                poseStack.translate(font.method_27525(currentPrompt) / -2f + 82, -27);
                guiGraphics.method_51439(font, currentPrompt, 9, 4, 0xFF544D45, currentPromptShadow);
                poseStack.popMatrix();
            }
        }

        AllGuiTextures.TRAIN_HUD_DIRECTION.render(guiGraphics, 77, -20);

        w = (int) (AllGuiTextures.TRAIN_HUD_THROTTLE.getWidth() * (1 - displayedThrottle.getValue(partialTicks)));
        int invW = AllGuiTextures.TRAIN_HUD_THROTTLE.getWidth() - w;
        guiGraphics.method_25290(
            class_10799.field_56883,
            AllGuiTextures.TRAIN_HUD_THROTTLE.location,
            invW,
            0,
            AllGuiTextures.TRAIN_HUD_THROTTLE.getStartX() + invW,
            AllGuiTextures.TRAIN_HUD_THROTTLE.getStartY(),
            w,
            h,
            256,
            256
        );
        AllGuiTextures.TRAIN_HUD_THROTTLE_POINTER.render(guiGraphics, Math.max(1, AllGuiTextures.TRAIN_HUD_THROTTLE.getWidth() - w) - 3, -2);

        // Direction

        class_3501 info = cce.getContraption().getBlocks().get(localPos);
        class_2350 initialOrientation = cce.getInitialOrientation().method_10160();
        boolean inverted = false;
        if (info != null && info.comp_1342().method_28498(ControlsBlock.field_11177))
            inverted = !info.comp_1342().method_11654(ControlsBlock.field_11177).equals(initialOrientation);

        boolean reversing = ControlsHandler.currentlyPressed.contains(1);
        inverted ^= reversing;
        int angleOffset = (ControlsHandler.currentlyPressed.contains(2) ? -45 : 0) + (ControlsHandler.currentlyPressed.contains(3) ? 45 : 0);
        if (reversing)
            angleOffset *= -1;

        float snapSize = 22.5f;
        float diff = AngleHelper.getShortestAngleDiff(cameraEntity.method_36454(), cce.yaw) + (inverted ? -90 : 90);
        if (Math.abs(diff) < 60)
            diff = 0;

        float angle = diff + angleOffset;
        float snappedAngle = (snapSize * Math.round(angle / snapSize)) % 360f;

        poseStack.translate(91, -9);
        poseStack.scale(0.925f, 0.925f);
        PlacementClient.textured(guiGraphics, 0, 0, 1, snappedAngle);

        poseStack.popMatrix();
    }

    public static boolean onScroll(double delta) {
        Carriage carriage = getCarriage();
        if (carriage == null)
            return false;

        double prevThrottle = editedThrottle == null ? carriage.train.throttle : editedThrottle;
        editedThrottle = class_3532.method_15350(prevThrottle + (delta > 0 ? 1 : -1) / 18f, 1 / 18f, 1);
        return true;
    }

}
