package com.zurrtum.create.client.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.trains.schedule.condition.ItemThresholdCondition;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class ItemThresholdConditionRender extends CargoThresholdConditionRender<ItemThresholdCondition> {
    @Override
    protected class_2561 getUnit(ItemThresholdCondition input) {
        return class_2561.method_43470(input.inStacks() ? "▤" : "");
    }

    @Override
    protected class_1799 getIcon(ItemThresholdCondition input) {
        return input.stack.item();
    }

    @Override
    public void setItem(ItemThresholdCondition input, int slot, class_1799 stack) {
        input.stack = FilterItemStack.of(stack);
    }

    @Override
    public class_1799 getItem(ItemThresholdCondition input, int slot) {
        return input.stack.item();
    }

    @Override
    public List<class_2561> getTitleAs(ItemThresholdCondition input, String type) {
        FilterItemStack stack = input.stack;
        return ImmutableList.of(
            CreateLang.translateDirect(
                "schedule.condition.threshold.train_holds",
                CreateLang.translateDirect("schedule.condition.threshold." + Lang.asId(input.getOperator().name()))
            ), CreateLang.translateDirect(
                "schedule.condition.threshold.x_units_of_item",
                input.getThreshold(),
                CreateLang.translateDirect("schedule.condition.threshold." + (input.inStacks() ? "stacks" : "items")),
                stack.isEmpty() ? CreateLang.translateDirect("schedule.condition.threshold.anything") : stack.isFilterItem() ? CreateLang.translateDirect(
                    "schedule.condition.threshold.matching_content") : stack.item().method_7964()
            ).method_27692(class_124.field_1062)
        );
    }

    @Override
    public void initConfigurationWidgets(ItemThresholdCondition input, ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(input, builder);
        builder.addSelectionScrollInput(
            71, 50, (i, l) -> {
                i.forOptions(ImmutableList.of(
                    CreateLang.translateDirect("schedule.condition.threshold.items"),
                    CreateLang.translateDirect("schedule.condition.threshold.stacks")
                )).titled(CreateLang.translateDirect("schedule.condition.threshold.item_measure"));
            }, "Measure"
        );
    }
}
