package com.zurrtum.create.client.content.trains.schedule.destination;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.trains.schedule.destination.FetchPackagesInstruction;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_342;

public class FetchPackagesInstructionRender extends TextScheduleInstructionRender<FetchPackagesInstruction> {
    @Override
    public Pair<class_1799, class_2561> getSummary(FetchPackagesInstruction input) {
        return Pair.of(getSecondLineIcon(), CreateLang.translateDirect("schedule.instruction.package_retrieval"));
    }

    @Override
    public List<class_2561> getTitleAs(FetchPackagesInstruction input, String type) {
        return ImmutableList.of(
            CreateLang.translate("schedule.instruction.package_retrieval.summary").style(class_124.field_1065).component(),
            CreateLang.translateDirect("generic.in_quotes", class_2561.method_43470(input.getLabelText())),
            CreateLang.translateDirect("schedule.instruction.package_retrieval.summary_1").method_27692(class_124.field_1080),
            CreateLang.translateDirect("schedule.instruction.package_retrieval.summary_2").method_27692(class_124.field_1080)
        );
    }

    @Override
    public class_1799 getSecondLineIcon() {
        return PackageStyles.getDefaultBox();
    }

    @Override
    public @Nullable List<class_2561> getSecondLineTooltip(int slot) {
        return ImmutableList.of(
            CreateLang.translateDirect("schedule.instruction.address_filter_edit_box"),
            CreateLang.translateDirect("schedule.instruction.address_filter_edit_box_1").method_27692(class_124.field_1080),
            CreateLang.translateDirect("schedule.instruction.address_filter_edit_box_2").method_27692(class_124.field_1063),
            CreateLang.translateDirect("schedule.instruction.address_filter_edit_box_3").method_27692(class_124.field_1063)
        );
    }

    @Override
    protected void modifyEditBox(class_342 box) {
        box.method_1890(s -> StringUtils.countMatches(s, '*') <= 3);
    }
}
