package com.zurrtum.create.client.flywheel.backend;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.zurrtum.create.client.flywheel.backend.gl.GlTextureUnit;
import com.zurrtum.create.client.flywheel.lib.util.ResourceUtil;
import org.jetbrains.annotations.UnknownNullability;
import org.lwjgl.opengl.GL32;

import java.io.IOException;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_10868;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class NoiseTextures {
    public static final class_2960 NOISE_TEXTURE = ResourceUtil.rl("textures/flywheel/noise/blue.png");

    @UnknownNullability
    public static class_1043 BLUE_NOISE;

    public static void reload(class_3300 manager) {
        if (BLUE_NOISE != null) {
            BLUE_NOISE.close();
            BLUE_NOISE = null;
        }
        var optional = manager.method_14486(NOISE_TEXTURE);

        if (optional.isEmpty()) {
            return;
        }

        try (var is = optional.get().method_14482()) {
            var image = class_1011.method_4310(class_1011.class_1012.field_4998, is);

            BLUE_NOISE = new class_1043(() -> "Flywheel Blue Noise", image);

            GlTextureUnit.T0.makeActive();
            GlStateManager._bindTexture(((class_10868) BLUE_NOISE.method_68004()).method_68427());

            NoiseTextures.BLUE_NOISE.method_4527(true, false);
            GlStateManager._texParameter(GL32.GL_TEXTURE_2D, GL32.GL_TEXTURE_WRAP_S, GL32.GL_REPEAT);
            GlStateManager._texParameter(GL32.GL_TEXTURE_2D, GL32.GL_TEXTURE_WRAP_T, GL32.GL_REPEAT);

            GlStateManager._bindTexture(0);
        } catch (IOException e) {

        }
    }
}
