package com.zurrtum.create.client.flywheel.impl.visualization;

import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.EntityVisualizer;
import com.zurrtum.create.client.flywheel.impl.extension.BlockEntityTypeExtension;
import com.zurrtum.create.client.flywheel.impl.extension.EntityTypeExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("unchecked")
public final class VisualizerRegistryImpl {
    @Nullable
    public static <T extends class_2586> BlockEntityVisualizer<? super T> getVisualizer(class_2591<T> type) {
        return ((BlockEntityTypeExtension<T>) type).flywheel$getVisualizer();
    }

    @Nullable
    public static <T extends class_1297> EntityVisualizer<? super T> getVisualizer(class_1299<T> type) {
        return ((EntityTypeExtension<T>) type).flywheel$getVisualizer();
    }

    public static <T extends class_2586> void setVisualizer(class_2591<T> type, @Nullable BlockEntityVisualizer<? super T> visualizer) {
        ((BlockEntityTypeExtension<T>) type).flywheel$setVisualizer(visualizer);
    }

    public static <T extends class_1297> void setVisualizer(class_1299<T> type, @Nullable EntityVisualizer<? super T> visualizer) {
        ((EntityTypeExtension<T>) type).flywheel$setVisualizer(visualizer);
    }

    private VisualizerRegistryImpl() {
    }
}
