package com.zurrtum.create.client.flywheel.lib.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.class_151;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

import static com.zurrtum.create.client.flywheel.impl.Flywheel.MOD_ID;

public final class ResourceUtil {
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType(class_2561.method_43471("argument.id.invalid"));

    private ResourceUtil() {
    }

    public static class_2960 rl(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }

    /**
     * Same as {@link class_2960#method_60654(String)}, but defaults to Flywheel namespace.
     */
    public static class_2960 parseFlywheelDefault(String location) {
        String namespace = MOD_ID;
        String path = location;
        int i = location.indexOf(58);
        if (i >= 0) {
            path = location.substring(i + 1);
            if (i >= 1) {
                namespace = location.substring(0, i);
            }
        }

        return class_2960.method_60655(namespace, path);
    }

    /**
     * Same as {@link class_2960#method_12835(StringReader)}, but defaults to Flywheel namespace.
     */
    public static class_2960 readFlywheelDefault(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();

        while (reader.canRead() && class_2960.method_12831(reader.peek())) {
            reader.skip();
        }

        String s = reader.getString().substring(i, reader.getCursor());

        try {
            return parseFlywheelDefault(s);
        } catch (class_151 var4) {
            reader.setCursor(i);
            throw ERROR_INVALID.createWithContext(reader);
        }
    }

    /**
     * Same as {@link class_2960#method_36181()}, but also removes the file extension.
     */
    public static String toDebugFileNameNoExtension(class_2960 resourceLocation) {
        String stringLoc = resourceLocation.method_36181();
        return stringLoc.substring(0, stringLoc.lastIndexOf('.'));
    }
}
