package com.zurrtum.create.client.foundation.blockEntity.behaviour;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import org.apache.commons.lang3.tuple.Pair;

import java.util.function.Function;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_4587;

public abstract class ValueBoxTransform {

    protected float scale = getScale();

    public abstract class_243 getLocalOffset(class_2680 state);

    public abstract void rotate(class_2680 state, class_4587 ms);

    public boolean testHit(class_1936 level, class_2338 pos, class_2680 state, class_243 localHit) {
        class_243 offset = getLocalOffset(state);
        if (offset == null)
            return false;
        return localHit.method_1022(offset) < scale / 2;
    }

    public void transform(class_2680 state, class_4587 ms) {
        class_243 position = getLocalOffset(state);
        if (position == null)
            return;
        ms.method_22904(position.field_1352, position.field_1351, position.field_1350);
        rotate(state, ms);
        ms.method_22905(scale, scale, scale);
    }

    public boolean shouldRender(class_2680 state) {
        return !state.method_26215() && getLocalOffset(state) != null;
    }

    public int getOverrideColor() {
        return -1;
    }

    protected class_243 rotateHorizontally(class_2680 state, class_243 vec) {
        float yRot = 0;
        if (state.method_28498(class_2741.field_12525))
            yRot = AngleHelper.horizontalAngle(state.method_11654(class_2741.field_12525));
        if (state.method_28498(class_2741.field_12481))
            yRot = AngleHelper.horizontalAngle(state.method_11654(class_2741.field_12481));
        return VecHelper.rotateCentered(vec, yRot, class_2351.field_11052);
    }

    public float getScale() {
        return .5f;
    }

    public float getFontScale() {
        return 1 / 64f;
    }

    public static abstract class Dual extends ValueBoxTransform {

        protected boolean first;

        public Dual(boolean first) {
            this.first = first;
        }

        public boolean isFirst() {
            return first;
        }

        public static Pair<ValueBoxTransform, ValueBoxTransform> makeSlots(Function<Boolean, ? extends Dual> factory) {
            return Pair.of(factory.apply(true), factory.apply(false));
        }

        @Override
        public boolean testHit(class_1936 level, class_2338 pos, class_2680 state, class_243 localHit) {
            class_243 offset = getLocalOffset(state);
            if (offset == null)
                return false;
            return localHit.method_1022(offset) < scale / 3.5f;
        }

    }

    public static abstract class Sided extends ValueBoxTransform {

        protected class_2350 direction = class_2350.field_11036;

        public void fromSide(class_2350 direction) {
            this.direction = direction;
        }

        @Override
        public class_243 getLocalOffset(class_2680 state) {
            class_243 location = getSouthLocation();
            location = VecHelper.rotateCentered(location, AngleHelper.horizontalAngle(getSide()), class_2351.field_11052);
            location = VecHelper.rotateCentered(location, AngleHelper.verticalAngle(getSide()), class_2351.field_11048);
            return location;
        }

        protected abstract class_243 getSouthLocation();

        @Override
        public void rotate(class_2680 state, class_4587 ms) {
            float yRot = AngleHelper.horizontalAngle(getSide()) + 180;
            float xRot = getSide() == class_2350.field_11036 ? 90 : getSide() == class_2350.field_11033 ? 270 : 0;
            TransformStack.of(ms).rotateYDegrees(yRot).rotateXDegrees(xRot);
        }

        @Override
        public boolean shouldRender(class_2680 state) {
            return super.shouldRender(state) && isSideActive(state, getSide());
        }

        @Override
        public boolean testHit(class_1936 level, class_2338 pos, class_2680 state, class_243 localHit) {
            return isSideActive(state, getSide()) && super.testHit(level, pos, state, localHit);
        }

        protected boolean isSideActive(class_2680 state, class_2350 direction) {
            return true;
        }

        public class_2350 getSide() {
            return direction;
        }

    }

}
