package com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue;


import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.content.kinetics.crank.ValveHandleValueBox;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsBoard;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.crank.ValveHandleBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

public class ValveHandleScrollValueBehaviour extends ScrollValueBehaviour<ValveHandleBlockEntity, ServerScrollValueBehaviour> {

    public ValveHandleScrollValueBehaviour(ValveHandleBlockEntity be) {
        super(CreateLang.translateDirect("kinetics.valve_handle.rotated_angle"), be, new ValveHandleValueBox());
        withFormatter(v -> Math.abs(v) + CreateLang.translateDirect("generic.unit.degrees").getString());
        onlyActiveWhen(be::showValue);
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        ImmutableList<class_2561> rows = ImmutableList.of(
            class_2561.method_43470("\u27f3").method_27692(class_124.field_1067),
            class_2561.method_43470("\u27f2").method_27692(class_124.field_1067)
        );
        return new ValueSettingsBoard(label, 180, 45, rows, new ValueSettingsFormatter(this::formatValue));
    }

    public class_5250 formatValue(ValueSettings settings) {
        return CreateLang.number(Math.max(1, Math.abs(settings.value()))).add(CreateLang.translateDirect("generic.unit.degrees")).component();
    }
}