package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.catnip.lang.LangBuilder;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.base.IRotate.StressImpact;
import com.zurrtum.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.zurrtum.create.infrastructure.packet.c2s.GaugeObservedPacket;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class StressGaugeTooltipBehaviour extends GaugeTooltipBehaviour<StressGaugeBlockEntity> {
    public StressGaugeTooltipBehaviour(StressGaugeBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (!StressImpact.isEnabled())
            return false;

        super.addToGoggleTooltip(tooltip, isPlayerSneaking);

        double capacity = blockEntity.getNetworkCapacity();
        float networkStress = blockEntity.getNetworkStress();
        double stressFraction = networkStress / (capacity == 0 ? 1 : capacity);

        CreateLang.translate("gui.stressometer.title").style(class_124.field_1080).forGoggles(tooltip);

        if (blockEntity.getTheoreticalSpeed() == 0)
            CreateLang.text(TooltipHelper.makeProgressBar(3, 0)).translate("gui.stressometer.no_rotation").style(class_124.field_1063)
                .forGoggles(tooltip);
        else {
            getFormattedStressText(stressFraction).forGoggles(tooltip);
            CreateLang.translate("gui.stressometer.capacity").style(class_124.field_1080).forGoggles(tooltip);

            double remainingCapacity = capacity - networkStress;

            LangBuilder su = CreateLang.translate("generic.unit.stress");
            LangBuilder stressTip = CreateLang.number(remainingCapacity).add(su).style(StressImpact.of(stressFraction).getRelativeColor());

            if (remainingCapacity != capacity)
                stressTip.text(class_124.field_1080, " / ").add(CreateLang.number(capacity).add(su).style(class_124.field_1063));

            stressTip.forGoggles(tooltip, 1);
        }

        class_2338 pos = blockEntity.method_11016();
        if (!pos.equals(StressGaugeBlockEntity.lastSent))
            class_310.method_1551().field_1724.field_3944.method_52787(new GaugeObservedPacket(StressGaugeBlockEntity.lastSent = pos));

        return true;
    }

    public static LangBuilder getFormattedStressText(double stressPercent) {
        StressImpact stressLevel = StressImpact.of(stressPercent);
        return CreateLang.text(TooltipHelper.makeProgressBar(3, Math.min(stressLevel.ordinal() + 1, 3)))
            .translate("tooltip.stressImpact." + Lang.asId(stressLevel.name())).text(String.format(" (%s%%) ", (int) (stressPercent * 100)))
            .style(stressLevel.getRelativeColor());
    }
}
