package com.zurrtum.create.client.foundation.gui;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.TooltipArea;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;

public class ModularGuiLine {

    List<Pair<class_339, String>> widgets;
    List<Couple<Integer>> customBoxes;
    boolean speechBubble;

    public ModularGuiLine() {
        widgets = new ArrayList<>();
        customBoxes = new ArrayList<>();
        speechBubble = false;
    }

    public void renderWidgetBG(int guiLeft, class_332 graphics) {
        boolean first = true;

        if (!customBoxes.isEmpty()) {
            for (Couple<Integer> couple : customBoxes) {
                int x = couple.getFirst() + guiLeft;
                int width = couple.getSecond();
                box(graphics, x, width, first & speechBubble);
                first = false;
            }
            return;
        }

        for (Pair<class_339, String> pair : widgets) {
            if (pair.getSecond().equals("Dummy"))
                continue;

            class_339 aw = pair.getFirst();
            int x = aw.method_46426();
            int width = aw.method_25368();

            if (aw instanceof class_342) {
                x -= 5;
                width += 9;
            }

            box(graphics, x, width, first & speechBubble);
            first = false;
        }
    }

    private void box(class_332 graphics, int x, int width, boolean b) {
        UIRenderHelper.drawStretched(graphics, x, 0, width, 18, AllGuiTextures.DATA_AREA);
        if (b)
            AllGuiTextures.DATA_AREA_SPEECH.render(graphics, x - 3, 0);
        else
            AllGuiTextures.DATA_AREA_START.render(graphics, x, 0);
        AllGuiTextures.DATA_AREA_END.render(graphics, x + width - 2, 0);
    }

    public void saveValues(class_2487 data) {
        for (Pair<class_339, String> pair : widgets) {
            class_339 w = pair.getFirst();
            String key = pair.getSecond();
            if (w instanceof class_342 eb)
                data.method_10582(key, eb.method_1882());
            if (w instanceof ScrollInput si)
                data.method_10569(key, si.getState());
        }
    }

    @SuppressWarnings("unchecked")
    public <T extends class_364 & class_4068 & class_6379> void loadValues(class_2487 data, Consumer<T> addRenderable, Consumer<T> addRenderableOnly) {
        for (Pair<class_339, String> pair : widgets) {
            class_339 w = pair.getFirst();
            String key = pair.getSecond();
            if (w instanceof class_342 eb)
                eb.method_1852(data.method_68564(key, ""));
            if (w instanceof ScrollInput si)
                si.setState(data.method_68083(key, 0));

            if (w instanceof TooltipArea)
                addRenderableOnly.accept((T) w);
            else
                addRenderable.accept((T) w);
        }
    }

    public void forEach(Consumer<class_364> callback) {
        widgets.forEach(p -> callback.accept(p.getFirst()));
    }

    public void clear() {
        widgets.clear();
        customBoxes.clear();
    }

    public void add(Pair<class_339, String> pair) {
        widgets.add(pair);
    }

}
