package com.zurrtum.create.client.foundation.gui.render;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.content.processing.burner.BlazeBurnerRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock.HeatLevel;
import net.minecraft.class_11239;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.client.render.*;

public class BlazeBurnerElementRenderer extends class_11239<BlazeBurnerRenderState> {
    public BlazeBurnerElementRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @Override
    protected void render(BlazeBurnerRenderState state, class_4587 matrices) {
        class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        matrices.method_22905(1, 1, -1);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-22.5f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-45));
        matrices.method_22905(1, -1, 1);
        float horizontalAngle = AngleHelper.rad(270);
        boolean canDrawFlame = state.heatLevel().isAtLeast(HeatLevel.FADING);
        PartialModel drawHat = AllPartialModels.LOGISTICS_HAT;

        class_4588 cutout = field_59933.method_73477(class_1921.method_23579());
        CachedBuffers.partial(AllPartialModels.BLAZE_CAGE, state.block()).rotateCentered(horizontalAngle + class_3532.field_29844, class_2350.field_11036)
            .light(class_765.field_32767).renderInto(matrices.method_23760(), cutout);

        class_11684 renderDispatcher = class_310.method_1551().field_1773.method_72911();
        class_11661 queue = renderDispatcher.method_73003();
        BlazeBurnerRenderer.getBlazeBurnerRenderData(
            state.world(),
            state.block(),
            state.heatLevel(),
            state.animation(),
            horizontalAngle,
            canDrawFlame,
            state.drawGoggles(),
            drawHat,
            state.hash()
        ).render(matrices, queue);
        renderDispatcher.method_73002();
    }

    @Override
    protected float method_70907(int height, int windowScaleFactor) {
        return height / 1.6f;
    }

    @Override
    protected String method_70906() {
        return "Blaze Burner";
    }

    @Override
    public Class<BlazeBurnerRenderState> method_70903() {
        return BlazeBurnerRenderState.class;
    }
}
