package com.zurrtum.create.client.foundation.gui.widget;

import com.zurrtum.create.client.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class SelectionScrollInput extends ScrollInput {

    private final class_5250 scrollToSelect = CreateLang.translateDirect("gui.scrollInput.scrollToSelect");
    protected List<? extends class_2561> options;

    public SelectionScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        options = new ArrayList<>();
        inverted();
    }

    public ScrollInput forOptions(List<? extends class_2561> options) {
        this.options = options;
        this.max = options.size();
        format(options::get);
        updateTooltip();
        return this;
    }

    @Override
    protected void updateTooltip() {
        toolTip.clear();
        if (title == null)
            return;
        toolTip.add(title.method_27662().method_27694(s -> s.method_36139(HEADER_RGB.getRGB())));
        int min = Math.min(this.max - 16, state - 7);
        int max = Math.max(this.min + 16, state + 8);
        min = Math.max(min, this.min);
        max = Math.min(max, this.max);
        if (this.min + 1 == min)
            min--;
        if (min > this.min) {
            toolTip.add(class_2561.method_43470("> ...").method_27692(class_124.field_1080));
        }
        if (this.max - 1 == max)
            max++;
        for (int i = min; i < max; i++) {
            if (i == state)
                toolTip.add(class_2561.method_43473().method_27693("-> ").method_10852(options.get(i)).method_27692(class_124.field_1068));
            else
                toolTip.add(class_2561.method_43473().method_27693("> ").method_10852(options.get(i)).method_27692(class_124.field_1080));
        }
        if (max < this.max) {
            toolTip.add(class_2561.method_43470("> ...").method_27692(class_124.field_1080));
        }

        if (hint != null)
            toolTip.add(hint.method_27662().method_27694(s -> s.method_36139(HINT_RGB.getRGB())));
        toolTip.add(scrollToSelect.method_27662().method_27695(class_124.field_1063, class_124.field_1056));
    }

}
